/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.predict.ordrec;

import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.lenskit.transform.quantize.Quantizer;

class OrdRecModel {
    private int levelCount;
    private double t1;
    private ArrayRealVector beta;
    private RealVector qtzValues;

    OrdRecModel(Quantizer qtz) {
        this.qtzValues = qtz.getValues();
        this.levelCount = this.qtzValues.getDimension();
        this.t1 = (this.qtzValues.getEntry(0) + this.qtzValues.getEntry(1)) / 2.0;
        this.beta = new ArrayRealVector(this.levelCount - 2);
        double tr = this.t1;
        for (int i = 1; i <= this.beta.getDimension(); ++i) {
            double trnext = (this.qtzValues.getEntry(i) + this.qtzValues.getEntry(i + 1)) * 0.5;
            this.beta.setEntry(i - 1, Math.log(trnext - tr));
            tr = trnext;
        }
    }

    public double getT1() {
        return this.t1;
    }

    public RealVector getBeta() {
        return this.beta;
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public double getThreshold(int thresholdIndex) {
        double tr = this.t1;
        if (thresholdIndex < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (thresholdIndex == 0) {
            return tr;
        }
        if (thresholdIndex > this.beta.getDimension()) {
            return Double.POSITIVE_INFINITY;
        }
        for (int k = 0; k < thresholdIndex; ++k) {
            tr += Math.exp(this.beta.getEntry(k));
        }
        return tr;
    }

    public double getProbLE(double score, int r) {
        return 1.0 / (1.0 + Math.exp(score - this.getThreshold(r)));
    }

    public double getProbEQ(double score, int r) {
        return this.getProbLE(score, r) - this.getProbLE(score, r - 1);
    }

    public void getProbDistribution(double score, RealVector vec) {
        double pre = this.getProbLE(score, 0);
        vec.setEntry(0, pre);
        for (int i = 1; i < this.getLevelCount(); ++i) {
            double pro = this.getProbLE(score, i);
            vec.setEntry(i, pro - pre);
            pre = pro;
        }
    }

    public void update(double dt1, RealVector dbeta) {
        this.t1 += dt1;
        this.beta.combineToSelf(1.0, 1.0, dbeta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OrdRecParams(t1=").append(this.t1).append(", beta=").append(this.beta).append(")");
        return sb.toString();
    }
}

