/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.funksvd;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.grouplens.grapht.annotation.DefaultProvider;
import org.lenskit.inject.Shareable;
import org.lenskit.mf.funksvd.FeatureInfo;
import org.lenskit.mf.funksvd.FunkSVDModelProvider;
import org.lenskit.mf.svd.MFModel;
import org.lenskit.util.keys.KeyIndex;

@DefaultProvider(value=FunkSVDModelProvider.class)
@Shareable
public final class FunkSVDModel
extends MFModel {
    private static final long serialVersionUID = 3L;
    private final List<FeatureInfo> featureInfo;
    private final RealVector averageUser;

    public FunkSVDModel(RealMatrix umat, RealMatrix imat, KeyIndex uidx, KeyIndex iidx, List<FeatureInfo> features) {
        super(umat, imat, uidx, iidx);
        this.featureInfo = ImmutableList.copyOf(features);
        double[] means = new double[this.featureCount];
        for (int f = this.featureCount - 1; f >= 0; --f) {
            means[f] = this.featureInfo.get(f).getUserAverage();
        }
        this.averageUser = MatrixUtils.createRealVector((double[])means);
    }

    public FeatureInfo getFeatureInfo(int f) {
        return this.featureInfo.get(f);
    }

    public List<FeatureInfo> getFeatureInfo() {
        return this.featureInfo;
    }

    public RealVector getAverageUserVector() {
        return this.averageUser;
    }
}

