/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.funksvd;

import java.io.Serializable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.grouplens.lenskit.iterative.LearningRate;
import org.grouplens.lenskit.iterative.RegularizationTerm;
import org.grouplens.lenskit.iterative.StoppingCondition;
import org.grouplens.lenskit.iterative.TrainingLoopController;
import org.lenskit.api.ItemScorer;
import org.lenskit.baseline.BaselineScorer;
import org.lenskit.data.ratings.PreferenceDomain;
import org.lenskit.data.ratings.RatingMatrix;
import org.lenskit.inject.Shareable;
import org.lenskit.mf.funksvd.FunkSVDUpdater;
import org.lenskit.mf.funksvd.TrainingEstimator;

@Shareable
public final class FunkSVDUpdateRule
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double learningRate;
    private final double trainingRegularization;
    private final ItemScorer baseline;
    private final StoppingCondition stoppingCondition;
    @Nullable
    private final PreferenceDomain domain;

    @Inject
    public FunkSVDUpdateRule(@LearningRate double lrate, @RegularizationTerm double reg, @BaselineScorer ItemScorer bl, @Nullable PreferenceDomain dom, StoppingCondition stop) {
        this.learningRate = lrate;
        this.trainingRegularization = reg;
        this.baseline = bl;
        this.domain = dom;
        this.stoppingCondition = stop;
    }

    public TrainingEstimator makeEstimator(RatingMatrix snapshot) {
        return new TrainingEstimator(snapshot, this.baseline, this.domain);
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getTrainingRegularization() {
        return this.trainingRegularization;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    @Nullable
    public PreferenceDomain getDomain() {
        return this.domain;
    }

    public TrainingLoopController getTrainingLoopController() {
        return this.stoppingCondition.newLoop();
    }

    public FunkSVDUpdater createUpdater() {
        return new FunkSVDUpdater(this);
    }
}

