/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.funksvd;

import it.unimi.dsi.fastutil.longs.Long2DoubleFunction;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.linear.RealVector;
import org.lenskit.api.ItemScorer;
import org.lenskit.data.ratings.PreferenceDomain;
import org.lenskit.data.ratings.RatingMatrix;
import org.lenskit.data.ratings.RatingMatrixEntry;
import org.lenskit.util.collections.LongUtils;

public final class TrainingEstimator {
    private final List<RatingMatrixEntry> ratings;
    private final double[] estimates;
    private final PreferenceDomain domain;

    TrainingEstimator(RatingMatrix snap, ItemScorer baseline, PreferenceDomain dom) {
        this.ratings = snap.getRatings();
        this.domain = dom;
        this.estimates = new double[this.ratings.size()];
        LongCollection userIds = snap.getUserIds();
        LongIterator userIter = userIds.iterator();
        while (userIter.hasNext()) {
            long uid = userIter.nextLong();
            Long2DoubleMap rvector = snap.getUserRatingVector(uid);
            Long2DoubleFunction blpreds = LongUtils.asLong2DoubleFunction((Map)baseline.score(uid, (Collection)rvector.keySet()));
            for (RatingMatrixEntry r : snap.getUserRatings(uid)) {
                this.estimates[r.getIndex()] = blpreds.get(r.getItemId());
            }
        }
    }

    public double get(RatingMatrixEntry pref) {
        return this.estimates[pref.getIndex()];
    }

    public void update(RealVector ufvs, RealVector ifvs) {
        for (RatingMatrixEntry r : this.ratings) {
            int idx = r.getIndex();
            double est = this.estimates[idx];
            est += ufvs.getEntry(r.getUserIndex()) * ifvs.getEntry(r.getItemIndex());
            if (this.domain != null) {
                est = this.domain.clampValue(est);
            }
            this.estimates[idx] = est;
        }
    }
}

