/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.svd;

import it.unimi.dsi.fastutil.longs.Long2DoubleFunction;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.math3.linear.RealVector;
import org.lenskit.api.ItemScorer;
import org.lenskit.api.Result;
import org.lenskit.api.ResultMap;
import org.lenskit.baseline.BaselineScorer;
import org.lenskit.basic.AbstractItemScorer;
import org.lenskit.mf.svd.BiasedMFKernel;
import org.lenskit.mf.svd.MFModel;
import org.lenskit.results.BasicResult;
import org.lenskit.results.Results;
import org.lenskit.util.collections.LongUtils;

public class BiasedMFItemScorer
extends AbstractItemScorer {
    private final MFModel model;
    private final BiasedMFKernel kernel;
    private final ItemScorer baseline;

    @Inject
    public BiasedMFItemScorer(MFModel mod, BiasedMFKernel kern, @BaselineScorer ItemScorer bl) {
        this.model = mod;
        this.kernel = kern;
        this.baseline = bl;
    }

    @Nullable
    protected RealVector getUserPreferenceVector(long user) {
        return this.model.getUserVector(user);
    }

    public MFModel getModel() {
        return this.model;
    }

    @Nonnull
    public ResultMap scoreWithDetails(long user, @Nonnull Collection<Long> items) {
        Long2DoubleFunction base = LongUtils.asLong2DoubleFunction((Map)this.baseline.score(user, items));
        RealVector uvec = this.getUserPreferenceVector(user);
        if (uvec == null) {
            return Results.newResultMap((Result[])new Result[0]);
        }
        ArrayList<BasicResult> results = new ArrayList<BasicResult>(items.size());
        LongIterator iter = LongIterators.asLongIterator(items.iterator());
        while (iter.hasNext()) {
            long item = iter.nextLong();
            RealVector ivec = this.model.getItemVector(item);
            if (ivec == null) continue;
            double score = this.kernel.apply(base.get(item), uvec, ivec);
            results.add(Results.create((long)item, (double)score));
        }
        return Results.newResultMap(results);
    }
}

