/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.svd;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import org.apache.commons.math3.linear.RealVector;
import org.lenskit.data.ratings.PreferenceDomain;
import org.lenskit.inject.Shareable;
import org.lenskit.mf.svd.BiasedMFKernel;

@Shareable
@Immutable
public class DomainClampingKernel
implements BiasedMFKernel,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PreferenceDomain domain;

    @Inject
    public DomainClampingKernel(PreferenceDomain dom) {
        this.domain = dom;
    }

    @Override
    public double apply(double bias, @Nonnull RealVector user, @Nonnull RealVector item) {
        int n = user.getDimension();
        Preconditions.checkArgument((item.getDimension() == n ? 1 : 0) != 0, (Object)"vectors have different lengths");
        double result = bias;
        for (int i = 0; i < n; ++i) {
            result = this.domain.clampValue(result + user.getEntry(i) * item.getEntry(i));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainClampingKernel that = (DomainClampingKernel)o;
        return this.domain.equals((Object)that.domain);
    }

    public int hashCode() {
        return this.domain.hashCode();
    }

    public String toString() {
        return "ClampKernel(" + this.domain + ")";
    }
}

