/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.libj.io.DelegateInputStream;

public class CountingInputStream
extends DelegateInputStream {
    protected long count;
    private long mark = -1L;

    public CountingInputStream(InputStream in) {
        super(Objects.requireNonNull(in));
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1) {
            ++this.count;
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.count += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.count += skip;
        return skip;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count = this.mark;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

