/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.Reader;
import org.libj.io.DelegateReader;

public class CountingReader
extends DelegateReader {
    protected long count;
    private long mark = -1L;

    public CountingReader(Reader in) {
        super(in);
    }

    protected CountingReader() {
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1) {
            ++this.count;
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = this.in.read(cbuf, off, len);
        if (read > 0) {
            this.count += (long)read;
        }
        return read;
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.ready();
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.count += skip;
        return skip;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            this.in.mark(readlimit);
            this.mark = this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        Reader reader = this.in;
        synchronized (reader) {
            this.in.reset();
            this.count = this.mark;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

