/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.Reader;

public final class Readers {
    public static String readFully(Reader reader) throws IOException {
        return Readers.readFully(reader, new StringBuilder()).toString();
    }

    public static StringBuilder readFully(Reader reader, StringBuilder builder) throws IOException {
        int ch;
        while ((ch = reader.read()) != -1) {
            builder.append((char)ch);
        }
        return builder;
    }

    public static String readFully(Reader reader, int bufferSize) throws IOException {
        return Readers.readFully(reader, new StringBuilder(), bufferSize).toString();
    }

    public static StringBuilder readFully(Reader reader, StringBuilder builder, int bufferSize) throws IOException {
        int size;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size (" + bufferSize + ") must be greater than 0");
        }
        char[] cbuf = new char[bufferSize];
        while ((size = reader.read(cbuf)) > 0) {
            builder.append(cbuf, 0, size);
        }
        return builder;
    }

    private Readers() {
    }
}

