/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.libj.io.DelegateInputStream;

public class ReplayInputStream
extends DelegateInputStream {
    protected final ReadbackByteArrayOutputStream buffer;
    private volatile boolean closed;

    public ReplayInputStream(InputStream in, int initialSize) {
        super(Objects.requireNonNull(in));
        this.buffer = new ReadbackByteArrayOutputStream(initialSize);
    }

    public ReplayInputStream(InputStream in) {
        super(Objects.requireNonNull(in));
        this.buffer = new ReadbackByteArrayOutputStream();
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.available() > 0) {
            return this.buffer.read();
        }
        if (this.closed) {
            return -1;
        }
        int ch = this.in.read();
        if (ch != -1) {
            this.buffer.write(ch);
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.buffer.available();
        if (avail >= len) {
            return this.buffer.read(b, off, len);
        }
        if (avail > 0) {
            int ch;
            this.buffer.read(b, off, avail);
            while (avail < b.length && (ch = this.read()) != -1) {
                b[off + avail++] = (byte)ch;
            }
            return avail;
        }
        if (this.closed) {
            return -1;
        }
        int ch = this.in.read(b, off, len);
        if (ch > 0) {
            this.buffer.write(b, off, ch);
        }
        return ch;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("Skip value is negative: " + n);
        }
        int avail = this.buffer.available();
        if ((long)avail >= n) {
            return this.buffer.skip(n);
        }
        if (avail > 0) {
            this.buffer.skip(avail);
            while ((long)avail++ < n && this.read() != -1) {
            }
            return avail;
        }
        while (this.read() != -1 && (long)(++avail) < n) {
        }
        return avail;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.available() + this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
        this.in.close();
        this.closed = true;
    }

    protected class ReadbackByteArrayOutputStream
    extends ByteArrayOutputStream {
        private int total;
        private int mark;

        public ReadbackByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        public ReadbackByteArrayOutputStream() {
        }

        public byte[] buf() {
            return this.buf;
        }

        @Override
        public void write(int c) {
            if (ReplayInputStream.this.closed) {
                return;
            }
            super.write(c);
            ++this.total;
        }

        @Override
        public void write(byte[] c, int off, int len) {
            if (ReplayInputStream.this.closed) {
                return;
            }
            super.write(c, off, len);
            this.total += len;
        }

        public int read() {
            return ReplayInputStream.this.closed || this.count >= this.total ? -1 : this.buf[this.count++];
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (ReplayInputStream.this.closed || this.count >= this.total) {
                return -1;
            }
            int delta = len - this.available() - 1;
            int length = 0 < delta ? len - delta : len;
            System.arraycopy(this.buf, this.count, b, off, length);
            this.count += length;
            return length;
        }

        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Skip value is negative: " + n);
            }
            return this.skip0(n);
        }

        private long skip0(long n) {
            if (ReplayInputStream.this.closed || this.count >= this.total || n <= 0L) {
                return 0L;
            }
            long check = (long)(this.total - this.count) - n;
            long length = check < 0L ? n + check : n;
            this.count = (int)((long)this.count + length);
            return length;
        }

        public int available() {
            return ReplayInputStream.this.closed ? 0 : this.total - this.count;
        }

        public void mark() {
            this.mark = this.count;
        }

        private void reset0(int p) {
            if (p > this.count) {
                this.skip0(p - this.count);
            }
            this.count = p;
        }

        public void reset(int p) {
            if (p < 0) {
                throw new IllegalArgumentException("Position (" + p + ") must be non-negative");
            }
            if (this.total < p) {
                throw new IllegalArgumentException("Position (" + p + ") must be less than the buffer length (" + this.total + ")");
            }
            this.reset0(p);
        }

        @Override
        public void reset() {
            this.reset0(this.mark);
        }

        @Override
        public void close() {
            this.buf = null;
        }
    }
}

