/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class ReplayReader
extends FilterReader {
    protected final ReadbackCharArrayWriter buffer;
    protected boolean closed;

    public ReplayReader(Reader in, int initialSize) {
        super(in);
        this.buffer = new ReadbackCharArrayWriter(initialSize);
    }

    public ReplayReader(Reader in) {
        super(in);
        this.buffer = new ReadbackCharArrayWriter();
    }

    @Override
    public boolean ready() throws IOException {
        return this.buffer.available() > 0 || this.in.ready();
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.available() > 0) {
            return this.buffer.read();
        }
        if (this.closed) {
            return -1;
        }
        int ch = this.in.read();
        if (ch != -1) {
            this.buffer.write(ch);
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int avail = this.buffer.available();
        if (avail >= len) {
            return this.buffer.read(cbuf, off, len);
        }
        if (avail > 0) {
            int ch;
            this.buffer.read(cbuf, off, avail);
            while (avail < cbuf.length - off && (ch = this.read()) != -1) {
                cbuf[off + avail++] = (char)ch;
            }
            return avail;
        }
        if (this.closed) {
            return -1;
        }
        int ch = this.in.read(cbuf, off, len);
        if (ch > 0) {
            this.buffer.write(cbuf, off, ch);
        }
        return ch;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("Skip value is negative: " + n);
        }
        int avail = this.buffer.available();
        if ((long)avail >= n) {
            return this.buffer.skip(n);
        }
        if (avail > 0) {
            this.buffer.skip(avail);
            while ((long)avail++ < n && this.read() != -1) {
            }
            return avail;
        }
        while (this.read() != -1 && (long)(++avail) < n) {
        }
        return avail;
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer.close();
        this.in.close();
        this.lock = null;
        this.closed = true;
    }

    protected class ReadbackCharArrayWriter
    extends CharArrayWriter {
        private int total;
        private int mark;

        public ReadbackCharArrayWriter(int initialSize) {
            super(initialSize);
        }

        public ReadbackCharArrayWriter() {
        }

        public char[] buf() {
            return this.buf;
        }

        @Override
        public CharArrayWriter append(char c) {
            if (ReplayReader.this.closed) {
                return this;
            }
            CharArrayWriter writer = super.append(c);
            ++this.total;
            return writer;
        }

        @Override
        public CharArrayWriter append(CharSequence csq) {
            if (ReplayReader.this.closed) {
                return this;
            }
            CharArrayWriter writer = super.append(csq);
            this.total += csq.length();
            return writer;
        }

        @Override
        public CharArrayWriter append(CharSequence csq, int start, int end) {
            if (ReplayReader.this.closed) {
                return this;
            }
            CharArrayWriter writer = super.append(csq, start, end);
            this.total += end - start;
            return writer;
        }

        @Override
        public void write(int c) {
            if (ReplayReader.this.closed) {
                return;
            }
            super.write(c);
            ++this.total;
        }

        @Override
        public void write(char[] c, int off, int len) {
            if (ReplayReader.this.closed) {
                return;
            }
            super.write(c, off, len);
            this.total += len;
        }

        @Override
        public void write(String str, int off, int len) {
            if (ReplayReader.this.closed) {
                return;
            }
            super.write(str, off, len);
            this.total += len;
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            if (ReplayReader.this.closed) {
                return;
            }
            super.write(cbuf);
            this.total += cbuf.length;
        }

        @Override
        public void write(String str) throws IOException {
            if (ReplayReader.this.closed) {
                return;
            }
            super.write(str);
            this.total += str.length();
        }

        public int read() {
            return ReplayReader.this.closed || this.count >= this.total ? -1 : this.buf[this.count++];
        }

        public int read(char[] cbuf) {
            return this.read(cbuf, 0, cbuf.length);
        }

        public int read(char[] cbuf, int off, int len) {
            if (ReplayReader.this.closed || this.count >= this.total) {
                return -1;
            }
            int delta = len - this.available() - 1;
            int length = 0 < delta ? len - delta : len;
            System.arraycopy(this.buf, this.count, cbuf, off, length);
            this.count += length;
            return length;
        }

        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Skip value is negative: " + n);
            }
            return this.skip0(n);
        }

        private long skip0(long n) {
            if (ReplayReader.this.closed || this.count >= this.total || n <= 0L) {
                return 0L;
            }
            long check = (long)(this.total - this.count) - n;
            long length = check < 0L ? n + check : n;
            this.count = (int)((long)this.count + length);
            return length;
        }

        public int available() {
            return ReplayReader.this.closed ? 0 : this.total - this.count;
        }

        public void mark() {
            this.mark = this.count;
        }

        private void reset0(int p) {
            if (p > this.count) {
                this.skip0(p - this.count);
            }
            this.count = p;
        }

        public void reset(int p) {
            if (p < 0) {
                throw new IllegalArgumentException("Position (" + p + ") must be non-negative");
            }
            if (this.total < p) {
                throw new IllegalArgumentException("Position (" + p + ") must be less than the buffer length (" + this.total + ")");
            }
            this.reset0(p);
        }

        @Override
        public void reset() {
            this.reset0(this.mark);
        }

        @Override
        public void close() {
            this.buf = null;
            this.lock = null;
        }
    }
}

