/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.libj.io.SerializableInputStreamMemoryStore;
import org.libj.io.SerializableStreamStore;
import org.libj.lang.Assertions;

public class SerializableInputStream
extends InputStream
implements Serializable {
    private static final int DEFAULT_SERIALIZATION_CHUNK_SIZE = 2048;
    private static final Class<SerializableInputStreamMemoryStore> DEFAULT_SERIALIZABLE_STREAM_STORE = SerializableInputStreamMemoryStore.class;
    private transient InputStream stream;
    private transient int serializationBufferSize;
    private transient Class<? extends SerializableStreamStore<InputStream>> serializableStreamStoreClass;
    private transient SerializableStreamStore<InputStream> serializableStreamStore;

    public SerializableInputStream(InputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.serializationBufferSize = 2048;
        this.serializableStreamStoreClass = DEFAULT_SERIALIZABLE_STREAM_STORE;
    }

    public SerializableInputStream(InputStream stream, int serializationBufferSize) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.serializationBufferSize = Assertions.assertPositive((int)serializationBufferSize, (String)"bufferSize must be positive");
        this.serializableStreamStoreClass = DEFAULT_SERIALIZABLE_STREAM_STORE;
    }

    public SerializableInputStream(InputStream stream, int serializationBufferSize, Class<? extends SerializableStreamStore<InputStream>> serializableStreamStore) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.serializationBufferSize = Assertions.assertPositive((int)serializationBufferSize, (String)"bufferSize must be positive");
        this.serializableStreamStoreClass = Objects.requireNonNull(serializableStreamStore, "tempStore is null");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int r;
        out.writeInt(this.serializationBufferSize);
        out.writeObject(this.serializableStreamStoreClass);
        byte[] buf = new byte[this.serializationBufferSize];
        while ((r = this.stream.read(buf)) > 0) {
            out.writeInt(r);
            out.write(buf, 0, r);
        }
        out.writeInt(0);
        this.close();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.serializationBufferSize = in.readInt();
        try {
            this.serializableStreamStoreClass = (Class)in.readObject();
            this.serializableStreamStore = this.serializableStreamStoreClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        OutputStream out = (OutputStream)((Object)this.serializableStreamStore);
        int r0 = in.readInt();
        if (r0 > 0) {
            byte[] buf = new byte[r0];
            do {
                buf = buf.length >= r0 ? buf : new byte[r0];
                int r1 = in.read(buf, 0, r0);
                out.write(buf, 0, r1);
                if ((r0 -= r1) != 0) continue;
                r0 = in.readInt();
            } while (r0 > 0);
        }
        this.stream = this.serializableStreamStore.consume();
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.serializableStreamStore != null) {
            this.serializableStreamStore.close();
        }
    }
}

