/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.libj.io.ReaderInputStream;
import org.libj.io.SerializableReaderMemoryStore;
import org.libj.io.SerializableStreamStore;
import org.libj.io.WriterOutputStream;
import org.libj.lang.Assertions;

public class SerializableReader
extends Reader
implements Serializable {
    private static final int DEFAULT_SERIALIZATION_CHUNK_SIZE = 2048;
    private static final Class<SerializableReaderMemoryStore> DEFAULT_SERIALIZABLE_STREAM_STORE = SerializableReaderMemoryStore.class;
    private transient Reader stream;
    private transient int serializationBufferSize;
    private transient Class<? extends SerializableStreamStore<Reader>> serializableStreamStoreClass;
    private transient SerializableStreamStore<Reader> serializableStreamStore;

    public SerializableReader(Reader stream) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.serializationBufferSize = 2048;
        this.serializableStreamStoreClass = DEFAULT_SERIALIZABLE_STREAM_STORE;
    }

    public SerializableReader(Reader stream, int serializationBufferSize) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.serializationBufferSize = Assertions.assertPositive((int)serializationBufferSize, (String)"bufferSize must be positive");
        this.serializableStreamStoreClass = DEFAULT_SERIALIZABLE_STREAM_STORE;
    }

    public SerializableReader(Reader stream, int serializationBufferSize, Class<? extends SerializableStreamStore<Reader>> serializableStreamStore) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.serializationBufferSize = Assertions.assertPositive((int)serializationBufferSize, (String)"bufferSize must be positive");
        this.serializableStreamStoreClass = Objects.requireNonNull(serializableStreamStore, "tempStore is null");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.serializationBufferSize);
        out.writeObject(this.serializableStreamStoreClass);
        try (ReaderInputStream in = new ReaderInputStream(this.stream, Charset.defaultCharset());){
            int r;
            byte[] buf = new byte[this.serializationBufferSize];
            while ((r = ((InputStream)in).read(buf)) > 0) {
                out.writeInt(r);
                out.write(buf, 0, r);
            }
            out.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.serializationBufferSize = in.readInt();
        try {
            this.serializableStreamStoreClass = (Class)in.readObject();
            this.serializableStreamStore = this.serializableStreamStoreClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        WriterOutputStream out = new WriterOutputStream((Writer)((Object)this.serializableStreamStore), Charset.defaultCharset(), this.serializationBufferSize, true);
        int r0 = in.readInt();
        if (r0 > 0) {
            byte[] buf = new byte[r0];
            do {
                buf = buf.length >= r0 ? buf : new byte[r0];
                int r1 = in.read(buf, 0, r0);
                ((OutputStream)out).write(buf, 0, r1);
                if ((r0 -= r1) != 0) continue;
                r0 = in.readInt();
            } while (r0 > 0);
        }
        this.stream = this.serializableStreamStore.consume();
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.stream.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.stream.read(cbuf, off, len);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.stream.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.serializableStreamStore != null) {
            this.serializableStreamStore.close();
        }
    }
}

