/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.libj.io.SerializableStreamStore;

public class SerializableReaderFileStore
extends FileWriter
implements SerializableStreamStore<Reader> {
    private final File file;

    SerializableReaderFileStore() throws IOException {
        this(File.createTempFile("serializable_stream_", "_store"));
    }

    private SerializableReaderFileStore(File file) throws IOException {
        super(file);
        this.file = file;
        file.deleteOnExit();
    }

    @Override
    public Reader consume() throws IOException {
        super.close();
        return new FileReader(this.file);
    }

    @Override
    public void close() throws IOException {
        this.file.delete();
    }
}

