/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.libj.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Streams {
    private static final Logger logger = LoggerFactory.getLogger(Streams.class);
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;

    public static void writeShort(OutputStream out, short s) throws IOException {
        Streams.writeShort(out, s, true);
    }

    public static void writeShort(OutputStream out, short s, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(s >> 8 & 0xFF));
            out.write((byte)(s & 0xFF));
        } else {
            out.write((byte)(s & 0xFF));
            out.write((byte)(s >> 8 & 0xFF));
        }
    }

    public static void writeShort(DataOutput out, short s) throws IOException {
        Streams.writeShort(out, s, true);
    }

    public static void writeShort(DataOutput out, short s, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(s >> 8 & 0xFF));
            out.write((byte)(s & 0xFF));
        } else {
            out.write((byte)(s & 0xFF));
            out.write((byte)(s >> 8 & 0xFF));
        }
    }

    public static void writeChar(OutputStream out, char c) throws IOException {
        Streams.writeChar(out, c, true);
    }

    public static void writeChar(OutputStream out, char c, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(c >> 8 & 0xFF));
            out.write((byte)(c & 0xFF));
        } else {
            out.write((byte)(c & 0xFF));
            out.write((byte)(c >> 8 & 0xFF));
        }
    }

    public static void writeChar(DataOutput out, char c) throws IOException {
        Streams.writeChar(out, c, true);
    }

    public static void writeChar(DataOutput out, char c, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(c >> 8 & 0xFF));
            out.write((byte)(c & 0xFF));
        } else {
            out.write((byte)(c & 0xFF));
            out.write((byte)(c >> 8 & 0xFF));
        }
    }

    public static void writeInt(OutputStream out, int i) throws IOException {
        Streams.writeInt(out, i, true);
    }

    public static void writeInt(OutputStream out, int i, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(i >> 24 & 0xFF));
            out.write((byte)(i >> 16 & 0xFF));
            out.write((byte)(i >> 8 & 0xFF));
            out.write((byte)(i & 0xFF));
        } else {
            out.write((byte)(i & 0xFF));
            out.write((byte)(i >> 8 & 0xFF));
            out.write((byte)(i >> 16 & 0xFF));
            out.write((byte)(i >> 24 & 0xFF));
        }
    }

    public static void writeInt(DataOutput out, int i) throws IOException {
        Streams.writeInt(out, i, true);
    }

    public static void writeInt(DataOutput out, int i, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(i >> 24 & 0xFF));
            out.write((byte)(i >> 16 & 0xFF));
            out.write((byte)(i >> 8 & 0xFF));
            out.write((byte)(i & 0xFF));
        } else {
            out.write((byte)(i & 0xFF));
            out.write((byte)(i >> 8 & 0xFF));
            out.write((byte)(i >> 16 & 0xFF));
            out.write((byte)(i >> 24 & 0xFF));
        }
    }

    public static void writeLong(OutputStream out, long l) throws IOException {
        Streams.writeLong(out, l, true);
    }

    public static void writeLong(OutputStream out, long l, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(l >> 56 & 0xFFL));
            out.write((byte)(l >> 48 & 0xFFL));
            out.write((byte)(l >> 40 & 0xFFL));
            out.write((byte)(l >> 32 & 0xFFL));
            out.write((byte)(l >> 24 & 0xFFL));
            out.write((byte)(l >> 16 & 0xFFL));
            out.write((byte)(l >> 8 & 0xFFL));
            out.write((byte)(l & 0xFFL));
        } else {
            out.write((byte)(l & 0xFFL));
            out.write((byte)(l >> 8 & 0xFFL));
            out.write((byte)(l >> 16 & 0xFFL));
            out.write((byte)(l >> 24 & 0xFFL));
            out.write((byte)(l >> 32 & 0xFFL));
            out.write((byte)(l >> 40 & 0xFFL));
            out.write((byte)(l >> 48 & 0xFFL));
            out.write((byte)(l >> 56 & 0xFFL));
        }
    }

    public static void writeLong(DataOutput out, long l) throws IOException {
        Streams.writeLong(out, l, true);
    }

    public static void writeLong(DataOutput out, long l, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            out.write((byte)(l >> 56 & 0xFFL));
            out.write((byte)(l >> 48 & 0xFFL));
            out.write((byte)(l >> 40 & 0xFFL));
            out.write((byte)(l >> 32 & 0xFFL));
            out.write((byte)(l >> 24 & 0xFFL));
            out.write((byte)(l >> 16 & 0xFFL));
            out.write((byte)(l >> 8 & 0xFFL));
            out.write((byte)(l & 0xFFL));
        } else {
            out.write((byte)(l & 0xFFL));
            out.write((byte)(l >> 8 & 0xFFL));
            out.write((byte)(l >> 16 & 0xFFL));
            out.write((byte)(l >> 24 & 0xFFL));
            out.write((byte)(l >> 32 & 0xFFL));
            out.write((byte)(l >> 40 & 0xFFL));
            out.write((byte)(l >> 48 & 0xFFL));
            out.write((byte)(l >> 56 & 0xFFL));
        }
    }

    public static void writeFloat(OutputStream out, float f) throws IOException {
        Streams.writeInt(out, Float.floatToIntBits(f));
    }

    public static void writeDouble(OutputStream out, double d) throws IOException {
        Streams.writeLong(out, Double.doubleToLongBits(d));
    }

    public static byte[] readUntil(InputStream in, char ch) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != ch && c != -1) {
            out.write(c);
        }
        return out.toByteArray();
    }

    public static short readShort(InputStream in) throws IOException {
        return Streams.readShort(in, true);
    }

    public static short readShort(InputStream in, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return (short)((in.read() & 0xFF) << 8 | in.read() & 0xFF);
        }
        return (short)(in.read() & 0xFF | (in.read() & 0xFF) << 8);
    }

    public static char readChar(InputStream in) throws IOException {
        return Streams.readChar(in, true);
    }

    public static char readChar(InputStream in, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return (char)((in.read() & 0xFF) << 8 | in.read() & 0xFF);
        }
        return (char)(in.read() & 0xFF | (in.read() & 0xFF) << 8);
    }

    public static int readInt(InputStream in) throws IOException {
        return Streams.readInt(in, true);
    }

    public static int readInt(InputStream in, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        }
        return in.read() & 0xFF | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
    }

    public static long readLong(InputStream in) throws IOException {
        return Streams.readLong(in, true);
    }

    public static long readLong(InputStream in, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return ((long)in.read() & 0xFFL) << 56 | ((long)in.read() & 0xFFL) << 48 | ((long)in.read() & 0xFFL) << 40 | ((long)in.read() & 0xFFL) << 32 | ((long)in.read() & 0xFFL) << 24 | ((long)in.read() & 0xFFL) << 16 | ((long)in.read() & 0xFFL) << 8 | (long)in.read() & 0xFFL;
        }
        return (long)in.read() & 0xFFL | ((long)in.read() & 0xFFL) << 8 | ((long)in.read() & 0xFFL) << 16 | ((long)in.read() & 0xFFL) << 24 | ((long)in.read() & 0xFFL) << 32 | ((long)in.read() & 0xFFL) << 40 | ((long)in.read() & 0xFFL) << 48 | ((long)in.read() & 0xFFL) << 56;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        return Streams.readBytes(in, Integer.MAX_VALUE);
    }

    public static byte[] readBytes(InputStream in, int maxLength) throws IOException {
        int bufferSize = Math.min(8192, maxLength);
        byte[] data = new byte[bufferSize];
        int len = 0;
        int pos = 0;
        while ((len = bufferSize - pos) > 0 && (len = in.read(data, pos, len)) != -1) {
            pos += len;
        }
        if (pos == 0) {
            return ArrayUtil.EMPTY_ARRAY_BYTE;
        }
        if (len == -1) {
            return Arrays.copyOf(data, pos);
        }
        if (pos == maxLength || (len = in.read()) == -1) {
            return data;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(Math.min(32768, maxLength));
        buf.write(data);
        buf.write(len);
        ++pos;
        while ((len = Math.min(8192, maxLength - pos)) > 0 && (len = in.read(data, 0, len)) != -1) {
            buf.write(data, 0, Math.min(len, maxLength - pos));
            if ((pos += len) != maxLength) continue;
            break;
        }
        return buf.toByteArray();
    }

    public static InputStream merge(InputStream ... streams) throws IOException {
        return Streams.merge(true, streams);
    }

    public static InputStream mergeAsync(InputStream ... streams) throws IOException {
        return Streams.merge(false, streams);
    }

    private static InputStream merge(boolean sync, InputStream ... streams) throws IOException {
        if (streams.length == 0) {
            throw new IllegalArgumentException("streams.length == 0");
        }
        if (streams.length == 1) {
            return streams[0];
        }
        final CountDownLatch latch = new CountDownLatch(streams.length + 1);
        try (PipedOutputStream pipedOut = new PipedOutputStream(){

            @Override
            public void close() throws IOException {
                latch.countDown();
                if (latch.getCount() == 0L) {
                    super.close();
                }
            }
        };){
            PipedInputStream pipedIn = new PipedInputStream(pipedOut, 8192);
            int i$ = streams.length;
            for (int i = 0; i < i$; ++i) {
                Streams.pipe(streams[i], (OutputStream)pipedOut, false, sync, (? super IOException p) -> {
                    block2: {
                        try {
                            pipedOut.close();
                        }
                        catch (IOException e) {
                            if (!logger.isDebugEnabled()) break block2;
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
            PipedInputStream pipedInputStream = pipedIn;
            return pipedInputStream;
        }
    }

    public static void pipe(InputStream src, OutputStream snk) throws IOException {
        Streams.pipe(src, snk, false, true, null);
    }

    public static void pipeAsync(InputStream src, OutputStream snk) throws IOException {
        Streams.pipeAsync(src, snk, null);
    }

    public static void pipeAsync(InputStream src, OutputStream snk, Consumer<? super IOException> onThreadExit) throws IOException {
        Streams.pipe(src, snk, false, false, onThreadExit);
    }

    public static InputStream tee(InputStream src, OutputStream snk) throws IOException {
        return Streams.pipe(src, snk, true, true, null);
    }

    public static InputStream teeAsync(InputStream src, OutputStream snk) throws IOException {
        return Streams.teeAsync(src, snk, null);
    }

    public static InputStream teeAsync(InputStream src, OutputStream snk, Consumer<? super IOException> onThreadExit) throws IOException {
        return Streams.pipe(src, snk, true, false, onThreadExit);
    }

    private static InputStream pipe(final InputStream src, final OutputStream snk, boolean tee, boolean sync, final Consumer<? super IOException> onExit) throws IOException {
        PipedInputStream pipedIn;
        PipedOutputStream pipedOut;
        if (tee) {
            pipedOut = new PipedOutputStream();
            pipedIn = new PipedInputStream(pipedOut, 8192);
        } else {
            pipedOut = null;
            pipedIn = null;
        }
        if (sync) {
            Streams.pipe(src, snk, pipedOut, 8192, onExit);
        } else {
            new Thread(tee ? "tee" : "pipe"){

                @Override
                public void run() {
                    Streams.pipe(src, snk, pipedOut, 8192, (Consumer<? super IOException>)onExit);
                }
            }.start();
        }
        return pipedIn;
    }

    private static void pipe(InputStream src, OutputStream snk, PipedOutputStream pipedOut, int bufferSize, Consumer<? super IOException> onExit) {
        block13: {
            byte[] bytes = new byte[bufferSize];
            try {
                if (pipedOut != null) {
                    if (snk != null) {
                        int len;
                        while ((len = src.read(bytes)) != -1) {
                            pipedOut.write(bytes, 0, len);
                            snk.write(bytes, 0, len);
                            pipedOut.flush();
                            snk.flush();
                        }
                        pipedOut.close();
                        snk.flush();
                    } else {
                        int len;
                        while ((len = src.read(bytes)) != -1) {
                            pipedOut.write(bytes, 0, len);
                            pipedOut.flush();
                        }
                        pipedOut.close();
                    }
                } else if (snk != null) {
                    int len;
                    while ((len = src.read(bytes)) != -1) {
                        snk.write(bytes, 0, len);
                        snk.flush();
                    }
                    snk.flush();
                } else {
                    while (src.read(bytes) != -1) {
                    }
                }
                if (onExit != null) {
                    onExit.accept(null);
                }
            }
            catch (IOException e) {
                if (onExit == null) break block13;
                onExit.accept(e);
            }
        }
    }

    public static long transferTo(InputStream src, OutputStream snk) throws IOException {
        int read;
        long total = 0L;
        byte[] buffer = new byte[8192];
        while ((read = src.read(buffer, 0, 8192)) >= 0) {
            snk.write(buffer, 0, read);
            total += (long)read;
        }
        snk.flush();
        return total;
    }

    public static Integer equal(InputStream a, InputStream b) throws IOException {
        if (a == null) {
            if (b == null) {
                return -1;
            }
            return null;
        }
        if (b == null) {
            return null;
        }
        ReadableByteChannel ch1 = Channels.newChannel(a);
        ReadableByteChannel ch2 = Channels.newChannel(b);
        ByteBuffer buf1 = ByteBuffer.allocateDirect(1024);
        ByteBuffer buf2 = ByteBuffer.allocateDirect(1024);
        int total = 0;
        try {
            while (true) {
                int n1 = ch1.read(buf1);
                int n2 = ch2.read(buf2);
                if (n1 == -1 || n2 == -1) {
                    Integer n = n1 == n2 ? Integer.valueOf(total) : null;
                    return n;
                }
                buf1.flip();
                buf2.flip();
                for (int i = 0; i < Math.min(n1, n2); ++i) {
                    if (buf1.get() == buf2.get()) continue;
                    Integer n = null;
                    return n;
                }
                total += n1;
                buf1.compact();
                buf2.compact();
            }
        }
        finally {
            if (a != null) {
                a.close();
            }
            if (b != null) {
                b.close();
            }
        }
    }

    private Streams() {
    }
}

