/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class TeeOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public TeeOutputStream(OutputStream ... streams) {
        if (Objects.requireNonNull(streams).length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int i$ = streams.length;
        for (int i = 0; i < i$; ++i) {
            Objects.requireNonNull(streams[i], "member at index " + i + " is null");
        }
        this.streams = streams;
    }

    @Override
    public void write(int b) throws IOException {
        IOException exception = null;
        int i$ = this.streams.length;
        for (int i = 0; i < i$; ++i) {
            try {
                this.streams[i].write(b);
                continue;
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        IOException exception = null;
        int i$ = this.streams.length;
        for (int i = 0; i < i$; ++i) {
            try {
                this.streams[i].write(b);
                continue;
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        IOException exception = null;
        int i$ = this.streams.length;
        for (int i = 0; i < i$; ++i) {
            try {
                this.streams[i].write(b, off, len);
                continue;
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void flush() throws IOException {
        IOException exception = null;
        int i$ = this.streams.length;
        for (int i = 0; i < i$; ++i) {
            try {
                this.streams[i].flush();
                continue;
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        int i$ = this.streams.length;
        for (int i = 0; i < i$; ++i) {
            try {
                this.streams[i].close();
                continue;
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

