/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;

public class UnicodeReader
extends Reader {
    private final InputStream in;
    private final Reader reader;
    private final int[] buf = new int[9];
    private int limit = this.buf.length;
    private int index = 0;
    private int next = -2;
    private boolean le16;
    private boolean le32;
    private boolean flush;

    private static int shift(int i) {
        return 4 * (i % 2 == 0 ? (i - 1) * ((i - 1) % 2) : (i - 3) * (i % 2));
    }

    public UnicodeReader(InputStream in) {
        this.in = Objects.requireNonNull(in);
        this.reader = null;
    }

    public UnicodeReader(Reader reader) {
        this.in = null;
        this.reader = Objects.requireNonNull(reader);
    }

    private int abort(int ch) {
        this.index = 0;
        this.flush = true;
        return ch;
    }

    private int _read() throws IOException {
        return this.in != null ? this.in.read() : this.reader.read();
    }

    @Override
    public int read() throws IOException {
        int value;
        while (true) {
            int ch2;
            int end;
            int ch0;
            if (this.flush && this.index < this.limit) {
                ch0 = this.buf[this.index++];
            } else if (this.next != -2) {
                ch0 = this.next;
                this.next = -2;
            } else {
                ch0 = this._read();
            }
            if (ch0 != 92) {
                return ch0;
            }
            int i = 0;
            if (this.flush) {
                while (this.index < this.limit) {
                    this.buf[i++] = this.buf[this.index++];
                }
            }
            this.index = i;
            int ch1 = this._read();
            this.buf[this.index++] = ch1;
            if (ch1 != 117) {
                this.limit = this.index;
                return this.abort(ch0);
            }
            while (this.index < this.buf.length) {
                this.next = ch1 = this._read();
                if (ch1 == -1 || !(48 <= ch1 && ch1 <= 57 || 97 <= ch1 && ch1 <= 102) && (65 > ch1 || ch1 > 70)) break;
                this.buf[this.index++] = ch1;
            }
            if (this.index == this.buf.length) {
                this.next = -2;
            }
            this.limit = this.index;
            this.index = 1;
            this.flush = this.limit % 2 == 0;
            int n = end = this.flush ? this.limit - 1 : this.limit;
            if (end == 1) {
                return this.abort(ch0);
            }
            value = 0;
            if (this.le16 && end == 5 || this.le32 && end == 9) {
                while (this.index < end) {
                    if (48 <= (ch2 = this.buf[this.index++]) && ch2 <= 57) {
                        value += ch2 - 48 << UnicodeReader.shift(this.index);
                        continue;
                    }
                    if (97 <= ch2 && ch2 <= 102) {
                        value += 10 + ch2 - 97 << UnicodeReader.shift(this.index);
                        continue;
                    }
                    if (65 <= ch2 && ch2 <= 70) {
                        value += 10 + ch2 - 65 << UnicodeReader.shift(this.index);
                        continue;
                    }
                    return this.abort(ch0);
                }
            } else {
                while (this.index < end) {
                    if (48 <= (ch2 = this.buf[this.index++]) && ch2 <= 57) {
                        value = (value << 4) + ch2 - 48;
                        continue;
                    }
                    if (97 <= ch2 && ch2 <= 102) {
                        value = (value << 4) + 10 + ch2 - 97;
                        continue;
                    }
                    if (65 <= ch2 && ch2 <= 70) {
                        value = (value << 4) + 10 + ch2 - 65;
                        continue;
                    }
                    return this.abort(ch0);
                }
            }
            if (value == 65534) {
                this.le16 = !this.le16;
                continue;
            }
            if (value == -131072) {
                this.le32 = !this.le32;
                continue;
            }
            if (value != 65279) break;
        }
        return value;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch;
        int i;
        for (i = 0; i < len && (ch = this.read()) != -1; ++i) {
            cbuf[off + i] = (char)ch;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        (this.in != null ? this.in : this.reader).close();
    }
}

