/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Objects;

public class WriterOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static Boolean utf16ok;
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final boolean flushImmediately;
    private final ByteBuffer decoderIn;
    private final CharBuffer decoderOut;

    private static void checkIbmJdkWithBrokenUTF16(Charset charset) {
        if (utf16ok == null) {
            if (!"UTF-16".equals(charset.name())) {
                return;
            }
            String TEST_STRING_2 = "v\u00e9s";
            byte[] bytes = "v\u00e9s".getBytes(charset);
            CharsetDecoder charsetDecoder2 = charset.newDecoder();
            ByteBuffer bb2 = ByteBuffer.allocate(16);
            CharBuffer cb2 = CharBuffer.allocate("v\u00e9s".length());
            try {
                int len1 = bytes.length - 1;
                for (int i = 0; i <= len1; ++i) {
                    bb2.put(bytes[i]);
                    bb2.flip();
                    charsetDecoder2.decode(bb2, cb2, i == len1);
                    bb2.compact();
                }
                cb2.rewind();
                utf16ok = "v\u00e9s".equals(cb2.toString());
                if (utf16ok.booleanValue()) {
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (utf16ok.booleanValue()) {
            return;
        }
        throw new UnsupportedOperationException("UTF-16 requested when running on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UTF-16 with WriterOutputStream");
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder, int bufferSize, boolean flushImmediately) {
        WriterOutputStream.checkIbmJdkWithBrokenUTF16(decoder.charset());
        this.writer = Objects.requireNonNull(writer);
        this.decoder = Objects.requireNonNull(decoder);
        this.flushImmediately = flushImmediately;
        this.decoderIn = ByteBuffer.allocate(bufferSize);
        this.decoderOut = CharBuffer.allocate(bufferSize);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder) {
        this(writer, decoder, 1024, false);
    }

    public WriterOutputStream(Writer writer, Charset charset, int bufferSize, boolean flushImmediately) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), bufferSize, flushImmediately);
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset, 1024, false);
    }

    public WriterOutputStream(Writer writer, String charsetName, int bufferSize, boolean flushImmediately) throws IllegalCharsetNameException {
        this(writer, Charset.forName(charsetName), bufferSize, flushImmediately);
    }

    public WriterOutputStream(Writer writer, String charsetName) throws IllegalCharsetNameException {
        this(writer, charsetName, 1024, false);
    }

    @Deprecated
    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset(), 1024, false);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int r = Math.min(len, this.decoderIn.remaining());
            this.decoderIn.put(b, off, r);
            this.processInput(false);
            len -= r;
            off += r;
        }
        if (this.flushImmediately) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.decoderIn.put((byte)b);
        this.processInput(false);
        if (this.flushImmediately) {
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.processInput(true);
        this.flushBuffer();
        this.writer.close();
    }

    protected void flushBuffer() throws IOException {
        int pos = this.decoderOut.position();
        if (pos > 0) {
            this.writer.write(this.decoderOut.array(), 0, pos);
            this.decoderOut.rewind();
        }
    }

    private void processInput(boolean endOfInput) throws IOException {
        this.decoderIn.flip();
        CoderResult coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, endOfInput);
        if (coderResult.isOverflow()) {
            this.flushBuffer();
        } else if (coderResult.isUnderflow()) {
            this.decoderIn.compact();
        } else {
            throw new IOException("Unexpected coder result");
        }
    }
}

