/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class Annotations {
    public static Map<String, Object> getAttributes(Annotation annotation) {
        return Annotations.getAttributes(annotation, false);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, boolean removeDefaults) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            for (Method method : annotationType.getDeclaredMethods()) {
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (removeDefaults && Objects.equals(method.getDefaultValue(), value)) continue;
                attributes.put(method.getName(), value);
            }
            return attributes;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static String toSortedString(Annotation annotation) {
        return Annotations.toSortedString(annotation, null, false);
    }

    public static String toSortedString(Annotation annotation, boolean removeDefaults) {
        return Annotations.toSortedString(annotation, null, removeDefaults);
    }

    public static String toSortedString(Annotation annotation, Comparator<String> comparator) {
        return Annotations.toSortedString(annotation, comparator, false);
    }

    public static String toSortedString(Annotation annotation, Comparator<String> comparator, boolean removeDefaults) {
        String str = annotation.toString();
        if (str.indexOf(40) < 0) {
            return str;
        }
        TreeMap<String, Object> attributes = comparator != null ? new TreeMap<String, Object>(comparator) : new TreeMap();
        attributes.putAll(Annotations.getAttributes(annotation, removeDefaults));
        StringBuilder b = new StringBuilder("@").append(annotation.annotationType().getName()).append('(');
        if (attributes.size() > 0) {
            Iterator iterator = attributes.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                if (i > 0) {
                    b.append(", ");
                }
                Map.Entry entry = iterator.next();
                b.append(entry.getKey()).append('=');
                Annotations.appendValue(b, comparator, entry.getValue());
                ++i;
            }
        }
        return b.append(')').toString();
    }

    private static void appendValue(StringBuilder b, Comparator<String> c, Object v) {
        if (v instanceof String) {
            b.append('\"').append(v).append('\"');
        } else if (v instanceof Class) {
            b.append(((Class)v).getName()).append(".class");
        } else {
            Class<?> cls = v.getClass();
            if (cls.isArray()) {
                b.append('{');
                Class<?> componentType = cls.getComponentType();
                if (componentType == Byte.TYPE) {
                    byte[] a = (byte[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Character.TYPE) {
                    char[] a = (char[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Short.TYPE) {
                    short[] a = (short[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Integer.TYPE) {
                    int[] a = (int[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Long.TYPE) {
                    long[] a = (long[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Double.TYPE) {
                    double[] a = (double[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Float.TYPE) {
                    float[] a = (float[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else if (componentType == Boolean.TYPE) {
                    boolean[] a = (boolean[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(a[i]);
                    }
                } else {
                    Object[] a = (Object[])v;
                    int i$ = a.length;
                    for (int i = 0; i < i$; ++i) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        Annotations.appendValue(b, c, a[i]);
                    }
                }
                b.append('}');
            } else if (v instanceof Annotation) {
                b.append(Annotations.toSortedString((Annotation)v, c, true));
            } else {
                b.append(v);
            }
        }
    }

    private Annotations() {
    }
}

