/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.Serializable;
import java.util.Objects;
import org.libj.lang.Assertions;

public abstract class ArrayCharSequence
implements CharSequence,
Serializable {
    final int offset;
    final int count;

    public static ArrayCharSequence of(char[] buf) {
        return new ArrayCharSequenceBuf(buf, 0, buf.length);
    }

    public static ArrayCharSequence of(char[] buf, int count) {
        Assertions.assertBoundsOffsetCount("length", buf.length, "offset", 0, "count", count);
        return new ArrayCharSequenceBuf(buf, 0, count);
    }

    public static ArrayCharSequence of(char[] buf, int offset, int count) {
        Assertions.assertBoundsOffsetCount("length", buf.length, "offset", offset, "count", count);
        return new ArrayCharSequenceBuf(buf, offset, count);
    }

    public static ArrayCharSequence of(String str) {
        return new ArrayCharSequenceStr(str, 0, str.length());
    }

    public static ArrayCharSequence of(String str, int count) {
        Assertions.assertBoundsOffsetCount("length", str.length(), "offset", 0, "count", count);
        return new ArrayCharSequenceStr(str, 0, count);
    }

    public static ArrayCharSequence of(String str, int offset, int count) {
        Assertions.assertBoundsOffsetCount("length", str.length(), "offset", offset, "count", count);
        return new ArrayCharSequenceStr(str, offset, count);
    }

    ArrayCharSequence(int offset, int count) {
        this.offset = offset;
        this.count = count;
    }

    @Override
    public int length() {
        return this.count;
    }

    private static class ArrayCharSequenceStr
    extends ArrayCharSequence {
        private final String str;
        private String toString;

        ArrayCharSequenceStr(String str, int offset, int count) {
            super(offset, count);
            this.str = Objects.requireNonNull(str);
        }

        @Override
        public char charAt(int index) {
            return this.str.charAt(this.offset + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start == 0 && end == this.count) {
                return this;
            }
            Assertions.assertRangeArray(start, end, this.count);
            return new ArrayCharSequenceStr(this.str, this.offset + start, end - start);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ArrayCharSequenceStr)) {
                return false;
            }
            ArrayCharSequenceStr that = (ArrayCharSequenceStr)obj;
            for (int i = 0; i < this.count; ++i) {
                if (this.str.charAt(this.offset + i) == that.str.charAt(that.offset + i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            int i$ = this.offset + this.count;
            for (int i = this.offset; i < i$; ++i) {
                hashCode = 31 * hashCode + this.str.charAt(i);
            }
            return hashCode;
        }

        @Override
        public String toString() {
            return this.toString == null ? (this.toString = this.str.substring(this.offset, this.offset + this.count)) : this.toString;
        }
    }

    private static class ArrayCharSequenceBuf
    extends ArrayCharSequence {
        private final char[] buf;

        ArrayCharSequenceBuf(char[] buf, int offset, int count) {
            super(offset, count);
            this.buf = buf;
        }

        @Override
        public char charAt(int index) {
            return this.buf[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start == 0 && end == this.count) {
                return this;
            }
            Assertions.assertRangeArray(start, end, this.count);
            return new ArrayCharSequenceBuf(this.buf, this.offset + start, end - start);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ArrayCharSequenceBuf)) {
                return false;
            }
            ArrayCharSequenceBuf that = (ArrayCharSequenceBuf)obj;
            for (int i = 0; i < this.count; ++i) {
                if (this.buf[this.offset + i] == that.buf[that.offset + i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            int i$ = this.offset + this.count;
            for (int i = this.offset; i < i$; ++i) {
                hashCode = 31 * hashCode + this.buf[i];
            }
            return hashCode;
        }

        @Override
        public String toString() {
            return new String(this.buf, this.offset, this.count);
        }
    }
}

