/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.libj.lang.Assertions;
import org.libj.lang.Identifiers;
import org.libj.lang.Repeat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Classes {
    private static final Logger logger = LoggerFactory.getLogger(Classes.class);
    private static final Type[] EMPTY_TYPES = new Type[0];
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Repeat.Recurser<Class<?>, Field, Object> declaredFieldRecurser = (member, arg) -> true;
    private static final Repeat.Recurser<Class<?>, Field, Predicate<Field>> declaredFieldWithPredicateRecurser = (member, arg) -> arg.test(member);
    private static final Repeat.Recurser<Class<?>, Field, Class<? extends Annotation>> declaredFieldWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final Repeat.Recurser<Class<?>, Method, Object> declaredMethodRecurser = (member, arg) -> true;
    private static final Repeat.Recurser<Class<?>, Method, Predicate<Method>> declaredMethodWithPredicateRecurser = (member, arg) -> arg.test(member);
    private static final Repeat.Recurser<Class<?>, Method, Class<? extends Annotation>> declaredMethodWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final Repeat.Recurser<Class<?>, Method, Predicate<Method>> methodWithPredicateRecurser = (member, arg) -> arg.test(member);
    private static final Repeat.Recurser<Class<?>, Method, Class<? extends Annotation>> methodWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final Repeat.Recurser<Class<?>, Class<?>, Class<? extends Annotation>> classWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final BiPredicate<Field, Class<? extends Annotation>> declaredFieldWithAnnotationFilter = (m, a) -> m.getAnnotation(a) != null;
    private static final BiPredicate<Method, Class<? extends Annotation>> declaredMethodWithAnnotationFilter = (m, a) -> m.getAnnotation(a) != null;
    private static final BiPredicate<Class<?>, Class<? extends Annotation>> classWithAnnotationFilter = (m, a) -> m.getAnnotation(a) != null;
    private static final HashMap<Method, Annotation[]> methodToAnnotations = new HashMap();
    private static final HashMap<Field, Annotation[]> fieldToAnnotations = new HashMap();
    private static final Class<?>[] primitiveClasses = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final String[] primitiveNames = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final String[] primitiveInternalNames = new String[]{"Z", "B", "C", "D", "F", "I", "J", "S", "V"};
    private static final IdentityHashMap<Class<?>, Executable> classToExecutable = new IdentityHashMap();
    private static final ThreadLocal<Set<String>> errorMethodSigs = new ThreadLocal();
    private static Boolean hasJavaAssist;

    public static String getDeclaringClassName(String className) {
        char ch;
        if (!Identifiers.isValid(className)) {
            throw new IllegalArgumentException("Not a valid java identifier: " + className);
        }
        int index = className.length() - 1;
        while ((index = className.lastIndexOf(36, index - 1)) > 1 && ((ch = className.charAt(index - 1)) == '.' || ch == '$')) {
        }
        return index <= 0 ? className : className.substring(0, index);
    }

    public static String getRootDeclaringClassName(String className) {
        if (!Identifiers.isValid(className)) {
            throw new IllegalArgumentException("Not a valid java identifier: " + className);
        }
        int length1 = className.length() - 1;
        int index = 0;
        while ((index = className.indexOf(36, index + 1)) > 1) {
            char ch = className.charAt(index - 1);
            if (index == length1) {
                return className;
            }
            if (ch == '.' || ch == '$') continue;
            break;
        }
        return index == -1 ? className : className.substring(0, index);
    }

    public static String toCanonicalClassName(String className) {
        if (!Identifiers.isValid(className)) {
            throw new IllegalArgumentException("Not a valid java identifier: " + className);
        }
        int length = className.length();
        if (length == 1) {
            return className;
        }
        StringBuilder b = new StringBuilder();
        b.append(className.charAt(0));
        int length1 = length - 1;
        int prev = 0;
        for (int i = 1; i < length1; ++i) {
            int ch = className.charAt(i);
            b.append((char)(prev != 46 && prev != 36 && ch == 36 ? 46 : ch));
            prev = ch;
        }
        if (length1 > 0) {
            b.append(className.charAt(length1));
        }
        return b.toString();
    }

    public static String getCompositeName(Class<?> cls) {
        if (cls.isPrimitive()) {
            return cls.getCanonicalName();
        }
        String pkg = cls.getPackage().getName();
        return pkg.length() == 0 ? cls.getName() : cls.getName().substring(pkg.length() + 1);
    }

    public static String getCanonicalCompositeName(Class<?> cls) {
        if (cls.isPrimitive()) {
            return cls.getCanonicalName();
        }
        String pkg = cls.getPackage().getName();
        return pkg.length() == 0 ? cls.getCanonicalName() : cls.getCanonicalName().substring(pkg.length() + 1);
    }

    public static Type[] getSuperclassGenericTypes(Class<?> cls) {
        Type genericSuperclass = cls.getGenericSuperclass();
        return genericSuperclass instanceof ParameterizedType ? ((ParameterizedType)genericSuperclass).getActualTypeArguments() : null;
    }

    private static <T> T visitSuperclass(Class<?> cls, Queue<? super Class<?>> queue, Set<? super Class<?>> visited, Function<? super Class<?>, T> function) {
        T t;
        if (cls == null || !visited.add(cls)) {
            return null;
        }
        if (function != null && (t = function.apply(cls)) != null) {
            return t;
        }
        queue.add(cls);
        return null;
    }

    public static <T> T walkClassHierarchy(Class<?> cls, Function<? super Class<?>, T> function) {
        LinkedList queue = new LinkedList();
        LinkedHashSet visited = new LinkedHashSet();
        T t = Classes.visitSuperclass(cls, queue, visited, function);
        if (t != null) {
            return t;
        }
        do {
            if ((t = Classes.visitSuperclass(cls.getSuperclass(), queue, visited, function)) != null) {
                return t;
            }
            for (Class<?> superInterface : cls.getInterfaces()) {
                t = Classes.visitSuperclass(superInterface, queue, visited, function);
                if (t == null) continue;
                return t;
            }
        } while ((cls = (Class)queue.poll()) != null);
        return t;
    }

    private static boolean visitSuperclass(Class<?> cls, Queue<? super Class<?>> queue, Set<? super Class<?>> visited, Predicate<? super Class<?>> forEach) {
        if (cls == null || !visited.add(cls)) {
            return true;
        }
        if (forEach != null && !forEach.test(cls)) {
            return false;
        }
        queue.add(cls);
        return true;
    }

    public static Set<Class<?>> getClassHierarchy(Class<?> cls, Predicate<? super Class<?>> forEach) {
        LinkedList queue = new LinkedList();
        LinkedHashSet visited = new LinkedHashSet();
        if (!Classes.visitSuperclass(cls, queue, visited, forEach)) {
            return visited;
        }
        do {
            if (!Classes.visitSuperclass(cls.getSuperclass(), queue, visited, forEach)) {
                return visited;
            }
            for (Class<?> superInterface : cls.getInterfaces()) {
                if (Classes.visitSuperclass(superInterface, queue, visited, forEach)) continue;
                return visited;
            }
        } while ((cls = (Class)queue.poll()) != null);
        return visited;
    }

    public static Set<Class<?>> getClassHierarchy(Class<?> cls) {
        return Classes.getClassHierarchy(cls, null);
    }

    public static Type[] getGenericSuperclassTypeArguments(Class<?> cls, Class<?> superClass) {
        Type superType;
        if (superClass.isInterface()) {
            throw new IllegalArgumentException(superClass.getName() + " is an interface type");
        }
        while ((superType = cls.getGenericSuperclass()) != null) {
            if (superType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)superType;
                cls = (Class)parameterizedType.getRawType();
                if (cls != superClass) continue;
                return parameterizedType.getActualTypeArguments();
            }
            cls = (Class)superType;
            if (cls != superClass) continue;
            return EMPTY_TYPES;
        }
        return EMPTY_TYPES;
    }

    public static Type[] getGenericInterfaceTypeArguments(Class<?> cls, Class<?> interfaceType) {
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException(interfaceType.getName() + " is not an interface type");
        }
        Type[] types = Classes.resolveGenericTypes(cls, null, new HashSet(), (c, t) -> c == interfaceType ? t : null);
        return types != null ? types : EMPTY_TYPES;
    }

    public static <T> T resolveGenericTypes(Class<?> cls, BiFunction<Class<?>, Type[], T> function) {
        return Classes.resolveGenericTypes(cls, null, new HashSet(8), function);
    }

    private static <T> T resolveGenericTypes(Class<?> cls, Object[][] args, Set<Class<?>> visited, BiFunction<Class<?>, Type[], T> function) {
        T result;
        Class<?> superclass = cls.getSuperclass();
        boolean resolvedSuperclass = superclass != null && cls.getGenericSuperclass() instanceof ParameterizedType;
        if (resolvedSuperclass && (result = Classes.resolveGenericTypes(superclass, (ParameterizedType)cls.getGenericSuperclass(), args, visited, function)) != null) {
            return result;
        }
        Class<?>[] superInterfaces = cls.getInterfaces();
        Type[] genericSuperInterfaces = cls.getGenericInterfaces();
        int i$ = genericSuperInterfaces.length;
        for (int i = 0; i < i$; ++i) {
            Type genericSuperInterface;
            Class<?> superInterface = superInterfaces[i];
            if (!visited.add(superInterface) || !((genericSuperInterface = genericSuperInterfaces[i]) instanceof ParameterizedType) || (result = Classes.resolveGenericTypes(superInterface, (ParameterizedType)genericSuperInterface, args, visited, function)) == null) continue;
            return result;
        }
        return resolvedSuperclass || superclass == null ? null : (T)Classes.resolveGenericTypes(superclass, args, visited, function);
    }

    private static <T> T resolveGenericTypes(Class<?> superClass, ParameterizedType superType, Object[][] args, Set<Class<?>> visited, BiFunction<Class<?>, Type[], T> function) {
        TypeVariable<Class<?>>[] typeVariables = superClass.getTypeParameters();
        Type[] typeArguments = superType.getActualTypeArguments();
        Object[][] nextArgs = Classes.recurseArgs(typeVariables, typeArguments, args, typeVariables.length, 0, 0);
        T result = function.apply(superClass, typeArguments);
        return result != null ? result : Classes.resolveGenericTypes(superClass, nextArgs, visited, function);
    }

    private static Object[][] recurseArgs(TypeVariable<?>[] typeVariables, Type[] typeArguments, Object[][] args, int length, int index, int depth) {
        if (index == length) {
            return new Object[depth][2];
        }
        if (typeArguments[index] instanceof Class) {
            Object[] arg = new Object[]{typeVariables[index].getName(), (Class)typeArguments[index]};
            Object[][] nextArgs = Classes.recurseArgs(typeVariables, typeArguments, args, length, index + 1, depth + 1);
            nextArgs[depth] = arg;
            return nextArgs;
        }
        String localName = typeArguments[index].getTypeName();
        if (args != null) {
            for (Object[] arg : args) {
                if (!localName.equals(arg[0])) continue;
                typeArguments[index] = (Class)arg[1];
                Object[][] nextArgs = Classes.recurseArgs(typeVariables, typeArguments, args, length, index + 1, depth + 1);
                nextArgs[depth] = new Object[]{typeVariables[index].getTypeName(), typeArguments[index]};
                return nextArgs;
            }
        }
        return Classes.recurseArgs(typeVariables, typeArguments, args, length, index + 1, depth);
    }

    public static Class<?>[] getGenericParameters(Method method) {
        return Classes.getGenericParameters(method.getGenericReturnType());
    }

    public static Class<?>[] getGenericParameters(Field field) {
        return Classes.getGenericParameters(field.getGenericType());
    }

    public static Class<?>[] getGenericParameters(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return EMPTY_CLASSES;
        }
        Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
        int len = types.length;
        Class[] classes = new Class[len];
        for (int i = 0; i < len; ++i) {
            Type type = types[i];
            if (type instanceof Class) {
                classes[i] = (Class)type;
                continue;
            }
            if (type instanceof ParameterizedType) {
                classes[i] = (Class)((ParameterizedType)type).getRawType();
                continue;
            }
            if (type instanceof TypeVariable) {
                classes[i] = (Class)((TypeVariable)type).getBounds()[0];
                continue;
            }
            if (!(type instanceof WildcardType)) continue;
            Type wildcardType = ((WildcardType)type).getUpperBounds()[0];
            classes[i] = (Class)(wildcardType instanceof ParameterizedType ? ((ParameterizedType)wildcardType).getRawType() : wildcardType);
        }
        return classes;
    }

    private static Field getField(Field[] fields, String fieldName) {
        for (Field field : fields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static Field getField(Class<?> cls, String name) {
        return Classes.getField(cls.getFields(), name);
    }

    public static Field getDeclaredField(Class<?> cls, String name) {
        return Classes.getField(cls.getDeclaredFields(), name);
    }

    public static Field getDeclaredFieldDeep(Class<?> cls, String name) {
        Field field;
        while ((field = Classes.getField(cls.getDeclaredFields(), name)) == null && (cls = cls.getSuperclass()) != null) {
        }
        return field;
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (!Classes.isMatch(constructor, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getCompatibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (!Classes.isCompatible(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getDeclaredConstructors()) {
            if (!Classes.isMatch(constructor, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> cls) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    private static boolean isMatch(Constructor<?> constructor, Class<?>[] parameterTypes) {
        return parameterTypes == null || parameterTypes.length == 0 ? constructor.getParameterCount() == 0 : parameterTypes.length == constructor.getParameterCount() && Arrays.equals(constructor.getParameterTypes(), parameterTypes);
    }

    public static <T> T setAnnotationValue(Annotation annotation, String key, T newValue) {
        Map memberValues;
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        try {
            Field field = handler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            memberValues = (Map)field.get(handler);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        Object oldValue = Assertions.assertNotNull(memberValues.get(key), () -> key + " is not a valid key");
        if (newValue.getClass() != oldValue.getClass()) {
            throw new IllegalArgumentException(newValue.getClass().getName() + " does not match the required type " + oldValue.getClass().getName());
        }
        memberValues.put(key, newValue);
        return (T)oldValue;
    }

    public static Field[] getDeclaredFieldsDeep(Class<?> cls) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredFields(), Field.class, declaredFieldRecurser, null);
    }

    public static Field[] getDeclaredFieldsDeep(Class<?> cls, Predicate<Field> predicate) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredFields(), Field.class, declaredFieldWithPredicateRecurser, predicate);
    }

    public static Field[] getDeclaredFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getDeclaredFields(), Field.class, declaredFieldWithAnnotationFilter, annotationType);
    }

    public static Field[] getDeclaredFieldsWithAnnotationDeep(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredFields(), Field.class, declaredFieldWithAnnotationRecurser, annotationType);
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        for (Method method : cls.getMethods()) {
            if (!name.equals(method.getName()) || !(parameterTypes.length == 0 ? method.getParameterCount() == 0 : Arrays.equals(method.getParameterTypes(), parameterTypes))) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name) {
        for (Method method : cls.getMethods()) {
            if (method.getParameterCount() != 0 || !name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static boolean isCompatible(Class<?>[] parameterTypes, Class<?>[] args) {
        if (parameterTypes.length != args.length) {
            return false;
        }
        int i$ = parameterTypes.length;
        for (int i = 0; i < i$; ++i) {
            if (args[i] == null || Classes.isAssignableFrom(parameterTypes[i], args[i], true)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInstance(Class<?> target, Object obj) {
        return obj != null && Classes.isAssignableFrom(target, obj.getClass(), true);
    }

    public static boolean isAssignableFrom(Class<?> target, Class<?> cls) {
        return Classes.isAssignableFrom(target, cls, true);
    }

    public static boolean isAssignableFrom(Class<?> target, Class<?> cls, boolean canWrap) {
        if (target.isArray()) {
            if (!cls.isArray()) {
                return false;
            }
            return Classes.isAssignableFrom(target.getComponentType(), cls.getComponentType(), false);
        }
        if (cls.isArray()) {
            return false;
        }
        if (target.isPrimitive() && cls.isPrimitive()) {
            return target == cls;
        }
        if (canWrap) {
            if (target.isPrimitive()) {
                target = Classes.box(target);
            }
            if (cls.isPrimitive()) {
                cls = Classes.box(cls);
            }
        }
        return target.isAssignableFrom(cls);
    }

    public static Method getCompatibleMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        for (Method method : cls.getMethods()) {
            if (!name.equals(method.getName()) || !Classes.isCompatible(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !(parameterTypes.length == 0 ? method.getParameterCount() == 0 : Arrays.equals(method.getParameterTypes(), parameterTypes))) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> cls, String name) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethodDeep(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method method;
        while ((method = Classes.getDeclaredMethod(cls, name, parameterTypes)) == null && (cls = cls.getSuperclass()) != null) {
        }
        return method;
    }

    public static Method getDeclaredMethodDeep(Class<?> cls, String name) {
        Method method;
        while ((method = Classes.getDeclaredMethod(cls, name)) == null && (cls = cls.getSuperclass()) != null) {
        }
        return method;
    }

    public static Method[] getDeclaredMethodsDeep(Class<?> cls) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredMethods(), Method.class, declaredMethodRecurser, null);
    }

    public static Method[] getDeclaredMethodsDeep(Class<?> cls, Predicate<Method> predicate) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredMethods(), Method.class, declaredMethodWithPredicateRecurser, predicate);
    }

    public static Method[] getDeclaredMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getDeclaredMethods(), Method.class, declaredMethodWithAnnotationFilter, annotationType);
    }

    public static Method[] getDeclaredMethodsWithAnnotationDeep(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredMethods(), Method.class, declaredMethodWithAnnotationRecurser, annotationType);
    }

    public static Method[] getMethods(Class<?> cls, Predicate<Method> predicate) {
        return Repeat.Recursive.ordered(cls.getMethods(), Method.class, methodWithPredicateRecurser, predicate);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getMethods(), Method.class, methodWithAnnotationRecurser, annotationType);
    }

    public static Class<?>[] getDeclaredClassesWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getDeclaredClasses(), Class.class.getClass(), classWithAnnotationFilter, annotationType);
    }

    public static Class<?>[] getDeclaredClassesWithAnnotationDeep(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredClasses(), Class.class.getClass(), classWithAnnotationRecurser, annotationType);
    }

    public static Annotation[] getAnnotations(Method method) {
        Annotation[] annotations = methodToAnnotations.get(method);
        if (annotations == null) {
            annotations = method.getAnnotations();
            methodToAnnotations.put(method, annotations);
        }
        return annotations;
    }

    public static Annotation[] getAnnotations(Field field) {
        Annotation[] annotations = fieldToAnnotations.get(field);
        if (annotations == null) {
            annotations = field.getAnnotations();
            fieldToAnnotations.put(field, annotations);
        }
        return annotations;
    }

    public static <A extends Annotation> A getAnnotationDeep(Class<?> cls, Class<A> annotationClass) {
        A annotation;
        Class<?> parent = cls;
        while ((annotation = parent.getAnnotation(annotationClass)) == null && (parent = parent.getSuperclass()) != null) {
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotationDeep(Method method, Class<A> annotationClass) {
        Class<?> declaringClass;
        A annotation;
        while ((annotation = method.getAnnotation(annotationClass)) == null && (declaringClass = method.getDeclaringClass().getSuperclass()) != null && (method = Classes.getDeclaredMethodDeep(declaringClass, method.getName(), method.getParameterTypes())) != null) {
        }
        return annotation;
    }

    public static boolean isAnnotationPresentDeep(Class<?> cls, Class<? extends Annotation> annotationClass) {
        Class<?> parent = cls;
        do {
            if (!parent.isAnnotationPresent(annotationClass)) continue;
            return true;
        } while ((parent = parent.getSuperclass()) != null);
        return false;
    }

    public static boolean isAnnotationPresentDeep(Method method, Class<? extends Annotation> annotationClass) {
        Class<?> declaringClass;
        do {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            return true;
        } while ((declaringClass = method.getDeclaringClass().getSuperclass()) != null && (method = Classes.getDeclaredMethodDeep(declaringClass, method.getName(), method.getParameterTypes())) != null);
        return false;
    }

    public static Class<?>[] getAllInterfaces(Class<?> cls) {
        Class<?>[] thisInterfaces;
        LinkedHashSet allInterfaces = null;
        do {
            if ((thisInterfaces = cls.getInterfaces()).length == 0) continue;
            if (allInterfaces == null) {
                allInterfaces = new LinkedHashSet(4);
            }
            for (Class<?> iface : thisInterfaces) {
                Classes.getAllInterfaces(iface, allInterfaces);
            }
        } while ((cls = cls.getSuperclass()) != null);
        return allInterfaces == null ? thisInterfaces : allInterfaces.toArray(new Class[allInterfaces.size()]);
    }

    private static void getAllInterfaces(Class<?> iface, LinkedHashSet<Class<?>> allInterfaces) {
        if (allInterfaces.contains(iface)) {
            return;
        }
        allInterfaces.add(iface);
        for (Class<?> extended : iface.getInterfaces()) {
            Classes.getAllInterfaces(extended, allInterfaces);
        }
    }

    public static Type[] getAllGenericInterfaces(Class<?> cls) {
        LinkedHashSet allInterfaces = null;
        LinkedHashSet<Type> allGenericInterfaces = null;
        do {
            Class<?>[] interfaces = cls.getInterfaces();
            Type[] genericInterfaces = cls.getGenericInterfaces();
            if (genericInterfaces.length > 0) {
                if (allGenericInterfaces == null) {
                    allGenericInterfaces = new LinkedHashSet<Type>(2);
                }
                Collections.addAll(allGenericInterfaces, genericInterfaces);
            }
            if (interfaces.length == 0) continue;
            if (allInterfaces == null) {
                allInterfaces = new LinkedHashSet(4);
                if (allGenericInterfaces == null) {
                    allGenericInterfaces = new LinkedHashSet(2);
                }
            }
            for (Class<?> iface : interfaces) {
                Classes.getAllGenericInterfaces(iface, allInterfaces, allGenericInterfaces);
            }
        } while ((cls = cls.getSuperclass()) != null);
        return allGenericInterfaces == null ? EMPTY_TYPES : allGenericInterfaces.toArray(new Type[allGenericInterfaces.size()]);
    }

    private static void getAllGenericInterfaces(Class<?> iface, LinkedHashSet<Class<?>> allInterfaces, LinkedHashSet<Type> allGenericInterfaces) {
        if (allInterfaces.contains(iface)) {
            return;
        }
        allInterfaces.add(iface);
        Collections.addAll(allGenericInterfaces, iface.getGenericInterfaces());
        for (Class<?> extended : iface.getInterfaces()) {
            Classes.getAllGenericInterfaces(extended, allInterfaces, allGenericInterfaces);
        }
    }

    public static Class<?> getGreatestCommonSuperclass(Class<?> ... classes) {
        if (classes.length == 0) {
            throw new IllegalArgumentException("Number of arguments must be greater than 0");
        }
        if (classes.length == 1) {
            return classes[0];
        }
        Class<?> gcc = Classes.getGreatestCommonSuperclass(classes[0], classes[1]);
        for (int i = 2; i < classes.length && gcc != null; ++i) {
            gcc = Classes.getGreatestCommonSuperclass(gcc, classes[i]);
        }
        return gcc;
    }

    @SafeVarargs
    public static <T> Class<?> getGreatestCommonSuperclass(T ... objects) {
        if (objects.length == 0) {
            throw new IllegalArgumentException("Number of arguments must be greater than 0");
        }
        return Classes.getGreatestCommonSuperclass0(objects);
    }

    public static <T> Class<?> getGreatestCommonSuperclass(Collection<T> objects) {
        if (objects.size() == 0) {
            throw new IllegalArgumentException("Collection size must be greater than 0");
        }
        return Classes.getGreatestCommonSuperclass0(objects.toArray());
    }

    private static Class<?> getGreatestCommonSuperclass(Class<?> c1, Class<?> c2) {
        Class<?> c0 = c2;
        while (true) {
            if (c1.isAssignableFrom(c2)) {
                return c1;
            }
            if ((c2 = c2.getSuperclass()) != null) continue;
            c2 = c0;
            if ((c1 = c1.getSuperclass()) == null) break;
        }
        return null;
    }

    @SafeVarargs
    private static <T> Class<?> getGreatestCommonSuperclass0(T ... objects) {
        if (objects.length == 1) {
            return objects[0].getClass();
        }
        Class<?> gcc = Classes.getGreatestCommonSuperclass(objects[0].getClass(), objects[1].getClass());
        for (int i = 2; i < objects.length && gcc != null; ++i) {
            gcc = Classes.getGreatestCommonSuperclass(gcc, objects[i].getClass());
        }
        return gcc;
    }

    public static Class<?> box(Class<?> primitiveType) {
        if (!primitiveType.isPrimitive()) {
            return primitiveType;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Void.TYPE) {
            return Void.class;
        }
        throw new UnsupportedOperationException("Unsupported class: " + primitiveType.getName());
    }

    public static Class<?> unbox(Class<?> objectType) {
        if (objectType.isPrimitive()) {
            return objectType;
        }
        if (objectType == Integer.class) {
            return Integer.TYPE;
        }
        if (objectType == Long.class) {
            return Long.TYPE;
        }
        if (objectType == Double.class) {
            return Double.TYPE;
        }
        if (objectType == Float.class) {
            return Float.TYPE;
        }
        if (objectType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (objectType == Character.class) {
            return Character.TYPE;
        }
        if (objectType == Byte.class) {
            return Byte.TYPE;
        }
        if (objectType == Short.class) {
            return Short.TYPE;
        }
        if (objectType == Void.class) {
            return Void.TYPE;
        }
        throw new UnsupportedOperationException("Unsupported class: " + objectType.getName());
    }

    public static Class<?> forNamePrimitiveOrNull(String name) {
        int index = Arrays.binarySearch(primitiveNames, name);
        return index < 0 ? null : primitiveClasses[index];
    }

    public static <T> T newInstance(Class<T> type, Object ... parameters) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Method fromString;
        Executable executable;
        if (type.isPrimitive()) {
            type = Classes.box(type);
        }
        if ((executable = classToExecutable.get(type)) != null) {
            return (T)(executable instanceof Constructor ? ((Constructor)executable).newInstance(parameters) : ((Method)executable).invoke(null, parameters));
        }
        int len = parameters.length;
        Class[] parameterTypes = new Class[len];
        for (int i = 0; i < len; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        if (parameterTypes.length == 1 && parameterTypes[0] == String.class && (fromString = Classes.getMethod(type, "fromString", parameterTypes)) != null && Modifier.isStatic(fromString.getModifiers())) {
            classToExecutable.put(type, fromString);
            return (T)fromString.invoke(null, parameters);
        }
        Method valueOf = Classes.getCompatibleMethod(type, "valueOf", parameterTypes);
        if (valueOf != null && Modifier.isStatic(valueOf.getModifiers())) {
            classToExecutable.put(type, valueOf);
            return (T)valueOf.invoke(null, parameters);
        }
        Constructor<T> constructor = Classes.getCompatibleConstructor(type, parameterTypes);
        if (constructor != null) {
            classToExecutable.put(type, constructor);
            return constructor.newInstance(parameters);
        }
        StringBuilder methodSignature = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                methodSignature.append(',');
            }
            methodSignature.append(parameterTypes[i].getName());
        }
        StringBuilder message = new StringBuilder();
        message.append(type.getName()).append(" does not define <init>(").append((CharSequence)methodSignature).append(')');
        if (parameterTypes.length == 1 && parameterTypes[0] == String.class) {
            message.append(", valueOf(").append((CharSequence)methodSignature).append("), or fromString(").append((CharSequence)methodSignature).append(')');
        } else {
            message.append(" or valueOf(").append((CharSequence)methodSignature).append(')');
        }
        throw new IllegalArgumentException(message.toString());
    }

    public static Class<?> forNameOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> forNameOrNull(String name, boolean initialize, ClassLoader loader) {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String getName(Class<?> cls) {
        return cls.isPrimitive() || cls.isArray() ? cls.getCanonicalName() : cls.getName();
    }

    private static String getSignature(Method method) {
        StringBuilder b = new StringBuilder();
        b.append(method.getModifiers());
        b.append(':');
        b.append(method.getDeclaringClass().getName());
        b.append('.');
        b.append(method.getName());
        int i = b.length();
        for (Class<?> parameterType : method.getParameterTypes()) {
            b.append(',').append(Classes.getName(parameterType));
        }
        if (b.length() > i) {
            b.setCharAt(i, '(');
        } else {
            b.append('(');
        }
        b.append("):");
        b.append(Classes.getName(method.getReturnType()));
        return b.toString();
    }

    private static String getSignature(CtMethod method) throws Exception {
        return method.getModifiers() + ":" + method.getLongName() + ":" + method.getReturnType().getName();
    }

    public static boolean sortDeclarativeOrder(Method[] methods, boolean superFirst) throws ClassNotFoundException {
        int len = methods.length;
        if (len == 0) {
            return true;
        }
        if (hasJavaAssist == null) {
            hasJavaAssist = Class.forName("javassist.ClassPool") != null;
        }
        if (!hasJavaAssist.booleanValue()) {
            return false;
        }
        Arrays.sort(methods, (m1, m2) -> {
            Class<?> c2;
            Class<?> c1 = m1.getDeclaringClass();
            return c1 == (c2 = m2.getDeclaringClass()) ? 0 : (c1.isAssignableFrom(c2) == superFirst ? -1 : 1);
        });
        HashMap<String, Integer> methodSigToIndex = new HashMap<String, Integer>(len);
        for (int i = 0; i < len; ++i) {
            methodSigToIndex.put(Classes.getSignature(methods[i]), i);
        }
        Object[][] methodLineNumbers = new Object[len][2];
        for (int i = 0; i < len; ++i) {
            methodLineNumbers[i] = new Object[]{methods[i], null};
        }
        boolean[] success = new boolean[]{true};
        try {
            int i;
            ClassPool pool = ClassPool.getDefault();
            Class<?> last = null;
            for (i = 0; i < len; ++i) {
                Class<?> cls = methods[i].getDeclaringClass();
                if (cls != last) {
                    CtClass ctClass = pool.get(cls.getName());
                    for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
                        Integer index = (Integer)methodSigToIndex.get(Classes.getSignature(ctMethod));
                        if (index == null) continue;
                        int lineNumber = ctMethod.getMethodInfo().getLineNumber(0);
                        success[0] = success[0] & lineNumber != -1;
                        methodLineNumbers[index.intValue()][1] = lineNumber;
                    }
                }
                last = cls;
            }
            Arrays.sort(methodLineNumbers, (ml1, ml2) -> {
                Class<?> c2;
                Class<?> c1 = ((Method)ml1[0]).getDeclaringClass();
                if (c1 != (c2 = ((Method)ml2[0]).getDeclaringClass())) {
                    return c1.isAssignableFrom(c2) == superFirst ? -1 : 1;
                }
                if (ml1[1] == null) {
                    success[0] = false;
                    Classes.warnNotFound((Method)ml1[0]);
                    return ml2[1] == null ? 0 : 1;
                }
                if (ml2[1] == null) {
                    success[0] = false;
                    Classes.warnNotFound((Method)ml2[0]);
                    return ml1[1] == null ? 0 : -1;
                }
                return Integer.compare((Integer)ml1[1], (Integer)ml2[1]);
            });
            for (i = 0; i < len; ++i) {
                methods[i] = (Method)methodLineNumbers[i][0];
            }
            return success[0];
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void warnNotFound(Method method) {
        if (!logger.isWarnEnabled()) {
            return;
        }
        String signature = Classes.getSignature(method);
        Set<String> errorMethodSigs = Classes.errorMethodSigs.get();
        if (errorMethodSigs == null) {
            errorMethodSigs = new HashSet<String>();
            Classes.errorMethodSigs.set(errorMethodSigs);
        } else if (errorMethodSigs.add(signature)) {
            logger.warn(Classes.class.getName() + "#sortDeclarativeOrder: Could not find " + signature);
        }
    }

    public static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String getInternalName(Class<?> ... classes) {
        StringBuilder b = new StringBuilder();
        for (Class<?> cls : classes) {
            b.append(Classes.getInternalName(cls));
        }
        return b.toString();
    }

    public static String getInternalName(Class<?> cls) {
        if (cls.isArray()) {
            return "[" + Classes.getInternalName(cls.getComponentType());
        }
        int i$ = primitiveClasses.length;
        for (int i = 0; i < i$; ++i) {
            if (primitiveClasses[i] != cls) continue;
            return primitiveInternalNames[i];
        }
        return "L" + cls.getName().replace('.', '/') + ";";
    }

    private Classes() {
    }

    @FunctionalInterface
    private static interface DeclaredClassRecurser<A>
    extends SuperclassRecurser<Class<?>, A> {
        default public Class<?>[] members(Class<?> container) {
            return container.getDeclaredClasses();
        }
    }

    @FunctionalInterface
    private static interface DeclaredMethodRecurser<A>
    extends SuperclassRecurser<Method, A> {
        default public Method[] members(Class<?> container) {
            return container.getDeclaredMethods();
        }
    }

    @FunctionalInterface
    private static interface MethodRecurser<A>
    extends SuperclassRecurser<Method, A> {
        default public Method[] members(Class<?> container) {
            return container.getMethods();
        }
    }

    @FunctionalInterface
    private static interface DeclaredFieldRecurser<A>
    extends SuperclassRecurser<Field, A> {
        default public Field[] members(Class<?> container) {
            return container.getDeclaredFields();
        }
    }

    private static interface SuperclassRecurser<M, A>
    extends Repeat.Recurser<Class<?>, M, A> {
        @Override
        default public Class<?> next(Class<?> container) {
            return container.getSuperclass();
        }
    }
}

