/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Enumerations {
    private static <E> E[] recurse(Enumeration<? extends E> enumeration, E[] dest, Class<E> componentType, int depth) {
        if (!enumeration.hasMoreElements()) {
            return dest != null && dest.length >= depth ? dest : (depth == 0 ? null : (Object[])Array.newInstance(componentType, depth));
        }
        E element = enumeration.nextElement();
        E[] array = Enumerations.recurse(enumeration, dest, componentType, depth + 1);
        array[depth] = element;
        return array;
    }

    private static <T, E> E[] recurse(Enumeration<? extends T> enumeration, E[] dest, Class<E> componentType, Function<T, E> function, int depth) {
        if (!enumeration.hasMoreElements()) {
            return dest != null && dest.length >= depth ? dest : (depth == 0 ? null : (Object[])Array.newInstance(componentType, depth));
        }
        E element = function.apply(enumeration.nextElement());
        E[] array = Enumerations.recurse(enumeration, dest, componentType, function, depth + 1);
        array[depth] = element;
        return array;
    }

    public static <T> T[] toArray(Enumeration<? extends T> enumeration, Class<T> componentType) {
        return Enumerations.recurse(enumeration, null, componentType, 0);
    }

    public static <T, E> E[] toArray(Enumeration<? extends T> enumeration, Class<E> componentType, Function<T, E> function) {
        return Enumerations.recurse(enumeration, null, componentType, function, 0);
    }

    public static <T> T[] toArray(Enumeration<? extends T> enumeration, T[] array) {
        return Enumerations.recurse(enumeration, array, array.getClass().getComponentType(), 0);
    }

    public static <T, E> E[] toArray(Enumeration<? extends T> enumeration, E[] array, Function<T, E> function) {
        return Enumerations.recurse(enumeration, array, array.getClass().getComponentType(), function, 0);
    }

    public static <T> List<T> asList(Enumeration<? extends T> enumeration, Class<T> componentType) {
        return Arrays.asList(Enumerations.toArray(enumeration, componentType));
    }

    public static <T> Stream<T> asStream(final Enumeration<T> enumeration) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!enumeration.hasMoreElements()) {
                    return false;
                }
                action.accept(enumeration.nextElement());
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (enumeration.hasMoreElements()) {
                    action.accept(enumeration.nextElement());
                }
            }
        }, false);
    }

    public static int getSize(Enumeration<?> enumeration) {
        int size = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++size;
        }
        return size;
    }

    public static <T> Enumeration<T> singleton(final T o) {
        return new Enumeration<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasNext;
            }

            @Override
            public T nextElement() {
                this.hasNext = false;
                return o;
            }
        };
    }

    private Enumerations() {
    }
}

