/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.Objects;
import org.libj.lang.Assertions;
import org.libj.lang.BigIntegers;
import org.libj.lang.Strings;

public final class Numbers {
    public static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final Comparator<Number> comparator = (o1, o2) -> {
        if (o1 == null) {
            return o2 == null ? 0 : 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof BigDecimal) {
            if (o2 instanceof BigDecimal) {
                return ((BigDecimal)o1).compareTo((BigDecimal)o2);
            }
            if (o2 instanceof BigInteger) {
                return ((BigDecimal)o1).compareTo(new BigDecimal((BigInteger)o2));
            }
            if (o2 instanceof Byte || o2 instanceof Short || o2 instanceof Integer || o2 instanceof Long) {
                return ((BigDecimal)o1).compareTo(BigDecimal.valueOf(o2.longValue()));
            }
            return ((BigDecimal)o1).compareTo(BigDecimal.valueOf(o2.doubleValue()));
        }
        if (o1 instanceof BigInteger) {
            if (o2 instanceof BigInteger) {
                return ((BigInteger)o1).compareTo((BigInteger)o2);
            }
            if (o2 instanceof BigDecimal) {
                return new BigDecimal((BigInteger)o1).compareTo((BigDecimal)o2);
            }
            if (o2 instanceof Byte || o2 instanceof Short || o2 instanceof Integer || o2 instanceof Long) {
                return ((BigInteger)o1).compareTo(BigInteger.valueOf(o2.longValue()));
            }
            return new BigDecimal((BigInteger)o1).compareTo(BigDecimal.valueOf(o2.doubleValue()));
        }
        if (o1 instanceof Byte || o1 instanceof Short || o1 instanceof Integer || o1 instanceof Long) {
            if (o2 instanceof BigInteger) {
                return BigInteger.valueOf(o1.longValue()).compareTo((BigInteger)o2);
            }
            if (o2 instanceof BigDecimal) {
                return BigDecimal.valueOf(o1.doubleValue()).compareTo((BigDecimal)o2);
            }
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        }
        if (o2 instanceof BigInteger) {
            return BigDecimal.valueOf(o1.doubleValue()).compareTo(new BigDecimal((BigInteger)o2));
        }
        if (o2 instanceof BigDecimal) {
            return BigDecimal.valueOf(o1.doubleValue()).compareTo((BigDecimal)o2);
        }
        return Double.compare(o1.doubleValue(), o2.doubleValue());
    };
    private static final int[] highestBitSet = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    public static final double LOG_2 = 0.6931471805599453;
    public static final double LOG_10 = 2.302585092994046;
    private static final String MIN_LONG = "-9223372036854775808";
    private static final String MAX_LONG = "9223372036854775807";

    public static int compare(Number a, Number b) {
        return comparator.compare(a, b);
    }

    public static long pow(long base, int exp) {
        long result = 1L;
        switch (highestBitSet[exp]) {
            case 255: {
                return base == 1L ? 1L : (base == -1L ? (long)(1 - 2 * (exp & 1)) : 0L);
            }
            case 6: {
                if ((exp & 1) != 0) {
                    result = Numbers.checkedMultiple(result, base);
                }
                exp >>= 1;
                base *= base;
            }
            case 5: {
                if ((exp & 1) != 0) {
                    result *= base;
                }
                exp >>= 1;
                base *= base;
            }
            case 4: {
                if ((exp & 1) != 0) {
                    result *= base;
                }
                exp >>= 1;
                base *= base;
            }
            case 3: {
                if ((exp & 1) != 0) {
                    result *= base;
                }
                exp >>= 1;
                base *= base;
            }
            case 2: {
                if ((exp & 1) != 0) {
                    result *= base;
                }
                exp >>= 1;
                base *= base;
            }
            case 1: {
                if ((exp & 1) == 0) break;
                result *= base;
            }
        }
        return result;
    }

    public static Byte parseByte(CharSequence s) {
        return Numbers.parseByte(s, null);
    }

    public static Byte parseByte(CharSequence s, Byte defaultValue) {
        return s == null ? defaultValue : Numbers.parseByte0(s, 0, s.length(), 10, defaultValue);
    }

    public static Byte parseByte(CharSequence s, int fromIndex, int toIndex) {
        return Numbers.parseByte(s, fromIndex, toIndex, null);
    }

    public static Byte parseByte(CharSequence s, int fromIndex, int toIndex, Byte defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseByte0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static byte parseByte(CharSequence s, byte defaultValue) {
        return s == null ? defaultValue : Numbers.parseByte0(s, 0, s.length(), 10, defaultValue);
    }

    public static byte parseByte(CharSequence s, int fromIndex, int toIndex, byte defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseByte0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static byte parseByte(char[] cbuf, byte defaultValue) {
        return cbuf == null ? defaultValue : Numbers.parseByte0(cbuf, 0, cbuf.length, 10, defaultValue);
    }

    public static byte parseByte(char[] cbuf, int fromIndex, int toIndex, byte defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseByte0(cbuf, fromIndex, toIndex, 10, defaultValue);
    }

    public static Byte parseByte(CharSequence s, int radix) {
        if (s == null) {
            return null;
        }
        int i = Numbers.parseInt0(s, 0, s.length(), radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? null : Byte.valueOf((byte)i);
    }

    public static Byte parseByte(CharSequence s, int fromIndex, int toIndex, int radix) {
        return Numbers.parseByte(s, fromIndex, toIndex, radix, null);
    }

    public static Byte parseByte(CharSequence s, int fromIndex, int toIndex, int radix, Byte defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseByte0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static Byte parseByte0(CharSequence s, int fromIndex, int toIndex, int radix, Byte defaultValue) {
        int i = Numbers.parseInt0(s, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? defaultValue : Byte.valueOf((byte)i);
    }

    public static Byte parseByte(char[] cbuf, int radix) {
        if (cbuf == null) {
            return null;
        }
        int i = Numbers.parseInt0(cbuf, 0, cbuf.length, radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? null : Byte.valueOf((byte)i);
    }

    public static Byte parseByte(char[] cbuf, int fromIndex, int toIndex, int radix) {
        if (cbuf == null) {
            return null;
        }
        int i = Numbers.parseInt(cbuf, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? null : Byte.valueOf((byte)i);
    }

    public static byte parseByte(CharSequence s, int radix, byte defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        int i = Numbers.parseInt0(s, 0, s.length(), radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? defaultValue : (byte)i;
    }

    public static byte parseByte(CharSequence s, int fromIndex, int toIndex, int radix, byte defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseByte0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static byte parseByte0(CharSequence s, int fromIndex, int toIndex, int radix, byte defaultValue) {
        int i = Numbers.parseInt0(s, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? defaultValue : (byte)i;
    }

    public static byte parseByte(char[] cbuf, int radix, byte defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        int i = Numbers.parseInt0(cbuf, 0, cbuf.length, radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? defaultValue : (byte)i;
    }

    public static byte parseByte(char[] cbuf, int fromIndex, int toIndex, int radix, byte defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseByte0(cbuf, fromIndex, toIndex, radix, defaultValue);
    }

    private static byte parseByte0(char[] cbuf, int fromIndex, int toIndex, int radix, byte defaultValue) {
        int i = Numbers.parseInt0(cbuf, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < -128 || i > 127 ? defaultValue : (byte)i;
    }

    public static Short parseShort(CharSequence s) {
        return Numbers.parseShort(s, null);
    }

    public static Short parseShort(CharSequence s, Short defaultValue) {
        return s == null ? defaultValue : Numbers.parseShort0(s, 0, s.length(), 10, defaultValue);
    }

    public static Short parseShort(CharSequence s, int fromIndex, int toIndex) {
        return Numbers.parseShort(s, fromIndex, toIndex, null);
    }

    public static Short parseShort(CharSequence s, int fromIndex, int toIndex, Short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseShort0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static short parseShort(CharSequence s, short defaultValue) {
        return s == null ? defaultValue : Numbers.parseShort0(s, 0, s.length(), 10, defaultValue);
    }

    public static short parseShort(CharSequence s, int fromIndex, int toIndex, short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseShort0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static short parseShort(char[] cbuf, short defaultValue) {
        return cbuf == null ? defaultValue : Numbers.parseShort0(cbuf, 0, cbuf.length, 10, defaultValue);
    }

    public static short parseShort(char[] cbuf, int fromIndex, int toIndex, short defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseShort0(cbuf, fromIndex, toIndex, 10, defaultValue);
    }

    public static Short parseShort(CharSequence s, int radix) {
        if (s == null) {
            return null;
        }
        int i = Numbers.parseInt0(s, 0, s.length(), radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? null : Short.valueOf((short)i);
    }

    public static Short parseShort(CharSequence s, int fromIndex, int toIndex, int radix) {
        return Numbers.parseShort(s, fromIndex, toIndex, radix, null);
    }

    public static Short parseShort(CharSequence s, int fromIndex, int toIndex, int radix, Short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseShort0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static Short parseShort0(CharSequence s, int fromIndex, int toIndex, int radix, Short defaultValue) {
        int i = Numbers.parseInt0(s, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? defaultValue : Short.valueOf((short)i);
    }

    public static Short parseShort(char[] cbuf, int radix) {
        if (cbuf == null) {
            return null;
        }
        int i = Numbers.parseInt0(cbuf, 0, cbuf.length, radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? null : Short.valueOf((short)i);
    }

    public static Short parseShort(char[] cbuf, int fromIndex, int toIndex, int radix) {
        if (cbuf == null) {
            return null;
        }
        int i = Numbers.parseInt(cbuf, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? null : Short.valueOf((short)i);
    }

    public static short parseShort(CharSequence s, int radix, short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        int i = Numbers.parseInt0(s, 0, s.length(), radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? defaultValue : (short)i;
    }

    public static short parseShort(CharSequence s, int fromIndex, int toIndex, int radix, short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseShort0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static short parseShort0(CharSequence s, int fromIndex, int toIndex, int radix, short defaultValue) {
        int i = Numbers.parseInt0(s, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? defaultValue : (short)i;
    }

    public static short parseShort(char[] cbuf, int radix, short defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        int i = Numbers.parseInt0(cbuf, 0, cbuf.length, radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? defaultValue : (short)i;
    }

    public static short parseShort(char[] cbuf, int fromIndex, int toIndex, int radix, short defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseShort0(cbuf, fromIndex, toIndex, radix, defaultValue);
    }

    private static short parseShort0(char[] cbuf, int fromIndex, int toIndex, int radix, short defaultValue) {
        int i = Numbers.parseInt0(cbuf, fromIndex, toIndex, radix, Integer.MIN_VALUE);
        return i < Short.MIN_VALUE || i > Short.MAX_VALUE ? defaultValue : (short)i;
    }

    public static Integer parseInteger(CharSequence s) {
        return Numbers.parseInteger(s, null);
    }

    public static Integer parseInteger(CharSequence s, Integer defaultValue) {
        return s == null ? defaultValue : Numbers.parseInteger0(s, 0, s.length(), 10, defaultValue);
    }

    public static Integer parseInteger(CharSequence s, int fromIndex, int toIndex) {
        return Numbers.parseInteger(s, fromIndex, toIndex, null);
    }

    public static Integer parseInteger(CharSequence s, int fromIndex, int toIndex, Integer defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseInteger0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static int parseInt(CharSequence s, int defaultValue) {
        return s == null ? defaultValue : Numbers.parseInt0(s, 0, s.length(), 10, defaultValue);
    }

    public static int parseInt(CharSequence s, int fromIndex, int toIndex, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseInt0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static int parseInt(char[] cbuf, int defaultValue) {
        return cbuf == null ? defaultValue : Numbers.parseInt0(cbuf, 0, cbuf.length, 10, defaultValue);
    }

    public static int parseInt(char[] cbuf, int fromIndex, int toIndex, int defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseInt0(cbuf, fromIndex, toIndex, 10, defaultValue);
    }

    public static int parseInt(CharSequence s, int radix, int defaultValue) {
        return s == null ? defaultValue : Numbers.parseInt0(s, 0, s.length(), radix, defaultValue);
    }

    public static int parseInt(CharSequence s, int fromIndex, int toIndex, int radix, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseInt0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static int parseInt0(CharSequence s, int fromIndex, int toIndex, int radix, int defaultValue) {
        if (radix < 2 || radix > 36) {
            return defaultValue;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return defaultValue;
        }
        boolean negative = false;
        int i = fromIndex;
        int limit = -2147483647;
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        int multmin = limit / radix;
        int result = 0;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                return defaultValue;
            }
            if ((result *= radix) < limit + digit) {
                return defaultValue;
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public static int parseInt(char[] cbuf, int radix, int defaultValue) {
        return cbuf == null ? defaultValue : Numbers.parseInt0(cbuf, 0, cbuf.length, radix, defaultValue);
    }

    public static int parseInt(char[] cbuf, int fromIndex, int toIndex, int radix, int defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseInt0(cbuf, fromIndex, toIndex, radix, defaultValue);
    }

    private static int parseInt0(char[] cbuf, int fromIndex, int toIndex, int radix, int defaultValue) {
        if (radix < 2 || radix > 36) {
            return defaultValue;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return defaultValue;
        }
        boolean negative = false;
        int i = fromIndex;
        int limit = -2147483647;
        char firstChar = cbuf[i];
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        int multmin = limit / radix;
        int result = 0;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(cbuf[i++], radix)) < 0 || result < multmin) {
                return defaultValue;
            }
            if ((result *= radix) < limit + digit) {
                return defaultValue;
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public static Integer parseInteger(CharSequence s, int radix) {
        return Numbers.parseInteger(s, radix, null);
    }

    public static Integer parseInteger(CharSequence s, int radix, Integer defaultValue) {
        return s == null ? defaultValue : Numbers.parseInteger0(s, 0, s.length(), radix, defaultValue);
    }

    public static Integer parseInteger(CharSequence s, int fromIndex, int toIndex, int radix) {
        return Numbers.parseInteger(s, fromIndex, toIndex, radix, null);
    }

    public static Integer parseInteger(CharSequence s, int fromIndex, int toIndex, int radix, Integer defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseInteger0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static Integer parseInteger0(CharSequence s, int fromIndex, int toIndex, int radix, Integer defaultValue) {
        if (radix < 2 || radix > 36) {
            return defaultValue;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return defaultValue;
        }
        boolean negative = false;
        int i = fromIndex;
        int limit = -2147483647;
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        int multmin = limit / radix;
        int result = 0;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                return defaultValue;
            }
            if ((result *= radix) < limit + digit) {
                return defaultValue;
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public static Integer parseInteger(char[] cbuf, int radix) {
        return cbuf == null ? null : Numbers.parseInteger0(cbuf, 0, cbuf.length, radix);
    }

    public static Integer parseInteger(char[] cbuf, int fromIndex, int toIndex, int radix) {
        if (cbuf == null) {
            return null;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseInteger0(cbuf, fromIndex, toIndex, radix);
    }

    private static Integer parseInteger0(char[] cbuf, int fromIndex, int toIndex, int radix) {
        if (radix < 2 || radix > 36) {
            return null;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return null;
        }
        boolean negative = false;
        int i = fromIndex;
        int limit = -2147483647;
        char firstChar = cbuf[i];
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                return null;
            }
            if (len == 1) {
                return null;
            }
            ++i;
        }
        int multmin = limit / radix;
        int result = 0;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(cbuf[i++], radix)) < 0 || result < multmin) {
                return null;
            }
            if ((result *= radix) < limit + digit) {
                return null;
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public static Long parseLong(CharSequence s) {
        return Numbers.parseLong(s, null);
    }

    public static Long parseLong(CharSequence s, Long defaultValue) {
        return s == null ? defaultValue : Numbers.parseLong0(s, 0, s.length(), 10, defaultValue);
    }

    public static Long parseLong(CharSequence s, int fromIndex, int toIndex) {
        return Numbers.parseLong(s, fromIndex, toIndex, null);
    }

    public static Long parseLong(CharSequence s, int fromIndex, int toIndex, Long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseLong0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static long parseLong(CharSequence s, long defaultValue) {
        return s == null ? defaultValue : Numbers.parseLong0(s, 0, s.length(), 10, defaultValue);
    }

    public static long parseLong(CharSequence s, int fromIndex, int toIndex, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseLong0(s, fromIndex, toIndex, 10, defaultValue);
    }

    public static long parseLong(char[] cbuf, long defaultValue) {
        return cbuf == null ? defaultValue : Numbers.parseLong0(cbuf, 0, cbuf.length, 10, defaultValue);
    }

    public static long parseLong(char[] cbuf, int fromIndex, int toIndex, long defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseLong0(cbuf, fromIndex, toIndex, 10, defaultValue);
    }

    public static Long parseLong(CharSequence s, int radix) {
        return Numbers.parseLong(s, radix, null);
    }

    public static Long parseLong(CharSequence s, int radix, Long defaultValue) {
        return s == null ? defaultValue : Numbers.parseLong0(s, 0, s.length(), radix, defaultValue);
    }

    public static Long parseLong(CharSequence s, int fromIndex, int toIndex, int radix) {
        return Numbers.parseLong(s, fromIndex, toIndex, radix, null);
    }

    public static Long parseLong(CharSequence s, int fromIndex, int toIndex, int radix, Long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseLong0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static Long parseLong0(CharSequence s, int fromIndex, int toIndex, int radix, Long defaultValue) {
        if (radix < 2 || radix > 36) {
            return defaultValue;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return defaultValue;
        }
        boolean negative = false;
        int i = fromIndex;
        long limit = -9223372036854775807L;
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        long result = 0L;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                return defaultValue;
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                return defaultValue;
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    public static Long parseLong(char[] cbuf, int radix) {
        return cbuf == null ? null : Numbers.parseLong0(cbuf, 0, cbuf.length, radix);
    }

    public static Long parseLong(char[] cbuf, int fromIndex, int toIndex, int radix) {
        if (cbuf == null) {
            return null;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseLong0(cbuf, fromIndex, toIndex, radix);
    }

    private static Long parseLong0(char[] cbuf, int fromIndex, int toIndex, int radix) {
        if (radix < 2 || radix > 36) {
            return null;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return null;
        }
        boolean negative = false;
        int i = fromIndex;
        long limit = -9223372036854775807L;
        char firstChar = cbuf[i];
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                return null;
            }
            if (len == 1) {
                return null;
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        long result = 0L;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(cbuf[i++], radix)) < 0 || result < multmin) {
                return null;
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                return null;
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    public static long parseLong(CharSequence s, int radix, long defaultValue) {
        return s == null ? defaultValue : Numbers.parseLong0(s, 0, s.length(), radix, defaultValue);
    }

    public static long parseLong(CharSequence s, int fromIndex, int toIndex, int radix, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "s.length()", s.length());
        return Numbers.parseLong0(s, fromIndex, toIndex, radix, defaultValue);
    }

    private static long parseLong0(CharSequence s, int fromIndex, int toIndex, int radix, long defaultValue) {
        if (radix < 2 || radix > 36) {
            return defaultValue;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return defaultValue;
        }
        boolean negative = false;
        int i = fromIndex;
        long limit = -9223372036854775807L;
        char firstChar = s.charAt(i);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        long result = 0L;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                return defaultValue;
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                return defaultValue;
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    public static long parseLong(char[] cbuf, int radix, long defaultValue) {
        return cbuf == null ? defaultValue : Numbers.parseLong0(cbuf, 0, cbuf.length, radix);
    }

    public static long parseLong(char[] cbuf, int fromIndex, int toIndex, int radix, long defaultValue) {
        if (cbuf == null) {
            return defaultValue;
        }
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "cbuf.length", cbuf.length);
        return Numbers.parseLong0(cbuf, fromIndex, toIndex, radix);
    }

    private static long parseLong0(char[] cbuf, int fromIndex, int toIndex, int radix, long defaultValue) {
        if (radix < 2 || radix > 36) {
            return defaultValue;
        }
        int len = toIndex - fromIndex;
        if (len == 0) {
            return defaultValue;
        }
        boolean negative = false;
        int i = fromIndex;
        long limit = -9223372036854775807L;
        char firstChar = cbuf[i];
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                return defaultValue;
            }
            if (len == 1) {
                return defaultValue;
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        long result = 0L;
        while (i < toIndex) {
            int digit;
            if ((digit = Character.digit(cbuf[i++], radix)) < 0 || result < multmin) {
                return defaultValue;
            }
            if ((result *= (long)radix) < limit + (long)digit) {
                return defaultValue;
            }
            result -= (long)digit;
        }
        return negative ? result : -result;
    }

    public static Float parseFloat(String s) {
        return Numbers.parseFloat(s, null);
    }

    public static Float parseFloat(String s, Float defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float parseFloat(String s, float defaultValue) {
        try {
            return s == null ? defaultValue : Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Double parseDouble(String s) {
        return Numbers.parseDouble(s, null);
    }

    public static Double parseDouble(String s, Double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseDouble(String s, double defaultValue) {
        try {
            return s == null ? defaultValue : Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int[] parseInt(String ... s) {
        int[] values = new int[s.length];
        int i$ = s.length;
        for (int i = 0; i < i$; ++i) {
            values[i] = Integer.parseInt(s[i]);
        }
        return values;
    }

    public static double[] parseDouble(String ... s) {
        double[] values = new double[s.length];
        int i$ = s.length;
        for (int i = 0; i < i$; ++i) {
            values[i] = Double.parseDouble(s[i]);
        }
        return values;
    }

    public static <N extends Number> N parseNumber(String s, Class<N> as) {
        if (Float.TYPE == as || Float.class == as) {
            return (N)Float.valueOf(s);
        }
        if (Double.TYPE == as || Double.class == as) {
            return (N)Double.valueOf(s);
        }
        if (Byte.TYPE == as || Byte.class == as) {
            return (N)Byte.valueOf(s);
        }
        if (Short.TYPE == as || Short.class == as) {
            return (N)Short.valueOf(s);
        }
        if (Integer.TYPE == as || Integer.class == as) {
            return (N)Integer.valueOf(s);
        }
        if (Long.TYPE == as || Long.class == as) {
            return (N)Long.valueOf(s);
        }
        if (BigInteger.class.isAssignableFrom(as)) {
            return (N)new BigInteger(s);
        }
        if (BigDecimal.class.isAssignableFrom(as)) {
            return (N)new BigDecimal(s);
        }
        throw new UnsupportedOperationException("Unsupported Number type: " + as.getName());
    }

    public static Number parseNumber(String str) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return null;
        }
        char ch = str.charAt(0);
        boolean neg = ch == '-';
        int start = neg || ch == '+' ? 1 : 0;
        int digits = len - start;
        if (digits < 3) {
            return Numbers.parseByte(str);
        }
        if (digits == 3) {
            Integer i = Numbers.parseInteger(str);
            if (i == 0) {
                return null;
            }
            byte b = i.byteValue();
            if (b == i) {
                return b;
            }
            return i.shortValue();
        }
        if (digits < 5) {
            return Numbers.parseShort(str);
        }
        if (digits == 5) {
            Integer i = Numbers.parseInteger(str);
            if (i == null) {
                return null;
            }
            short s = i.shortValue();
            if (s == i) {
                return s;
            }
            return i;
        }
        if (digits < 10) {
            return Numbers.parseInteger(str);
        }
        if (digits == 10) {
            Long l = Numbers.parseLong(str);
            if (l == null) {
                return null;
            }
            int i = l.intValue();
            if ((long)i == l) {
                return i;
            }
            return l;
        }
        if (digits < 19) {
            return Numbers.parseLong(str);
        }
        if (digits == 19) {
            String limit = neg ? MIN_LONG : MAX_LONG;
            for (int i = start; i < len; ++i) {
                ch = str.charAt(i);
                if (!Character.isDigit(ch)) {
                    throw new NumberFormatException(str);
                }
                if (ch <= limit.charAt(i)) continue;
                return new BigInteger(str);
            }
            return Numbers.parseLong(str);
        }
        return Numbers.isNumber(str) ? new BigInteger(str) : null;
    }

    public static <N extends Number> N cast(Number n, Class<N> as) {
        if (n == null) {
            return null;
        }
        if (Long.TYPE == as || Long.class == as) {
            return (N)Long.valueOf(n.longValue());
        }
        if (Integer.TYPE == as || Integer.class == as) {
            return (N)Integer.valueOf(n.intValue());
        }
        if (Short.TYPE == as || Short.class == as) {
            return (N)Short.valueOf(n.shortValue());
        }
        if (Byte.TYPE == as || Byte.class == as) {
            return (N)Byte.valueOf(n.byteValue());
        }
        if (Double.TYPE == as || Double.class == as) {
            return (N)Double.valueOf(n.doubleValue());
        }
        if (Float.TYPE == as || Float.class == as) {
            return (N)Float.valueOf(n.floatValue());
        }
        if (BigInteger.class == as) {
            return (N)new BigInteger(n.toString());
        }
        if (BigDecimal.class == as) {
            return (N)new BigDecimal(n.toString());
        }
        throw new UnsupportedOperationException("Unsupported type: " + as.getName());
    }

    public static boolean isNumber(String s) {
        if (s == null || (s = s.trim()).length() == 0) {
            return false;
        }
        String[] parts = Strings.split(s, ' ');
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2) {
            int slash = parts[1].indexOf(47);
            if (slash < 0) {
                return false;
            }
            return Numbers.isNumber(parts[0], false) && Numbers.isNumber(parts[1], true);
        }
        return Numbers.isNumber(parts[0], true);
    }

    private static boolean isNumber(String s, boolean isFraction) {
        int len;
        if (s == null || (len = (s = s.trim()).length()) == 0) {
            return false;
        }
        boolean dotEncountered = false;
        boolean expEncountered = false;
        boolean minusEncountered = false;
        boolean slashEncountered = false;
        int factor = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c < '0') {
                if (c == '/') {
                    if (!isFraction || dotEncountered || expEncountered || minusEncountered || slashEncountered) {
                        return false;
                    }
                    slashEncountered = true;
                    continue;
                }
                if (c == '.') {
                    if (dotEncountered || slashEncountered) {
                        return false;
                    }
                    dotEncountered = true;
                    continue;
                }
                if (c == '-') {
                    if (minusEncountered) {
                        return false;
                    }
                    minusEncountered = true;
                    continue;
                }
                if (expEncountered || c == '+') continue;
                return false;
            }
            if ('9' < c) {
                if (c != 'E' && c != 'e') {
                    return false;
                }
                if (factor == 0 || expEncountered) {
                    return false;
                }
                expEncountered = true;
                factor = 0;
                minusEncountered = false;
                continue;
            }
            if (minusEncountered) {
                return false;
            }
            ++factor;
        }
        return true;
    }

    private static void assertRadix(int radix) {
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
    }

    public static boolean isDigit(char digit, int radix) {
        int val = Numbers.digit(digit, radix);
        return 0 <= val && val < radix;
    }

    public static boolean isPowerOf2(int a) {
        return a > 0 && Integer.bitCount(a) == 1;
    }

    public static boolean isPowerOf2(long a) {
        return a > 0L && Long.bitCount(a) == 1;
    }

    public static int digit(char digit, int radix) {
        Numbers.assertRadix(radix);
        if ('0' <= digit && digit <= '9') {
            return digit - 48;
        }
        if ('a' <= digit && digit <= 'z') {
            return digit + 10 - 97;
        }
        if ('A' <= digit && digit <= 'Z') {
            return digit + 10 - 65;
        }
        return -digit;
    }

    public static boolean isWhole(float n) {
        return (float)((int)n) == n;
    }

    public static boolean isWhole(double n) {
        return (double)((long)n) == n;
    }

    public static long checkedMultiple(long a, long b) {
        long maximum;
        long l = maximum = Long.signum(a) == Long.signum(b) ? Long.MAX_VALUE : Long.MIN_VALUE;
        if (a != 0L && (b > 0L && b > maximum / a || b < 0L && b < maximum / a)) {
            throw new ArithmeticException("long overflow");
        }
        return a * b;
    }

    public static String toString(double n, int decimals) {
        double factor = StrictMath.pow(10.0, decimals);
        return String.valueOf((double)Math.round(n * factor) / factor);
    }

    public static String stripTrailingZeros(String number) {
        char ch;
        int len;
        if (number == null || (len = number.length()) == 0) {
            return number;
        }
        int i = len - 1;
        while (((ch = number.charAt(i)) == '0' || ch == '.') && --i > 0) {
        }
        if (++i == len) {
            return number;
        }
        int j = i;
        do {
            if ((ch = number.charAt(j)) == 'E' || ch == 'e') {
                i = j;
                while (((ch = number.charAt(--j)) == '0' || ch == '.') && j > 0) {
                }
                return j < 0 ? number : number.substring(0, j + 1) + number.substring(i);
            }
            if (ch != '.') continue;
            return number.substring(0, i);
        } while (--j >= 0);
        return number;
    }

    public static boolean equivalent(Number a, Number b, double epsilon) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Byte) {
            if (b instanceof Byte) {
                return a.byteValue() == b.byteValue();
            }
            if (b instanceof Short) {
                return a.byteValue() == b.shortValue();
            }
            if (b instanceof Integer) {
                return a.byteValue() == b.intValue();
            }
            if (b instanceof Long) {
                return (long)a.byteValue() == b.longValue();
            }
            if (b instanceof BigInteger) {
                return BigInteger.valueOf(a.byteValue()).equals(b);
            }
            if (b instanceof BigDecimal) {
                return BigDecimal.valueOf(a.byteValue()).equals(b);
            }
            if (b instanceof Float) {
                return (double)Math.abs((float)a.byteValue() - b.floatValue()) < epsilon;
            }
            return Math.abs((double)a.byteValue() - b.doubleValue()) < epsilon;
        }
        if (a instanceof Short) {
            if (b instanceof Byte) {
                return a.shortValue() == b.byteValue();
            }
            if (b instanceof Short) {
                return a.shortValue() == b.shortValue();
            }
            if (b instanceof Integer) {
                return a.shortValue() == b.intValue();
            }
            if (b instanceof Long) {
                return (long)a.shortValue() == b.longValue();
            }
            if (b instanceof BigInteger) {
                return BigInteger.valueOf(a.shortValue()).equals(b);
            }
            if (b instanceof BigDecimal) {
                return BigDecimal.valueOf(a.shortValue()).equals(b);
            }
            if (b instanceof Float) {
                return (double)Math.abs((float)a.shortValue() - b.floatValue()) < epsilon;
            }
            return Math.abs((double)a.shortValue() - b.doubleValue()) < epsilon;
        }
        if (a instanceof Integer) {
            if (b instanceof Byte) {
                return a.intValue() == b.byteValue();
            }
            if (b instanceof Short) {
                return a.intValue() == b.shortValue();
            }
            if (b instanceof Integer) {
                return a.intValue() == b.intValue();
            }
            if (b instanceof Long) {
                return (long)a.intValue() == b.longValue();
            }
            if (b instanceof BigInteger) {
                return BigInteger.valueOf(a.intValue()).equals(b);
            }
            if (b instanceof BigDecimal) {
                return BigDecimal.valueOf(a.intValue()).equals(b);
            }
            if (b instanceof Float) {
                return (double)Math.abs((float)a.intValue() - b.floatValue()) < epsilon;
            }
            return Math.abs((double)a.intValue() - b.doubleValue()) < epsilon;
        }
        if (a instanceof Long) {
            if (b instanceof Byte) {
                return a.longValue() == (long)b.byteValue();
            }
            if (b instanceof Short) {
                return a.longValue() == (long)b.shortValue();
            }
            if (b instanceof Integer) {
                return a.longValue() == (long)b.intValue();
            }
            if (b instanceof Long) {
                return a.longValue() == b.longValue();
            }
            if (b instanceof BigInteger) {
                return BigInteger.valueOf(a.longValue()).equals(b);
            }
            if (b instanceof BigDecimal) {
                return BigDecimal.valueOf(a.longValue()).equals(b);
            }
            if (b instanceof Float) {
                return (double)Math.abs((float)a.longValue() - b.floatValue()) < epsilon;
            }
            return Math.abs((double)a.longValue() - b.doubleValue()) < epsilon;
        }
        if (a instanceof BigInteger) {
            if (b instanceof Byte) {
                return a.equals(BigInteger.valueOf(b.byteValue()));
            }
            if (b instanceof Short) {
                return a.equals(BigInteger.valueOf(b.shortValue()));
            }
            if (b instanceof Integer) {
                return a.equals(BigInteger.valueOf(b.intValue()));
            }
            if (b instanceof Long) {
                return a.equals(BigInteger.valueOf(b.longValue()));
            }
            if (b instanceof BigInteger) {
                return a.equals(b);
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal((BigInteger)a).equals(b);
            }
            if (b instanceof Float) {
                return a.equals(BigDecimal.valueOf(b.floatValue()).toBigInteger());
            }
            if (b instanceof Double) {
                return a.equals(BigDecimal.valueOf(b.doubleValue()).toBigInteger());
            }
        } else if (a instanceof BigDecimal) {
            if (b instanceof Byte) {
                return a.equals(BigDecimal.valueOf(b.byteValue()));
            }
            if (b instanceof Short) {
                return a.equals(BigDecimal.valueOf(b.shortValue()));
            }
            if (b instanceof Integer) {
                return a.equals(BigDecimal.valueOf(b.intValue()));
            }
            if (b instanceof Long) {
                return a.equals(BigDecimal.valueOf(b.longValue()));
            }
            if (b instanceof BigInteger) {
                return a.equals(new BigDecimal((BigInteger)b));
            }
            if (b instanceof BigDecimal) {
                return a.equals(b);
            }
            if (b instanceof Float) {
                return a.equals(BigDecimal.valueOf(b.floatValue()).toBigInteger());
            }
            if (b instanceof Double) {
                return a.equals(BigDecimal.valueOf(b.doubleValue()));
            }
        }
        return Math.abs(a.doubleValue() - b.doubleValue()) < epsilon;
    }

    public static BigDecimal toBigDecimal(Number n) {
        Objects.requireNonNull(n);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger)n);
        }
        if (n instanceof Byte) {
            return BigDecimal.valueOf(n.byteValue());
        }
        if (n instanceof Short) {
            return BigDecimal.valueOf(n.shortValue());
        }
        if (n instanceof Integer) {
            return BigDecimal.valueOf(n.intValue());
        }
        if (n instanceof Long) {
            return BigDecimal.valueOf(n.longValue());
        }
        if (n instanceof Float) {
            return BigDecimal.valueOf(n.floatValue()).stripTrailingZeros();
        }
        return BigDecimal.valueOf(n.doubleValue()).stripTrailingZeros();
    }

    public static BigDecimal average(BigDecimal ... numbers) {
        BigDecimal sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum = sum.add(numbers[i]);
        }
        return sum.divide(BigDecimal.valueOf(numbers.length), RoundingMode.HALF_UP);
    }

    public static BigDecimal average(BigInteger ... numbers) {
        BigDecimal sum = new BigDecimal(numbers[0]);
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum = sum.add(new BigDecimal(numbers[i]));
        }
        return sum.divide(BigDecimal.valueOf(numbers.length), RoundingMode.HALF_UP);
    }

    public static double average(byte ... numbers) {
        long sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum += (long)numbers[i];
        }
        return sum / (long)numbers.length;
    }

    public static double average(short ... numbers) {
        long sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum += (long)numbers[i];
        }
        return sum / (long)numbers.length;
    }

    public static double average(int ... numbers) {
        long sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum += (long)numbers[i];
        }
        return sum / (long)numbers.length;
    }

    public static double average(long ... numbers) {
        long sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum += numbers[i];
        }
        return sum / (long)numbers.length;
    }

    public static double average(float ... numbers) {
        double sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum += (double)numbers[i];
        }
        return sum / (double)numbers.length;
    }

    public static double average(double ... numbers) {
        double sum = numbers[0];
        int i$ = numbers.length;
        for (int i = 1; i < i$; ++i) {
            sum += numbers[i];
        }
        return sum / (double)numbers.length;
    }

    public static Number reduce(Number number) {
        if (number == null || number instanceof Float || number instanceof Double || number instanceof BigDecimal || number instanceof Byte) {
            return number;
        }
        double value = number.doubleValue();
        if (-128.0 <= value && value <= 127.0) {
            return number.byteValue();
        }
        if (-32768.0 <= value && value <= 32767.0) {
            return number.shortValue();
        }
        if (-2.147483648E9 <= value && value <= 2.147483647E9) {
            return number.intValue();
        }
        if (-9.223372036854776E18 <= value && value <= 9.223372036854776E18) {
            return number.longValue();
        }
        return number;
    }

    public static boolean isWholeNumberType(Class<? extends Number> cls) {
        if (cls == null) {
            return false;
        }
        if (Byte.TYPE == cls || Byte.class == cls) {
            return true;
        }
        if (Short.TYPE == cls || Short.class == cls) {
            return true;
        }
        if (Integer.TYPE == cls || Integer.class == cls) {
            return true;
        }
        if (Long.TYPE == cls || Long.class == cls) {
            return true;
        }
        return BigInteger.class.isAssignableFrom(cls);
    }

    public static byte precision(byte n) {
        int i = Math.abs(n);
        return (byte)(i < 10 ? 1 : (i < 100 ? 2 : 3));
    }

    public static byte precision(short n) {
        int i = Math.abs(n);
        if (i < 10000) {
            if (i < 100) {
                if (i < 10) {
                    return 1;
                }
                return 2;
            }
            if (i < 1000) {
                return 3;
            }
            return 4;
        }
        return 5;
    }

    public static byte precision(int n) {
        if ((n = Math.abs(n)) < 1000000000) {
            if (n < 10000) {
                if (n < 100) {
                    if (n < 10) {
                        if (n < 0) {
                            return 10;
                        }
                        return 1;
                    }
                    return 2;
                }
                if (n < 1000) {
                    return 3;
                }
                return 4;
            }
            if (n < 10000000) {
                if (n < 100000) {
                    return 5;
                }
                if (n < 1000000) {
                    return 6;
                }
                return 7;
            }
            if (n < 100000000) {
                return 8;
            }
            return 9;
        }
        return 10;
    }

    public static byte precision(long n) {
        if ((n = Math.abs(n)) < 1000000000L) {
            if (n < 10000L) {
                if (n < 100L) {
                    if (n < 10L) {
                        if (n < 0L) {
                            return 19;
                        }
                        return 1;
                    }
                    return 2;
                }
                if (n < 1000L) {
                    return 3;
                }
                return 4;
            }
            if (n < 10000000L) {
                if (n < 100000L) {
                    return 5;
                }
                if (n < 1000000L) {
                    return 6;
                }
                return 7;
            }
            if (n < 100000000L) {
                return 8;
            }
            return 9;
        }
        if (n < 1000000000000000L) {
            if (n < 1000000000000L) {
                if (n < 10000000000L) {
                    return 10;
                }
                if (n < 100000000000L) {
                    return 11;
                }
                return 12;
            }
            if (n < 10000000000000L) {
                return 13;
            }
            if (n < 100000000000000L) {
                return 14;
            }
            return 15;
        }
        if (n < 100000000000000000L) {
            if (n < 10000000000000000L) {
                return 16;
            }
            return 17;
        }
        if (n < 1000000000000000000L) {
            return 18;
        }
        return 19;
    }

    public static int precision(BigInteger n) {
        if (n.signum() == 0) {
            return 1;
        }
        int p = (int)((long)(n.bitLength() + 1) * 646456993L >>> 31);
        return n.abs().compareTo(BigInteger.TEN.pow(p)) < 0 ? p : p + 1;
    }

    public static int precision(BigDecimal n) {
        return n.signum() == 0 ? 1 : n.precision();
    }

    public static byte trailingZeroes(byte n) {
        return (byte)(n == 0 ? 1 : (n % 10 != 0 ? 0 : (n % 100 != 0 ? 1 : 2)));
    }

    public static byte trailingZeroes(short n) {
        if (n == 0) {
            return 1;
        }
        if (n % 10000 != 0) {
            if (n % 100 != 0) {
                if (n % 10 != 0) {
                    return 0;
                }
                return 1;
            }
            if (n % 1000 != 0) {
                return 2;
            }
            return 3;
        }
        return 4;
    }

    public static byte trailingZeroes(int n) {
        if (n == 0) {
            return 1;
        }
        if (n % 1000000000 != 0) {
            if (n % 10000 != 0) {
                if (n % 100 != 0) {
                    if (n % 10 != 0) {
                        return 0;
                    }
                    return 1;
                }
                if (n % 1000 != 0) {
                    return 2;
                }
                return 3;
            }
            if (n % 10000000 != 0) {
                if (n % 100000 != 0) {
                    return 4;
                }
                if (n % 1000000 != 0) {
                    return 5;
                }
                return 6;
            }
            if (n % 100000000 != 0) {
                return 7;
            }
            return 8;
        }
        return 9;
    }

    public static byte trailingZeroes(long n) {
        if (n == 0L) {
            return 1;
        }
        if (n % 1000000000L != 0L) {
            if (n % 10000L != 0L) {
                if (n % 100L != 0L) {
                    if (n % 10L != 0L) {
                        return 0;
                    }
                    return 1;
                }
                if (n % 1000L != 0L) {
                    return 2;
                }
                return 3;
            }
            if (n % 10000000L != 0L) {
                if (n % 100000L != 0L) {
                    return 4;
                }
                if (n % 1000000L != 0L) {
                    return 5;
                }
                return 6;
            }
            if (n % 100000000L != 0L) {
                return 7;
            }
            return 8;
        }
        if (n % 1000000000000000L != 0L) {
            if (n % 1000000000000L != 0L) {
                if (n % 10000000000L != 0L) {
                    return 9;
                }
                if (n % 100000000000L != 0L) {
                    return 10;
                }
                return 11;
            }
            if (n % 10000000000000L != 0L) {
                return 12;
            }
            if (n % 100000000000000L != 0L) {
                return 13;
            }
            return 14;
        }
        if (n % 100000000000000000L != 0L) {
            if (n % 10000000000000000L != 0L) {
                return 15;
            }
            return 16;
        }
        if (n % 1000000000000000000L != 0L) {
            return 17;
        }
        return 18;
    }

    public static int signum(Number a) {
        if (a instanceof Integer) {
            return Numbers.signum((Integer)a);
        }
        if (a instanceof Long) {
            return Numbers.signum((Long)a);
        }
        if (a instanceof BigInteger) {
            return ((BigInteger)a).signum();
        }
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).signum();
        }
        if (a instanceof Double) {
            return Numbers.signum((Double)a);
        }
        if (a instanceof Float) {
            return Numbers.signum(((Float)a).floatValue());
        }
        if (a instanceof Short) {
            return Numbers.signum((Short)a);
        }
        if (a instanceof Byte) {
            return Numbers.signum((Byte)a);
        }
        return Numbers.signum(a.doubleValue());
    }

    public static int signum(byte a) {
        return a < 0 ? -1 : (a > 0 ? 1 : 0);
    }

    public static int signum(short a) {
        return a < 0 ? -1 : (a > 0 ? 1 : 0);
    }

    public static int signum(int a) {
        return a < 0 ? -1 : (a > 0 ? 1 : 0);
    }

    public static int signum(long a) {
        return a < 0L ? -1 : (a > 0L ? 1 : 0);
    }

    public static int signum(float a) {
        return a < 0.0f ? -1 : (a > 0.0f ? 1 : 0);
    }

    public static int signum(double a) {
        return a < 0.0 ? -1 : (a > 0.0 ? 1 : 0);
    }

    public static <N extends Number> N add(N a, N b) {
        if (a instanceof BigDecimal) {
            return (N)((BigDecimal)a).add((BigDecimal)b);
        }
        if (a instanceof BigInteger) {
            return (N)((BigInteger)a).add((BigInteger)b);
        }
        if (a instanceof Byte) {
            return (N)Integer.valueOf((Byte)a + (Byte)b);
        }
        if (a instanceof Short) {
            return (N)Integer.valueOf((Short)a + (Short)b);
        }
        if (a instanceof Integer) {
            return (N)Integer.valueOf((Integer)a + (Integer)b);
        }
        if (a instanceof Long) {
            return (N)Long.valueOf((Long)a + (Long)b);
        }
        if (a instanceof Float) {
            return (N)Float.valueOf(((Float)a).floatValue() + ((Float)b).floatValue());
        }
        if (a instanceof Double) {
            return (N)Double.valueOf((Double)a + (Double)b);
        }
        Objects.requireNonNull(a);
        throw new UnsupportedOperationException("Unsupported type: " + a.getClass().getName());
    }

    private Numbers() {
    }

    public static final class Composite {
        public static long encode(int a, int b) {
            return (long)b << 32 & 0xFFFFFFFF00000000L | (long)a & 0xFFFFFFFFL;
        }

        public static long encode(short a, short b, short c, short d) {
            return (long)d << 48 & 0xFFFF000000000000L | (long)c << 32 & 0xFFFF00000000L | (long)b << 16 & 0xFFFF0000L | (long)a & 0xFFFFL;
        }

        public static long encode(byte a, byte b, byte c, byte d, byte e, byte f, byte g, byte h) {
            return (long)h << 56 & 0xFF00000000000000L | (long)g << 48 & 0xFF000000000000L | (long)f << 40 & 0xFF0000000000L | (long)e << 32 & 0xFF00000000L | (long)d << 24 & 0xFF000000L | (long)c << 16 & 0xFF0000L | (long)b << 8 & 0xFF00L | (long)a & 0xFFL;
        }

        public static long encode(float a, float b) {
            return Composite.encode(Float.floatToIntBits(a), Float.floatToIntBits(b));
        }

        public static long encode(float a, int b) {
            return Composite.encode(Float.floatToIntBits(a), b);
        }

        public static long encode(float a, short b, short c) {
            return Composite.encode(Float.floatToIntBits(a), Composite.encode(b, c));
        }

        public static long encode(float a, byte b, byte c, byte d, byte e) {
            return Composite.encode(Float.floatToIntBits(a), Composite.encode(Composite.encode(b, c), Composite.encode(d, e)));
        }

        public static long encode(int a, float b) {
            return Composite.encode(a, Float.floatToIntBits(b));
        }

        public static int encode(short a, short b) {
            return b << 16 | a & 0xFFFF;
        }

        public static int encode(byte a, byte b, byte c, byte d) {
            return d << 24 & 0xFF000000 | c << 16 & 0xFF0000 | b << 8 & 0xFF00 | a & 0xFF;
        }

        public static short encode(byte a, byte b) {
            return (short)(b << 8 & 0xFF00 | a & 0xFF);
        }

        public static int decodeInt(long val, int pos) {
            return (int)(val >> 32 * pos);
        }

        public static float decodeFloat(long val, int pos) {
            return Float.intBitsToFloat((int)(val >> 32 * pos));
        }

        public static short decodeShort(long val, int pos) {
            return (short)(val >> 16 * pos & 0xFFFFL);
        }

        public static byte decodeByte(long val, int pos) {
            return (byte)(val >> 8 * pos & 0xFFL);
        }

        public static short decodeShort(int val, int pos) {
            return (short)(val >> 16 * pos & 0xFFFF);
        }

        public static byte decodeByte(int val, int pos) {
            return (byte)(val >> 8 * pos & 0xFF);
        }

        public static byte decodeByte(short val, int pos) {
            return (byte)(val >> 8 * pos & 0xFF);
        }

        private Composite() {
        }
    }

    public static final class Unsigned {
        public static byte toUINT8(short int8) {
            if (int8 >> 8 != 0) {
                throw new ArithmeticException(int8 + " is too big to fit in 8 bits of an unsigned byte");
            }
            return (byte)int8;
        }

        public static short toUINT16(int int16) {
            if (int16 >> 16 != 0) {
                throw new ArithmeticException(int16 + " is too big to fit in 16 bits of an unsigned short");
            }
            return (short)int16;
        }

        public static int toUINT32(long int32) {
            if (int32 >> 32 != 0L) {
                throw new ArithmeticException(int32 + " is too big to fit in 32 bits of an unsigned int");
            }
            return (int)int32;
        }

        public static long toUINT64(BigInteger int64) {
            if (int64.signum() < 0) {
                throw new ArithmeticException(int64 + " must be positive");
            }
            if (int64.bitLength() > 64) {
                throw new ArithmeticException(int64 + " is too big to fit in 64 bits of an unsigned long");
            }
            return int64.longValue();
        }

        public static byte[] toUINT(BigInteger bigInteger) {
            if (bigInteger.signum() == -1) {
                throw new IllegalArgumentException(bigInteger + " must be positive");
            }
            byte[] bytes = bigInteger.toByteArray();
            if (bytes[0] != 0) {
                return bytes;
            }
            byte[] trimmed = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, trimmed, 0, trimmed.length);
            return trimmed;
        }

        public static BigInteger toUnsignedBigInteger(long uint64) {
            return BigIntegers.valueOf(1, uint64);
        }

        public static BigInteger toUnsignedBigInteger(byte[] uint) {
            return BigIntegers.valueOf(1, uint);
        }

        private Unsigned() {
        }
    }
}

