/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.libj.lang.PackageNotFoundException;
import org.libj.lang.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageLoader {
    private static final Logger logger = LoggerFactory.getLogger(PackageLoader.class);
    private static final ClassLoader bootLoaderProxy = new URLClassLoader(new URL[0], null);
    private static final ConcurrentHashMap<ClassLoader, PackageLoader> instances = new ConcurrentHashMap();
    private final ClassLoader classLoader;

    public static PackageLoader getSystemPackageLoader() {
        return PackageLoader.getPackageLoader(ClassLoader.getSystemClassLoader());
    }

    public static PackageLoader getContextPackageLoader() {
        return PackageLoader.getPackageLoader(Thread.currentThread().getContextClassLoader());
    }

    public static PackageLoader getPackageLoader(ClassLoader classLoader) {
        PackageLoader packageLoader = instances.get(classLoader);
        if (packageLoader == null) {
            packageLoader = new PackageLoader(classLoader);
            instances.put(classLoader, packageLoader);
        }
        return packageLoader;
    }

    protected PackageLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Set<Class<?>> loadPackage(Package pkg) throws IOException, PackageNotFoundException {
        return this.loadPackage(pkg.getName(), true, true);
    }

    public void loadPackage(Package pkg, Predicate<? super Class<?>> initialize) throws IOException, PackageNotFoundException {
        PackageLoader.loadPackage(pkg.getName(), true, false, initialize, this.classLoader);
    }

    public Set<Class<?>> loadPackage(Package pkg, boolean initialize) throws IOException, PackageNotFoundException {
        return this.loadPackage(pkg.getName(), true, initialize);
    }

    public Set<Class<?>> loadPackage(Package pkg, boolean includeSubPackages, boolean initialize) throws IOException, PackageNotFoundException {
        return this.loadPackage(pkg.getName(), includeSubPackages, initialize);
    }

    public Set<Class<?>> loadPackage(String name) throws IOException, PackageNotFoundException {
        return this.loadPackage(name, true, true);
    }

    public Set<Class<?>> loadPackage(String name, boolean initialize) throws IOException, PackageNotFoundException {
        return this.loadPackage(name, true, initialize);
    }

    public void loadPackage(String name, Predicate<? super Class<?>> initialize) throws IOException, PackageNotFoundException {
        PackageLoader.loadPackage(name, true, false, initialize, this.classLoader);
    }

    public void loadPackage(String name, boolean includeSubPackages, Predicate<? super Class<?>> initialize) throws IOException, PackageNotFoundException {
        PackageLoader.loadPackage(name, includeSubPackages, false, initialize, this.classLoader);
    }

    public Set<Class<?>> loadPackage(String name, boolean includeSubPackages, boolean initialize) throws IOException, PackageNotFoundException {
        HashSet classes = new HashSet();
        PackageLoader.loadPackage(name, includeSubPackages, initialize, cls -> {
            classes.add((Class<?>)cls);
            return true;
        }, this.classLoader);
        return classes;
    }

    private static void loadPackage(String packageName, boolean includeSubPackages, boolean initialize, Predicate<? super Class<?>> predicate, ClassLoader classLoader) throws IOException, PackageNotFoundException {
        String resourceName;
        ClassLoader loader = classLoader != null ? classLoader : bootLoaderProxy;
        Enumeration<URL> resources = loader.getResources(resourceName = packageName.replace('.', '/'));
        if (!resources.hasMoreElements()) {
            throw new PackageNotFoundException(packageName.length() > 0 ? packageName : "<default>");
        }
        Resources.traverse(resources, resourceName, includeSubPackages, (root, entry, isDirectory) -> {
            if (isDirectory || !entry.endsWith(".class")) {
                return true;
            }
            try {
                String className = entry.substring(0, entry.length() - 6).replace('/', '.');
                Class<?> cls = Class.forName(className, initialize, loader);
                if (predicate != null && predicate.test(cls)) {
                    Class.forName(className, true, loader);
                }
            }
            catch (ClassNotFoundException | VerifyError e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Problem loading package: " + (packageName.length() > 0 ? packageName : "<default>"), e);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return true;
        });
    }
}

