/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public final class Throwables {
    public static <T extends Throwable> T addSuppressed(T target, T suppressed) {
        if (suppressed == null) {
            return target;
        }
        if (target == null) {
            return suppressed;
        }
        target.addSuppressed(suppressed);
        return target;
    }

    public static <T extends Throwable> T addSuppressed(T target, Exception[] suppressed) {
        return Throwables.addSuppressed0(target, suppressed, 0, suppressed.length);
    }

    public static <T extends Throwable> T addSuppressed(T target, Exception[] suppressed, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return target;
        }
        return Throwables.addSuppressed0(target, suppressed, fromIndex, toIndex);
    }

    private static <T extends Throwable> T addSuppressed0(T target, Exception[] suppressed, int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                target.addSuppressed(suppressed[i]);
            }
        } else {
            for (int i = fromIndex; i > toIndex; --i) {
                target.addSuppressed(suppressed[i]);
            }
        }
        return target;
    }

    public static <T extends Throwable> T addSuppressed(T target, List<Exception> suppressed) {
        return Throwables.addSuppressed0(target, suppressed, 0, suppressed.size());
    }

    public static <T extends Throwable> T addSuppressed(T target, List<Exception> suppressed, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return target;
        }
        return Throwables.addSuppressed0(target, suppressed, fromIndex, toIndex);
    }

    private static <T extends Throwable> T addSuppressed0(T target, List<Exception> suppressed, int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                target.addSuppressed(suppressed.get(i));
            }
        } else {
            for (int i = fromIndex; i > toIndex; --i) {
                target.addSuppressed(suppressed.get(i));
            }
        }
        return target;
    }

    public static String toString(Throwable t) {
        StringWriter out = new StringWriter();
        t.printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    public static <F extends Throwable, T extends F> T copy(F from, T to) {
        ((Throwable)to).initCause(from.getCause());
        ((Throwable)to).setStackTrace(from.getStackTrace());
        for (Throwable suppressed : from.getSuppressed()) {
            ((Throwable)to).addSuppressed(suppressed);
        }
        return to;
    }

    private Throwables() {
    }
}

