/*
 * Decompiled with CFR 0.152.
 */
package org.libj.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.HashMap;
import java.util.List;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final HashMap<String, AnsiColor> colors = new HashMap();
    private static final HashMap<Integer, AnsiColor> levels = new HashMap();
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_END = "m";
    private static final String RESET;
    private static Boolean enabled;

    private static boolean isEnabled() {
        if (enabled != null) {
            return enabled;
        }
        try {
            enabled = !System.getProperty("os.name").toLowerCase().contains("win");
            return enabled;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void setEnabled(boolean enabled) {
        ColorConverter.enabled = enabled;
    }

    protected String transform(ILoggingEvent event, String in) {
        if (!ColorConverter.isEnabled()) {
            return in;
        }
        String group = "3";
        String strength = "0";
        AnsiColor color = null;
        List options = this.getOptionList();
        if (options != null && options.size() > 0) {
            for (String option : options) {
                if ("bold".equals(option)) {
                    group = "3";
                    strength = "1";
                    continue;
                }
                if ("faint".equals(option)) {
                    group = "3";
                    strength = "2";
                    continue;
                }
                if ("italic".equals(option)) {
                    group = "3";
                    strength = "3";
                    continue;
                }
                if ("underline".equals(option)) {
                    group = "3";
                    strength = "4";
                    continue;
                }
                if ("intense".equals(option)) {
                    group = "9";
                    strength = "0";
                    continue;
                }
                color = colors.get(option);
            }
        }
        if (color == null && event.getLevel() != null) {
            color = levels.get(event.getLevel().toInteger());
        }
        if (color == null) {
            color = AnsiColor.DEFAULT;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ENCODE_START).append(strength);
        builder.append(';').append(group).append((Object)color);
        return builder.append(ENCODE_END).append(in).append(ENCODE_START).append(RESET).append(ENCODE_END).toString();
    }

    private void x() {
    }

    static {
        levels.put(Level.ERROR_INTEGER, AnsiColor.RED);
        levels.put(Level.WARN_INTEGER, AnsiColor.YELLOW);
        RESET = "0;3" + (Object)((Object)AnsiColor.DEFAULT);
    }

    private static enum AnsiColor {
        BLACK("0"),
        RED("1"),
        GREEN("2"),
        YELLOW("3"),
        BLUE("4"),
        MAGENTA("5"),
        CYAN("6"),
        WHITE("7"),
        DEFAULT("9");

        private final String code;

        private AnsiColor(String code) {
            this.code = code;
            colors.put(this.name().toLowerCase(), this);
        }

        public String toString() {
            return this.code;
        }
    }
}

