/*
 * Decompiled with CFR 0.152.
 */
package org.libj.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.libj.logging.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeferredLogger {
    private static final LinkedHashMap<Logger, DeferredLogger> deferrers = new LinkedHashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private final ch.qos.logback.classic.Logger logger;
    private final String loggerName;
    private final boolean isRootLogger;
    private final int loggerNameLength;
    private final AppenderBuffer buffer;
    private final int maxEvents;
    private final Supplier<Deque> listSupplier;
    private Level deferredLevel;

    private static Appender<ILoggingEvent> getAppender(ch.qos.logback.classic.Logger logger) {
        if (logger.iteratorForAppenders().hasNext()) {
            return (Appender)logger.iteratorForAppenders().next();
        }
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        if (!rootLogger.iteratorForAppenders().hasNext()) {
            throw new IllegalStateException("ROOT logger does not have an appender");
        }
        return (Appender)rootLogger.iteratorForAppenders().next();
    }

    public static Logger defer(Logger logger, org.slf4j.event.Level deferredLevel, int maxEvents, Supplier<Deque> listSupplier) {
        return DeferredLogger.defer((ch.qos.logback.classic.Logger)logger, LoggerUtil.logbackLevel[deferredLevel.ordinal()], maxEvents, listSupplier);
    }

    public static Logger defer(Logger logger, org.slf4j.event.Level deferredLevel, Supplier<Deque> listSupplier) {
        return DeferredLogger.defer((ch.qos.logback.classic.Logger)logger, LoggerUtil.logbackLevel[deferredLevel.ordinal()], Integer.MAX_VALUE, listSupplier);
    }

    public static Logger defer(Logger logger, org.slf4j.event.Level deferredLevel) {
        return DeferredLogger.defer((ch.qos.logback.classic.Logger)logger, LoggerUtil.logbackLevel[deferredLevel.ordinal()], Integer.MAX_VALUE, LinkedList::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger defer(ch.qos.logback.classic.Logger logger, Level deferredLevel, int maxEvents, Supplier<Deque> listSupplier) {
        LinkedHashMap<Logger, DeferredLogger> linkedHashMap = deferrers;
        synchronized (linkedHashMap) {
            DeferredLogger deferredLogger = deferrers.get(logger);
            if (deferredLogger == null) {
                deferredLogger = new DeferredLogger(logger, maxEvents, listSupplier);
                deferrers.put((Logger)logger, deferredLogger);
            }
            deferredLogger.setDeferredLevel(deferredLevel);
        }
        return logger;
    }

    private boolean matchesLogger(ILoggingEvent event, ch.qos.logback.classic.Logger logger, Appender<ILoggingEvent> appender) {
        char ch;
        String eventLoggerName = event.getLoggerName();
        if (this.isRootLogger) {
            return "ROOT".equals(eventLoggerName) || !((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)event.getLoggerName())).isAttached(appender);
        }
        return eventLoggerName.startsWith(this.loggerName) && (eventLoggerName.length() == this.loggerNameLength || (ch = eventLoggerName.charAt(this.loggerNameLength)) == '.' || ch == '$');
    }

    public static void clear() {
        if (deferrers.size() > 0) {
            for (DeferredLogger dererrer : deferrers.values()) {
                dererrer.buffer.clear();
            }
        }
    }

    public static void clear(Logger logger) {
        DeferredLogger deferredLogger = deferrers.get(logger);
        if (deferredLogger == null) {
            throw new IllegalArgumentException("The specified logger is not a " + DeferredLogger.class.getSimpleName());
        }
        deferredLogger.buffer.clear();
    }

    public static void flush(org.slf4j.event.Level level) {
        if (deferrers.size() > 0) {
            for (DeferredLogger dererrer : deferrers.values()) {
                dererrer.buffer.flush(LoggerUtil.logbackLevel[level.ordinal()]);
            }
        }
    }

    public static void flush() {
        if (deferrers.size() > 0) {
            for (DeferredLogger dererrer : deferrers.values()) {
                dererrer.buffer.flush(dererrer.logger.getLevel());
            }
        }
    }

    public static void flush(Logger logger, org.slf4j.event.Level level) {
        DeferredLogger deferredLogger = deferrers.get(logger);
        if (deferredLogger == null) {
            throw new IllegalArgumentException("The specified logger is not a " + DeferredLogger.class.getSimpleName());
        }
        deferredLogger.buffer.flush(LoggerUtil.logbackLevel[level.ordinal()]);
    }

    public static void flush(Logger logger) {
        DeferredLogger deferredLogger = deferrers.get(logger);
        if (deferredLogger == null) {
            throw new IllegalArgumentException("The specified logger is not a " + DeferredLogger.class.getSimpleName());
        }
        deferredLogger.buffer.flush(deferredLogger.logger.getLevel());
    }

    private DeferredLogger(ch.qos.logback.classic.Logger logger, int maxEvents, Supplier<Deque> listSupplier) {
        this.logger = logger;
        this.loggerName = logger.getName();
        this.loggerNameLength = this.loggerName.length();
        this.isRootLogger = "ROOT".equals(this.loggerName);
        this.maxEvents = maxEvents;
        if (this.maxEvents <= 0) {
            throw new IllegalArgumentException("maxEvents (" + maxEvents + ") must be positive");
        }
        this.listSupplier = Objects.requireNonNull(listSupplier, "listSupplier is null");
        this.buffer = new AppenderBuffer();
    }

    private void setDeferredLevel(Level deferredLevel) {
        this.deferredLevel = deferredLevel;
    }

    private final class AppenderBuffer {
        private final FlushFilter flushFilter = new FlushFilter();
        private final Deque<ILoggingEvent> events;
        private final Appender<ILoggingEvent> appender;

        private AppenderBuffer() {
            this.appender = DeferredLogger.getAppender(DeferredLogger.this.logger);
            this.appender.addFilter((Filter)this.flushFilter);
            this.events = (Deque)DeferredLogger.this.listSupplier.get();
            this.appender.addFilter((Filter)new Filter<ILoggingEvent>(){

                public FilterReply decide(ILoggingEvent event) {
                    boolean loggable;
                    if (!DeferredLogger.this.matchesLogger(event, DeferredLogger.this.logger, (Appender<ILoggingEvent>)AppenderBuffer.this.appender)) {
                        return FilterReply.NEUTRAL;
                    }
                    Level level = event.getLevel();
                    boolean bl = loggable = level.levelInt >= ((DeferredLogger)DeferredLogger.this).logger.getEffectiveLevel().levelInt;
                    if (level.levelInt < ((DeferredLogger)DeferredLogger.this).deferredLevel.levelInt) {
                        return loggable ? FilterReply.ACCEPT : FilterReply.DENY;
                    }
                    if (loggable) {
                        AppenderBuffer.this.addEvent(event);
                    }
                    return FilterReply.DENY;
                }
            });
        }

        private void addEvent(ILoggingEvent event) {
            this.events.add(event);
            int i$ = this.events.size();
            for (int i = DeferredLogger.this.maxEvents; i < i$; ++i) {
                this.events.removeFirst();
            }
        }

        private void clear() {
            DeferredLogger.this.lock.lock();
            this.events.clear();
            DeferredLogger.this.lock.unlock();
        }

        private void flush(Level level) {
            DeferredLogger.this.lock.lock();
            this.flushFilter.setLevel(level);
            int i$ = this.events.size();
            for (int i = 0; i < i$; ++i) {
                ILoggingEvent event = this.events.pollFirst();
                if (event == null || !event.getLevel().isGreaterOrEqual(level)) continue;
                this.appender.doAppend((Object)event);
            }
            this.flushFilter.setLevel(null);
            DeferredLogger.this.lock.unlock();
        }
    }

    private static class FlushFilter
    extends Filter<ILoggingEvent> {
        private Level level;

        private FlushFilter() {
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public FilterReply decide(ILoggingEvent event) {
            return this.level == null ? FilterReply.NEUTRAL : (event.getLevel().isGreaterOrEqual(this.level) ? FilterReply.ACCEPT : FilterReply.DENY);
        }
    }
}

