/*
 * Decompiled with CFR 0.152.
 */
package org.libj.logging;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Objects;
import org.libj.logging.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class LoggerPrintWriter
extends PrintWriter {
    private final StringBuffer buffer = new StringBuffer();
    private final Logger logger;
    private final Level level;

    public LoggerPrintWriter(Logger logger, Level level) {
        super(new Writer(){

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
            }
        });
        this.logger = Objects.requireNonNull(logger);
        this.level = Objects.requireNonNull(level);
    }

    @Override
    public void flush() {
        if (this.buffer.length() == 0 || this.buffer.charAt(this.buffer.length() - 1) != '\n') {
            return;
        }
        LoggerUtil.log(this.logger, this.level, this.buffer.toString());
        this.buffer.setLength(0);
    }

    @Override
    public void close() {
        if (this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) != '\n') {
            this.buffer.append('\n');
        }
        this.flush();
    }

    @Override
    public void write(int c) {
        this.buffer.append(c);
        this.flush();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.buffer.append(buf, off, len);
        this.flush();
    }

    @Override
    public void write(char[] buf) {
        this.buffer.append(buf);
        this.flush();
    }

    @Override
    public void write(String s, int off, int len) {
        this.buffer.append(s, off, off + len);
        this.flush();
    }

    @Override
    public void write(String s) {
        this.buffer.append(s);
        this.flush();
    }

    @Override
    public void print(boolean b) {
        this.buffer.append(b);
    }

    @Override
    public void print(char c) {
        this.buffer.append(c);
        this.flush();
    }

    @Override
    public void print(int i) {
        this.buffer.append(i);
        this.flush();
    }

    @Override
    public void print(long l) {
        this.buffer.append(l);
        this.flush();
    }

    @Override
    public void print(float f) {
        this.buffer.append(f);
        this.flush();
    }

    @Override
    public void print(double d) {
        this.buffer.append(d);
        this.flush();
    }

    @Override
    public void print(char[] s) {
        this.buffer.append(s);
        this.flush();
    }

    @Override
    public void print(String s) {
        this.buffer.append(s);
        this.flush();
    }

    @Override
    public void print(Object obj) {
        this.buffer.append(obj);
        this.flush();
    }

    @Override
    public void println() {
        this.buffer.append('\n');
        this.flush();
    }

    @Override
    public void println(boolean x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(char x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(int x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(long x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(float x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(double x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(char[] x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(String x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public void println(Object x) {
        this.buffer.append(x).append('\n');
        this.flush();
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        this.buffer.append(String.format(format, args));
        this.flush();
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        this.buffer.append(String.format(l, format, args));
        this.flush();
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.buffer.append(csq);
        this.flush();
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.buffer.append(csq, start, end);
        this.flush();
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.buffer.append(c);
        this.flush();
        return this;
    }
}

