/*
 * Decompiled with CFR 0.152.
 */
package org.libj.logging;

import java.io.PrintStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;

public class PrintStreamLogger
implements Logger {
    private static final String TRACE = "[TRACE] ";
    private static final String DEBUG = "[DEBUG] ";
    private static final String INFO = "[INFO] ";
    private static final String WARN = "[WARN] ";
    private static final String ERROR = "[ERROR] ";
    private final PrintStream trace;
    private final PrintStream debug;
    private final PrintStream info;
    private final PrintStream warn;
    private final PrintStream error;
    private final Level level;

    public PrintStreamLogger(Level level, PrintStream trace, PrintStream debug, PrintStream info, PrintStream warn, PrintStream error) {
        this.level = Objects.requireNonNull(level, "level is null");
        this.trace = Objects.requireNonNull(trace, "trace is null");
        this.debug = Objects.requireNonNull(debug, "debug is null");
        this.info = Objects.requireNonNull(info, "info is null");
        this.warn = Objects.requireNonNull(warn, "warn is null");
        this.error = Objects.requireNonNull(error, "error is null");
    }

    public PrintStreamLogger(Level level, PrintStream ps) {
        this.level = Objects.requireNonNull(level, "level is null");
        this.warn = this.error = Objects.requireNonNull(ps, "ps is null");
        this.info = this.error;
        this.debug = this.error;
        this.trace = this.error;
    }

    public PrintStreamLogger(Level level) {
        this.level = Objects.requireNonNull(level, "level is null");
        this.warn = this.error = System.out;
        this.info = this.error;
        this.debug = this.error;
        this.trace = this.error;
    }

    public PrintStreamLogger() {
        this.level = Level.INFO;
        this.warn = this.error = System.out;
        this.info = this.error;
        this.debug = this.error;
        this.trace = this.error;
    }

    public String getName() {
        return "ROOT";
    }

    public boolean isTraceEnabled() {
        return this.level.toInt() <= Level.TRACE.toInt();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.trace.println(TRACE + msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace.println(TRACE + String.format(format, arg));
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace.println(TRACE + String.format(format, arg1, arg2));
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.trace.println(TRACE + String.format(format, arguments));
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.trace.println(TRACE + msg);
            t.printStackTrace(this.trace);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return this.level.toInt() <= Level.DEBUG.toInt();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.debug.println(DEBUG + msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug.println(DEBUG + String.format(format, arg));
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug.println(DEBUG + String.format(format, arg1, arg2));
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.debug.println(DEBUG + String.format(format, arguments));
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.debug.println(DEBUG + msg);
            t.printStackTrace(this.debug);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... argArray) {
        this.debug(format, argArray);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return this.level.toInt() <= Level.INFO.toInt();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.info.println(INFO + msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.info.println(INFO + String.format(format, arg));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info.println(INFO + String.format(format, arg1, arg2));
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.info.println(INFO + String.format(format, arguments));
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.info.println(INFO + msg);
            t.printStackTrace(this.info);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... argArray) {
        this.info(format, argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return this.level.toInt() <= Level.WARN.toInt();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.warn.println(WARN + msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn.println(WARN + String.format(format, arg));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn.println(WARN + String.format(format, arg1, arg2));
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.warn.println(WARN + String.format(format, arguments));
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.warn.println(WARN + msg);
            t.printStackTrace(this.warn);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... argArray) {
        this.warn(format, argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.level.toInt() <= Level.ERROR.toInt();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.error.println(ERROR + msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.error.println(ERROR + String.format(format, arg));
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error.println(ERROR + String.format(format, arg1, arg2));
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.error.println(ERROR + String.format(format, arguments));
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.error.println(ERROR + msg);
            t.printStackTrace(this.error);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... argArray) {
        this.error(format, argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }
}

