/*
 * Decompiled with CFR 0.152.
 */
package org.libj.math;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class BigDecimals {
    private static final ConcurrentHashMap<String, BigDecimal> instances = new ConcurrentHashMap();
    public static final BigDecimal TWO = BigDecimals.init("2", BigDecimal.valueOf(2L));
    public static final BigDecimal E = BigDecimals.init(String.valueOf(Math.E), BigDecimal.valueOf(Math.E));
    public static final BigDecimal PI = BigDecimals.init(String.valueOf(Math.PI), BigDecimal.valueOf(Math.PI));
    public static final BigDecimal LOG_2 = BigDecimals.init(String.valueOf(0.6931471805599453), BigDecimal.valueOf(0.6931471805599453));
    public static final BigDecimal LOG_10 = BigDecimals.init(String.valueOf(2.302585092994046), BigDecimal.valueOf(2.302585092994046));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal of(String val) {
        BigDecimal instance = instances.get(Objects.requireNonNull(val));
        if (instance != null) {
            return instance;
        }
        String string = val.intern();
        synchronized (string) {
            instance = instances.get(val);
            if (instance != null) {
                return instance;
            }
            instance = new BigDecimal(val);
            BigDecimals.init(val, instance);
        }
        return instance;
    }

    private static BigDecimal init(String str, BigDecimal val) {
        instances.put(str, val);
        return val;
    }

    private BigDecimals() {
    }
}

