/*
 * Decompiled with CFR 0.152.
 */
package org.libj.math;

public class MovingNormal {
    private double mean = 0.0;
    private double sum = 0.0;
    private double sumSq = 0.0;
    private double scale = 1.0;
    private double count = 0.0;

    public void normalize(int fromIndex, int toIndex, double ... values) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > values.length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        int i = fromIndex;
        while (i < toIndex) {
            this.sum += values[i];
            this.sumSq += values[i] * values[i];
            ++i;
            this.count += 1.0;
        }
        this.mean = this.sum / this.count;
        this.scale = StrictMath.sqrt((this.sumSq - this.sum * this.mean) / this.count);
        if (this.scale == 0.0) {
            this.scale = 1.0;
        }
        for (i = fromIndex; i < toIndex; ++i) {
            values[i] = (values[i] - this.mean) / this.scale;
        }
    }

    public double getMean() {
        return this.mean;
    }

    public double getScale() {
        return this.scale;
    }
}

