/*
 * Decompiled with CFR 0.152.
 */
package org.libj.math;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.libj.math.BigDecimals;

public final class SafeMath {
    public static byte abs(byte a) {
        return a;
    }

    public static short abs(short a) {
        return a;
    }

    public static int abs(int a) {
        return a;
    }

    public static long abs(long a) {
        return a;
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static BigInteger abs(BigInteger a) {
        return a;
    }

    public static BigDecimal abs(BigDecimal a) {
        return a.abs();
    }

    public static double acos(double a) {
        return StrictMath.acos(a);
    }

    public static BigDecimal acos(BigDecimal a, MathContext mc) {
        return BigDecimalMath.acos((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal acos(BigInteger a, MathContext mc) {
        return BigDecimalMath.acos((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static double asin(double a) {
        return StrictMath.asin(a);
    }

    public static BigDecimal asin(BigDecimal a, MathContext mc) {
        return BigDecimalMath.asin((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal asin(BigInteger a, MathContext mc) {
        return BigDecimalMath.asin((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static double atan(double a) {
        return StrictMath.atan(a);
    }

    public static BigDecimal atan(BigDecimal a, MathContext mc) {
        return BigDecimalMath.atan((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal atan(BigInteger a, MathContext mc) {
        return BigDecimalMath.atan((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static double atan2(double y, double x) {
        return StrictMath.atan2(y, x);
    }

    public static BigDecimal atan2(BigDecimal y, BigDecimal x, MathContext mc) {
        if (y.signum() == 1) {
            return BigDecimals.TWO.multiply(BigDecimalMath.atan((BigDecimal)x.divide(BigDecimalMath.sqrt((BigDecimal)y.multiply(y).add(x.multiply(x)), (MathContext)mc).add(y), mc), (MathContext)mc));
        }
        if (y.signum() <= 0 && x.signum() != 0) {
            return BigDecimals.TWO.multiply(BigDecimalMath.atan((BigDecimal)BigDecimalMath.sqrt((BigDecimal)y.multiply(y).add(x.multiply(x)), (MathContext)mc).subtract(y).divide(x, mc), (MathContext)mc));
        }
        if (y.signum() == -1 && x.signum() == 0) {
            return BigDecimals.PI;
        }
        return null;
    }

    public static byte ceil(byte a) {
        return a;
    }

    public static short ceil(short a) {
        return a;
    }

    public static int ceil(int a) {
        return a;
    }

    public static long ceil(long a) {
        return a;
    }

    public static float ceil(float a) {
        return (float)StrictMath.ceil(a);
    }

    public static double ceil(double a) {
        return StrictMath.ceil(a);
    }

    public static BigInteger ceil(BigInteger a) {
        return a;
    }

    public static BigDecimal ceil(BigDecimal a) {
        return a.setScale(0, RoundingMode.CEILING);
    }

    public static double cos(double a) {
        return StrictMath.cos(a);
    }

    public static BigDecimal cos(BigDecimal a, MathContext mc) {
        return BigDecimalMath.cos((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal cos(BigInteger a, MathContext mc) {
        return BigDecimalMath.cos((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static double exp(double a) {
        return StrictMath.exp(a);
    }

    public static BigDecimal exp(BigDecimal a, MathContext mc) {
        return BigDecimalMath.exp((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal exp(BigInteger a, MathContext mc) {
        return BigDecimalMath.exp((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static byte floor(byte a) {
        return a;
    }

    public static short floor(short a) {
        return a;
    }

    public static int floor(int a) {
        return a;
    }

    public static long floor(long a) {
        return a;
    }

    public static float floor(float a) {
        return (float)StrictMath.floor(a);
    }

    public static double floor(double a) {
        return StrictMath.floor(a);
    }

    public static BigDecimal floor(BigDecimal a) {
        return a.setScale(0, RoundingMode.FLOOR);
    }

    public static BigInteger floor(BigInteger a) {
        return a;
    }

    public static double pow(double a, double b) {
        return StrictMath.pow(a, b);
    }

    public static BigDecimal pow(BigDecimal a, BigDecimal b, MathContext mc) {
        return BigDecimalMath.pow((BigDecimal)a, (BigDecimal)b, (MathContext)mc);
    }

    public static BigDecimal pow(BigInteger a, BigDecimal b, MathContext mc) {
        return BigDecimalMath.pow((BigDecimal)new BigDecimal(a), (BigDecimal)b, (MathContext)mc);
    }

    public static BigDecimal pow(BigDecimal a, BigInteger b, MathContext mc) {
        return BigDecimalMath.pow((BigDecimal)a, (BigDecimal)new BigDecimal(b), (MathContext)mc);
    }

    public static BigInteger pow(BigInteger a, BigInteger b, MathContext mc) {
        return BigDecimalMath.pow((BigDecimal)new BigDecimal(a), (BigDecimal)new BigDecimal(b), (MathContext)mc).toBigInteger();
    }

    public static float round(float a, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0: " + scale);
        }
        if (scale == 0) {
            return Math.round(a);
        }
        float pow = (float)StrictMath.pow(10.0, scale);
        return (float)Math.round(a * pow) / pow;
    }

    public static double round(double a, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0: " + scale);
        }
        if (scale == 0) {
            return Math.round(a);
        }
        double pow = StrictMath.pow(10.0, scale);
        return (double)Math.round(a * pow) / pow;
    }

    public static byte round(byte a, int scale) {
        return a;
    }

    public static short round(short a, int scale) {
        return a;
    }

    public static int round(int a, int scale) {
        return a;
    }

    public static long round(long a, int scale) {
        return a;
    }

    public static BigDecimal round(BigDecimal a, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0: " + scale);
        }
        return a.setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigInteger round(BigInteger a, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0: " + scale);
        }
        return a;
    }

    public static byte signum(byte a) {
        return a < 0 ? (byte)-1 : (a == 0 ? (byte)0 : 1);
    }

    public static short signum(short a) {
        return a < 0 ? (short)-1 : (a == 0 ? (short)0 : 1);
    }

    public static int signum(int a) {
        return Integer.compare(a, 0);
    }

    public static long signum(long a) {
        return a < 0L ? -1L : (a == 0L ? 0L : 1L);
    }

    public static float signum(float a) {
        return a < 0.0f ? -1.0f : (a == 0.0f ? 0.0f : 1.0f);
    }

    public static double signum(double a) {
        return a < 0.0 ? -1.0 : (a == 0.0 ? 0.0 : 1.0);
    }

    public static int signum(BigInteger a) {
        return a.signum();
    }

    public static int signum(BigDecimal a) {
        return a.signum();
    }

    public static double sin(double a) {
        return StrictMath.sin(a);
    }

    public static BigDecimal sin(BigDecimal a, MathContext mc) {
        return BigDecimalMath.sin((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal sin(BigInteger a, MathContext mc) {
        return BigDecimalMath.sin((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static double sqrt(double a) {
        return StrictMath.sqrt(a);
    }

    public static BigDecimal sqrt(BigDecimal a, MathContext mc) {
        return BigDecimalMath.sqrt((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal sqrt(BigInteger a, MathContext mc) {
        return SafeMath.sqrt(new BigDecimal(a), mc);
    }

    public static double tan(double a) {
        return StrictMath.tan(a);
    }

    public static BigDecimal tan(BigDecimal a, MathContext mc) {
        return BigDecimalMath.tan((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal tan(BigInteger a, MathContext mc) {
        return BigDecimalMath.tan((BigDecimal)new BigDecimal(a), (MathContext)mc);
    }

    public static double log(double a) {
        return StrictMath.log(a);
    }

    public static double log(int b, int a) {
        return b < 0 || a < 0 || b == 0 && a == 0 || b == 1 && a == 1 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(long b, int a) {
        return b < 0L || a < 0 || b == 0L && a == 0 || b == 1L && a == 1 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(float b, int a) {
        return b < 0.0f || a < 0 || b == 0.0f && a == 0 || b == 1.0f && a == 1 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(double b, int a) {
        return b < 0.0 || a < 0 || b == 0.0 && a == 0 || b == 1.0 && a == 1 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(int b, long a) {
        return b < 0 || a < 0L || b == 0 && a == 0L || b == 1 && a == 1L ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(long b, long a) {
        return b < 0L || a < 0L || b == 0L && a == 0L || b == 1L && a == 1L ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(float b, long a) {
        return b < 0.0f || a < 0L || b == 0.0f && a == 0L || b == 1.0f && a == 1L ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(double b, long a) {
        return b < 0.0 || a < 0L || b == 0.0 && a == 0L || b == 1.0 && a == 1L ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(int b, float a) {
        return b < 0 || a < 0.0f || b == 0 && a == 0.0f || b == 1 && a == 1.0f ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(long b, float a) {
        return b < 0L || a < 0.0f || b == 0L && a == 0.0f || b == 1L && a == 1.0f ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(float b, float a) {
        return b < 0.0f || a < 0.0f || b == 0.0f && a == 0.0f || b == 1.0f && a == 1.0f ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(double b, float a) {
        return b < 0.0 || a < 0.0f || b == 0.0 && a == 0.0f || b == 1.0 && a == 1.0f ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(int b, double a) {
        return b < 0 || a < 0.0 || b == 0 && a == 0.0 || b == 1 && a == 1.0 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(long b, double a) {
        return b < 0L || a < 0.0 || b == 0L && a == 0.0 || b == 1L && a == 1.0 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(float b, double a) {
        return b < 0.0f || a < 0.0 || b == 0.0f && a == 0.0 || b == 1.0f && a == 1.0 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static double log(double b, double a) {
        return b < 0.0 || a < 0.0 || b == 0.0 && a == 0.0 || b == 1.0 && a == 1.0 ? Double.NaN : StrictMath.log(a) / StrictMath.log(b);
    }

    public static BigDecimal log(BigDecimal a, MathContext mc) {
        return BigDecimalMath.log((BigDecimal)a, (MathContext)mc);
    }

    public static BigDecimal log(BigDecimal b, BigDecimal a, MathContext mc) {
        return BigDecimalMath.log((BigDecimal)a, (MathContext)mc).divide(BigDecimalMath.log((BigDecimal)b, (MathContext)mc), mc);
    }

    private SafeMath() {
    }
}

