/*
 * Decompiled with CFR 0.152.
 */
package org.libj.math;

import java.math.BigInteger;

public final class StatMath {
    public static double rms(short ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double rms = 0.0;
        for (int i = 0; i < values.length; ++i) {
            rms += (double)(values[i] * values[i]);
        }
        return Math.sqrt(rms / (double)values.length);
    }

    public static double rms(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double rms = 0.0;
        for (int i = 0; i < values.length; ++i) {
            rms += (double)(values[i] * values[i]);
        }
        return Math.sqrt(rms / (double)values.length);
    }

    public static double rms(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double rms = 0.0;
        for (int i = 0; i < values.length; ++i) {
            rms += (double)(values[i] * values[i]);
        }
        return Math.sqrt(rms / (double)values.length);
    }

    public static double rms(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double rms = 0.0;
        for (int i = 0; i < values.length; ++i) {
            rms += (double)(values[i] * values[i]);
        }
        return Math.sqrt(rms / (double)values.length);
    }

    public static double rms(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double rms = 0.0;
        for (int i = 0; i < values.length; ++i) {
            rms += values[i] * values[i];
        }
        return Math.sqrt(rms / (double)values.length);
    }

    public static short min(short ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        short min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static int min(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        int min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static long min(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        long min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static float min(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        float min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    public static double min(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    public static short max(short ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        short max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static int max(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static long max(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static float max(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        float max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public static double max(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values.length == 0");
        }
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    public static short threshold(short value, short min, short max) {
        return value < min ? min : (max < value ? max : value);
    }

    public static int threshold(int value, int min, int max) {
        return value < min ? min : Math.min(max, value);
    }

    public static long threshold(long value, long min, long max) {
        return value < min ? min : Math.min(max, value);
    }

    public static float threshold(float value, float min, float max) {
        return value < min ? min : Math.min(max, value);
    }

    public static double threshold(double value, double min, double max) {
        return value < min ? min : Math.min(max, value);
    }

    public static double avg(short ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values) / (double)values.length;
    }

    public static double avg(int ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values) / (double)values.length;
    }

    public static double avg(long ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values) / (double)values.length;
    }

    public static double avg(float ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values) / (double)values.length;
    }

    public static double avg(double ... values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return StatMath.sum(values) / (double)values.length;
    }

    public static double avg(short[] values, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (values.length == 0 || fromIndex == toIndex) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    public static double avg(int[] values, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (values.length == 0 || fromIndex == toIndex) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    public static double avg(long[] values, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (values.length == 0 || fromIndex == toIndex) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    public static double avg(float[] values, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (values.length == 0 || fromIndex == toIndex) {
            return Double.NaN;
        }
        return (double)StatMath.sum(values, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    public static double avg(double[] values, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (values.length == 0 || fromIndex == toIndex) {
            return Double.NaN;
        }
        return StatMath.sum(values, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    public static int sum(short ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static long sum(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += (long)values[i];
        }
        return sum;
    }

    public static long sum(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static float sum(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        float sum = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double sum(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static int sum(short[] values, int fromIndex, int toIndex) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex <= fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") >= toIndex(" + toIndex + ")");
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static int sum(int[] values, int fromIndex, int toIndex) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex <= fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") >= toIndex(" + toIndex + ")");
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static long sum(long[] values, int fromIndex, int toIndex) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex <= fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") >= toIndex(" + toIndex + ")");
        }
        long sum = 0L;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static float sum(float[] values, int fromIndex, int toIndex) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex <= fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") >= toIndex(" + toIndex + ")");
        }
        float sum = 0.0f;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public static double sum(double[] values, int fromIndex, int toIndex) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (values.length < toIndex) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (toIndex <= fromIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") >= toIndex(" + toIndex + ")");
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum = (int)((double)sum + values[i]);
        }
        return sum;
    }

    public static int sum(short[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i][dimension];
        }
        return sum;
    }

    public static int sum(int[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i][dimension];
        }
        return sum;
    }

    public static long sum(long[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i][dimension];
        }
        return sum;
    }

    public static float sum(float[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        float sum = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i][dimension];
        }
        return sum;
    }

    public static double sum(double[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i][dimension];
        }
        return sum;
    }

    public static double stdDev(short[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values) / values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i] - u) * ((double)values[i] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(int[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values) / (long)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i] - u) * ((double)values[i] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(long[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values) / (long)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i] - u) * ((double)values[i] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(float[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values) / (float)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i] - u) * ((double)values[i] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values) / (double)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += (values[i] - u) * (values[i] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(short[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values, dimension) / values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i][dimension] - u) * ((double)values[i][dimension] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(int[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values, dimension) / values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i][dimension] - u) * ((double)values[i][dimension] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(long[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values, dimension) / (long)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i][dimension] - u) * ((double)values[i][dimension] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(float[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values, dimension) / (float)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += ((double)values[i][dimension] - u) * ((double)values[i][dimension] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static double stdDev(double[][] values, int dimension) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value.length == 0");
        }
        double u = StatMath.sum(values, dimension) / (double)values.length;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += (values[i][dimension] - u) * (values[i][dimension] - u);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    public static void normalize(short[] values) {
        if (values.length <= 1) {
            return;
        }
        double sumLinear = 0.0;
        double sumSquares = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sumLinear += (double)values[i];
            sumSquares += (double)(values[i] * values[i]);
        }
        double length = values.length;
        double mean = sumLinear / length;
        double scale = Math.sqrt((sumSquares - sumLinear * mean) / length);
        if (scale == 0.0) {
            scale = 1.0;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = (short)(((double)values[i] - mean) / scale);
        }
    }

    public static void normalize(int[] values) {
        if (values.length <= 1) {
            return;
        }
        double sumLinear = 0.0;
        double sumSquares = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sumLinear += (double)values[i];
            sumSquares += (double)(values[i] * values[i]);
        }
        double length = values.length;
        double mean = sumLinear / length;
        double scale = Math.sqrt((sumSquares - sumLinear * mean) / length);
        if (scale == 0.0) {
            scale = 1.0;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = (int)(((double)values[i] - mean) / scale);
        }
    }

    public static void normalize(long[] values) {
        if (values.length <= 1) {
            return;
        }
        double sumLinear = 0.0;
        double sumSquares = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sumLinear += (double)values[i];
            sumSquares += (double)(values[i] * values[i]);
        }
        double length = values.length;
        double mean = sumLinear / length;
        double scale = Math.sqrt((sumSquares - sumLinear * mean) / length);
        if (scale == 0.0) {
            scale = 1.0;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = (long)(((double)values[i] - mean) / scale);
        }
    }

    public static void normalize(float[] values) {
        if (values.length <= 1) {
            return;
        }
        double sumLinear = 0.0;
        double sumSquares = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sumLinear += (double)values[i];
            sumSquares += (double)(values[i] * values[i]);
        }
        double length = values.length;
        double mean = sumLinear / length;
        double scale = Math.sqrt((sumSquares - sumLinear * mean) / length);
        if (scale == 0.0) {
            scale = 1.0;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = (float)(((double)values[i] - mean) / scale);
        }
    }

    public static void normalize(double[] values) {
        if (values.length <= 1) {
            return;
        }
        double sumLinear = 0.0;
        double sumSquares = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sumLinear += values[i];
            sumSquares += values[i] * values[i];
        }
        double length = values.length;
        double mean = sumLinear / length;
        double scale = Math.sqrt((sumSquares - sumLinear * mean) / length);
        if (scale == 0.0) {
            scale = 1.0;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = (values[i] - mean) / scale;
        }
    }

    public static BigInteger binomial(int n, int k) {
        BigInteger binomial = BigInteger.ONE;
        for (int i = 0; i < k; ++i) {
            binomial = binomial.multiply(BigInteger.valueOf(n - i)).divide(BigInteger.valueOf(i + 1));
        }
        return binomial;
    }

    private StatMath() {
    }
}

