/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.libj.net.URLConnections;
import org.libj.util.ArrayUtil;
import org.libj.util.function.ThrowingConsumer;

public final class Downloads {
    public static HttpURLConnection downloadFile(String fromUrl, File toFile, CopyOption ... options) throws IOException {
        return Downloads.downloadFile(new URL(fromUrl), toFile, options);
    }

    public static HttpURLConnection downloadFile(String fromUrl, File toFile, int connectTimeout, int readTimeout, CopyOption ... options) throws IOException {
        return Downloads.downloadFile(new URL(fromUrl), toFile, connectTimeout, readTimeout, options);
    }

    public static HttpURLConnection downloadFile(URL fromUrl, File toFile, CopyOption ... options) throws IOException {
        return Downloads.downloadFile(fromUrl, toFile, 0, 0, options);
    }

    public static HttpURLConnection downloadFile(URL fromUrl, File toFile, int connectTimeout, int readTimeout, CopyOption ... options) throws IOException {
        return Downloads.downloadFile(fromUrl, toFile, connectTimeout, readTimeout, true, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpURLConnection downloadFile(URL fromUrl, File toFile, int connectTimeout, int readTimeout, boolean followRedirects, CopyOption ... options) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)(followRedirects ? URLConnections.checkFollowRedirect(fromUrl.openConnection(), (ThrowingConsumer<HttpURLConnection, IOException>)((ThrowingConsumer)c -> Downloads.beforeDownloadFile(c, connectTimeout, readTimeout, toFile))) : fromUrl.openConnection());
        try {
            if (connection.getResponseCode() == 200) {
                try (InputStream in = connection.getInputStream();){
                    int index = ArrayUtil.indexOf((Object[])options, (Object)StandardCopyOption.COPY_ATTRIBUTES);
                    if (index > -1) {
                        options = (CopyOption[])ArrayUtil.splice((Object[])options, (int)index, (int)1);
                    }
                    Files.copy(in, toFile.toPath(), options);
                    if (index > -1) {
                        toFile.setLastModified(connection.getLastModified());
                    }
                }
            }
            HttpURLConnection httpURLConnection = connection;
            return httpURLConnection;
        }
        finally {
            connection.disconnect();
        }
    }

    private static void beforeDownloadFile(HttpURLConnection connection, int connectTimeout, int readTimeout, File toFile) {
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        if (toFile.exists()) {
            connection.setIfModifiedSince(toFile.lastModified());
        }
    }

    public static void downloadFile(HttpServletResponse response, byte[] bytes, String fileName, boolean attachment) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            Downloads.downloadFile(response, in, fileName, attachment);
        }
    }

    public static void downloadFile(HttpServletResponse response, File toFile, boolean attachment) throws IOException {
        try (FileInputStream in = new FileInputStream(toFile);){
            Downloads.downloadFile(response, in, toFile.getName(), attachment);
        }
    }

    public static void downloadFile(HttpServletResponse response, InputStream in, String fileName, boolean attachment) throws IOException {
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        int contentLength = in.available();
        response.reset();
        response.setContentLength(contentLength);
        response.setContentType(contentType);
        response.setHeader("Content-disposition", (attachment ? "attachment" : "inline") + "; filename=\"" + fileName + "\"");
        try (ServletOutputStream out = response.getOutputStream();){
            while (contentLength-- > 0) {
                out.write(in.read());
            }
            out.flush();
        }
    }

    private Downloads() {
    }
}

