/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.libj.lang.Strings;
import org.libj.util.StringPaths;

public final class URIs {
    private static final URI empty = URI.create("");

    public static URI fromURL(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static URI relativize(URI from, URI to) {
        int i;
        if (!URIs.compare(from.getScheme(), to.getScheme())) {
            return to;
        }
        if (!URIs.compare(from.getHost(), to.getHost())) {
            return to;
        }
        if (from.getPort() != to.getPort()) {
            return to;
        }
        if (from.getPath() == null && to.getPath() == null) {
            return empty;
        }
        if (from.getPath() == null) {
            return URI.create(to.getPath());
        }
        if (to.getPath() == null) {
            return to;
        }
        String fromPath = from.getPath();
        if (fromPath.startsWith("/")) {
            fromPath = fromPath.substring(1);
        }
        String[] fsplit = Strings.split((CharSequence)fromPath, (char)'/');
        String toPath = to.getPath();
        if (toPath.startsWith("/")) {
            toPath = toPath.substring(1);
        }
        String[] tsplit = Strings.split((CharSequence)toPath, (char)'/');
        for (int f = 0; f < fsplit.length && f < tsplit.length && fsplit[f].equals(tsplit[f]); ++f) {
        }
        StringBuilder builder = new StringBuilder();
        int i$ = fsplit.length;
        for (i = f; i < i$; ++i) {
            builder.append("../");
        }
        i$ = tsplit.length;
        for (i = f; i < i$; ++i) {
            builder.append(tsplit[i]).append('/');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return URI.create(builder.toString());
    }

    public static URI relativePath(URI from, URI to) {
        if (!from.isAbsolute() || !to.isAbsolute()) {
            return to;
        }
        if (from.isOpaque() || to.isOpaque()) {
            return to;
        }
        URI root = from.resolve("/");
        if (!root.equals(to.resolve("/"))) {
            return to;
        }
        URI baseRel = URI.create("/").resolve(root.relativize(from));
        URI uriRel = URI.create("/").resolve(root.relativize(to));
        if (baseRel.getPath().equals(uriRel.getPath())) {
            return baseRel.relativize(uriRel);
        }
        URI commonBase = baseRel.resolve("./");
        if (commonBase.equals(uriRel.resolve("./"))) {
            return commonBase.relativize(uriRel);
        }
        URI relative = URI.create("");
        while (!uriRel.getPath().startsWith(commonBase.getPath()) && !"/".equals(commonBase.getPath())) {
            commonBase = commonBase.resolve("../");
            relative = relative.resolve("../");
        }
        URI relToCommon = commonBase.relativize(uriRel);
        return relative.resolve(relToCommon);
    }

    public static boolean isLocalFile(URI uri) {
        String host = uri.getHost();
        return "file".equalsIgnoreCase(uri.getScheme()) && (host == null || host.length() == 0 || "localhost".equals(host));
    }

    /*
     * Exception decompiling
     */
    public static boolean isLocalJarFile(URI uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isLocal(URI uri) {
        return URIs.isLocalFile(uri) || URIs.isLocalJarFile(uri);
    }

    public static String getName(URI uri) {
        return StringPaths.getName((String)uri.toString());
    }

    public static String getSimpleName(URI uri) {
        return StringPaths.getSimpleName((String)uri.toString());
    }

    public static URI getParent(URI uri) {
        String parentPath = StringPaths.getParent((String)uri.toString());
        return parentPath == null ? null : URI.create(parentPath);
    }

    public static URI getCanonicalParent(URI uri) {
        return uri == null ? null : URI.create(StringPaths.getCanonicalParent((String)uri.toString()));
    }

    public static URI toURI(URI baseURI, String path) {
        String p = baseURI.getPath();
        int slash = p.lastIndexOf(47);
        if (slash != -1) {
            path = p.substring(0, slash + 1) + path;
        }
        try {
            return new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), path, baseURI.getQuery(), baseURI.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static void add(Map<String, List<String>> parameters, String name, String value) {
        List<String> values;
        if (name == null) {
            name = value;
            value = null;
        }
        if ((values = parameters.get(name)) == null) {
            values = new ArrayList<String>(2);
            parameters.put(name, values);
        }
        values.add(value);
    }

    public static void parseParameters(Map<String, List<String>> parameters, String data) {
        StringBuilder b = new StringBuilder();
        String name = null;
        int i$ = data.length();
        for (int i = 0; i < i$; ++i) {
            char ch = data.charAt(i);
            if (ch == '&') {
                URIs.add(parameters, name, b.toString());
                b.setLength(0);
                name = null;
                continue;
            }
            if (ch == '=') {
                name = b.toString();
                b.setLength(0);
                continue;
            }
            b.append(ch);
        }
        URIs.add(parameters, name, b.toString());
    }

    private URIs() {
    }
}

