/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class URLStreamHandlers
implements URLStreamHandlerFactory {
    private final ThreadLocal<Object> lock = new ThreadLocal();

    private static boolean canLookupViaProperty(String className) {
        try {
            ClassLoader.getSystemClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void loadSPI() {
        Iterator<URLStreamHandlerFactory> iterator = ServiceLoader.load(URLStreamHandlerFactory.class).iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public static void register(Class<? extends URLStreamHandler> handlerClass, Class<? extends URLStreamHandlerFactory> factoryClass) {
        String className = handlerClass.getName();
        String pkg = handlerClass.getPackage().getName();
        pkg = pkg.substring(0, pkg.lastIndexOf(46));
        String property = "java.protocol.handler.pkgs";
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null || !pkgs.contains(pkg)) {
            System.setProperty("java.protocol.handler.pkgs", pkgs != null && pkgs.length() > 0 ? pkgs + "|" + pkg : pkg);
        }
        if (!URLStreamHandlers.canLookupViaProperty(className)) {
            try {
                URL.setURLStreamHandlerFactory(new URLStreamHandlers());
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    private URLStreamHandlers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.lock.get() != null) {
            return null;
        }
        this.lock.set(Boolean.TRUE);
        try {
            Iterator<URLStreamHandlerFactory> iterator = ServiceLoader.load(URLStreamHandlerFactory.class).iterator();
            while (iterator.hasNext()) {
                URLStreamHandler handler = iterator.next().createURLStreamHandler(protocol);
                if (handler == null) continue;
                URLStreamHandler uRLStreamHandler = handler;
                return uRLStreamHandler;
            }
            URLStreamHandler uRLStreamHandler = null;
            return uRLStreamHandler;
        }
        finally {
            this.lock.set(null);
        }
    }
}

