/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.libj.lang.Hexadecimal;
import org.libj.sql.AuditStatement;
import org.libj.sql.AuditUtil;
import org.libj.sql.DateTimes;
import org.libj.sql.DelegatePreparedStatement;
import org.libj.sql.ResultSets;
import org.libj.util.DecimalFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditPreparedStatement
extends AuditStatement
implements DelegatePreparedStatement {
    static final Logger logger = LoggerFactory.getLogger(AuditPreparedStatement.class);
    protected static final String NULL = "NULL";
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter timeFormat = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 6, true).toFormatter();
    private static final DateTimeFormatter timestampFormat = new DateTimeFormatterBuilder().append(dateFormat).appendLiteral(' ').append(timeFormat).toFormatter();
    private static final ThreadLocal<DecimalFormat> numberFormat = DecimalFormatter.createDecimalFormat((String)"###############.###############;-###############.###############");
    private final String sql;
    private ArrayList<Map<Object, Object>> parameterMaps;

    private static String toString(Object value) {
        Closeable in;
        if (value == NULL) {
            return NULL;
        }
        if (value instanceof byte[]) {
            return "X'" + new Hexadecimal((byte[])value) + "'";
        }
        if (value instanceof InputStream) {
            in = (InputStream)value;
            try {
                int by = ((InputStream)in).read();
                if (by == -1) {
                    try {
                        ((InputStream)in).reset();
                    }
                    catch (IOException ignore) {
                        return value.toString();
                    }
                }
                if (((InputStream)in).markSupported()) {
                    ((InputStream)in).mark(Integer.MAX_VALUE);
                }
                if ((by = ((InputStream)in).read()) != -1) {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    out.write(by);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) != -1) {
                        out.write(buf, 0, len);
                    }
                    if (((InputStream)in).markSupported()) {
                        ((InputStream)in).reset();
                    }
                    return "X'" + new Hexadecimal(out.toByteArray()) + "'";
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (value instanceof Reader) {
            in = (Reader)value;
            try {
                int ch = ((Reader)in).read();
                if (ch == -1) {
                    try {
                        ((Reader)in).reset();
                    }
                    catch (IOException ignore) {
                        return value.toString();
                    }
                }
                if (((Reader)in).markSupported()) {
                    ((Reader)in).mark(Integer.MAX_VALUE);
                }
                if ((ch = ((Reader)in).read()) != -1) {
                    int len;
                    StringBuilder builder = new StringBuilder();
                    builder.append('\'').append(ch);
                    char[] buf = new char[1024];
                    while ((len = ((Reader)in).read(buf)) != -1) {
                        builder.append(buf, 0, len);
                    }
                    if (((Reader)in).markSupported()) {
                        ((Reader)in).reset();
                    }
                    builder.append('\'');
                    return builder.toString();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (value instanceof Date) {
            return "'" + ((Date)value).toLocalDate().format(dateFormat) + "'";
        }
        if (value instanceof Time) {
            return "'" + DateTimes.toLocalTime((Time)value).format(timeFormat) + "'";
        }
        if (value instanceof Timestamp) {
            return "'" + ((Timestamp)value).toLocalDateTime().format(timestampFormat) + "'";
        }
        if (value instanceof String || value instanceof URL) {
            return "'" + value + "'";
        }
        if (value instanceof Number) {
            return numberFormat.get().format(value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "TRUE" : "FALSE";
        }
        if (value == null) {
            return "?";
        }
        if ("oracle.sql.INTERVALDS".equals(value.getClass().getName())) {
            String str = value.toString();
            return "'" + str.substring(str.indexOf(32) + 1) + "'";
        }
        return value.toString();
    }

    private static int writeParameter(StringBuilder builder, int start, int end, Object obj) {
        int len = builder.length();
        builder.replace(start, end, AuditPreparedStatement.toString(obj));
        return builder.length() - len;
    }

    private static String toString(String sql, Map<Object, Object> parameterMap) {
        int index = 0;
        boolean escaped = false;
        char inQuote = '\u0000';
        int colon = -1;
        boolean namedQuoted = false;
        StringBuilder builder = new StringBuilder(sql);
        for (int i = 0; i < builder.length(); ++i) {
            char ch = builder.charAt(i);
            if (colon != -1) {
                if (colon == i - 1 && ch == '\"') {
                    namedQuoted = true;
                    continue;
                }
                if ((ch != '\"' || !namedQuoted) && (ch == '#' || ch == '$' || ch >= '0' && '9' >= ch || ch >= '@' && 'Z' >= ch || ch == '_' || ch >= 'a' && 'z' >= ch)) continue;
                i += AuditPreparedStatement.writeParameter(builder, colon, i, parameterMap.get(builder.substring(colon + 1, i)));
                colon = -1;
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (inQuote == '\u0000' || !escaped) {
                if (ch == '\'' || ch == '\"') {
                    inQuote = inQuote == ch ? (char)'\u0000' : ch;
                } else if (inQuote == '\u0000') {
                    if (ch == ':') {
                        colon = i;
                    } else if (ch == '?') {
                        i += AuditPreparedStatement.writeParameter(builder, i, i + 1, parameterMap.get(++index));
                    }
                }
            }
            escaped = false;
        }
        return builder.toString();
    }

    public static PreparedStatement wrapIfDebugEnabled(PreparedStatement target, String sql) {
        return logger.isDebugEnabled() ? new AuditPreparedStatement(target, sql) : target;
    }

    public AuditPreparedStatement(PreparedStatement target, String sql) {
        super(target);
        this.sql = sql;
    }

    @Override
    public PreparedStatement getTarget() {
        return (PreparedStatement)super.getTarget();
    }

    protected Map<Object, Object> getCurrentParameterMap() {
        if (this.parameterMaps == null) {
            this.parameterMaps = new ArrayList();
            this.parameterMaps.add(new HashMap());
        }
        return this.parameterMaps.get(this.parameterMaps.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        PreparedStatement statement = this.getTarget();
        int size = -1;
        long time = -1L;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeQuery", this.getConnection(), this.toString()).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            ResultSet resultSet = statement.executeQuery();
            if (debugEnabled) {
                size = ResultSets.getSize(resultSet);
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditPreparedStatement.withResult(AuditUtil.log(this, "executeQuery", this.getConnection(), this.toString()), size, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        long time = -1L;
        int count = -1;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeUpdate", this.getConnection(), this.toString()).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            int n = count = this.getTarget().executeUpdate();
            return n;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditPreparedStatement.withResult(AuditUtil.log(this, "executeUpdate", this.getConnection(), this.toString()), count, time).toString());
            }
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getTarget().setNull(parameterIndex, sqlType);
        this.getCurrentParameterMap().put(parameterIndex, NULL);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getTarget().setBoolean(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getTarget().setByte(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getTarget().setShort(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getTarget().setInt(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getTarget().setLong(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getTarget().setFloat(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getTarget().setDouble(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getTarget().setBigDecimal(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getTarget().setString(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getTarget().setBytes(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getTarget().setDate(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getTarget().setTime(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getTarget().setTimestamp(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getTarget().setAsciiStream(parameterIndex, x, length);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getTarget().setUnicodeStream(parameterIndex, x, length);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getTarget().setBinaryStream(parameterIndex, x, length);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.getTarget().clearParameters();
        this.getCurrentParameterMap().clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.getTarget().setObject(parameterIndex, x, targetSqlType, scale);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getTarget().setObject(parameterIndex, x, targetSqlType);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getTarget().setObject(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        long time = -1L;
        boolean result = false;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "execute", this.getConnection(), this.toString()).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            boolean bl = result = this.getTarget().execute();
            return bl;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditPreparedStatement.withResult(AuditUtil.log(this, "execute", this.getConnection(), this.toString()), result, time).toString());
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        if (logger.isDebugEnabled()) {
            this.addBatch0(AuditPreparedStatement.toString(this.sql, this.getCurrentParameterMap()));
        }
        this.parameterMaps.add(new HashMap());
        this.getTarget().addBatch();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getTarget().setRef(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getTarget().setBlob(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getTarget().setClob(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getTarget().setArray(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getTarget().setDate(parameterIndex, x, cal);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getTarget().setTime(parameterIndex, x, cal);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getTarget().setTimestamp(parameterIndex, x, cal);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getTarget().setNull(parameterIndex, sqlType, typeName);
        this.getCurrentParameterMap().put(parameterIndex, NULL);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getTarget().setURL(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.getTarget().setRowId(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.getTarget().setNString(parameterIndex, value);
        this.getCurrentParameterMap().put(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.getTarget().setNCharacterStream(parameterIndex, value, length);
        this.getCurrentParameterMap().put(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.getTarget().setNClob(parameterIndex, value);
        this.getCurrentParameterMap().put(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getTarget().setClob(parameterIndex, reader, length);
        this.getCurrentParameterMap().put(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getTarget().setBlob(parameterIndex, inputStream, length);
        this.getCurrentParameterMap().put(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getTarget().setNClob(parameterIndex, reader, length);
        this.getCurrentParameterMap().put(parameterIndex, reader);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.getTarget().setSQLXML(parameterIndex, xmlObject);
        this.getCurrentParameterMap().put(parameterIndex, xmlObject);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getTarget().setAsciiStream(parameterIndex, x, length);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getTarget().setBinaryStream(parameterIndex, x, length);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getTarget().setCharacterStream(parameterIndex, reader, length);
        this.getCurrentParameterMap().put(parameterIndex, reader);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.getTarget().setAsciiStream(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.getTarget().setBinaryStream(parameterIndex, x);
        this.getCurrentParameterMap().put(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.getTarget().setCharacterStream(parameterIndex, reader);
        this.getCurrentParameterMap().put(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.getTarget().setNCharacterStream(parameterIndex, value);
        this.getCurrentParameterMap().put(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.getTarget().setClob(parameterIndex, reader);
        this.getCurrentParameterMap().put(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.getTarget().setBlob(parameterIndex, inputStream);
        this.getCurrentParameterMap().put(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.getTarget().setNClob(parameterIndex, reader);
        this.getCurrentParameterMap().put(parameterIndex, reader);
    }

    @Override
    public void close() throws SQLException {
        if (this.parameterMaps != null) {
            this.parameterMaps.clear();
        }
        super.close();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getTarget().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getTarget().hashCode();
    }

    @Override
    public String toString() {
        if (!logger.isDebugEnabled() || this.parameterMaps == null) {
            return this.sql;
        }
        StringBuilder builder = new StringBuilder();
        int i$ = this.parameterMaps.size();
        for (int i = 0; i < i$; ++i) {
            if (i > 0) {
                builder.append('\n');
            }
            builder.append(AuditPreparedStatement.toString(this.sql, this.parameterMaps.get(i)));
        }
        return builder.toString();
    }
}

