/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResultSets {
    private static final Logger logger = LoggerFactory.getLogger(ResultSets.class);

    public static SQLException close(ResultSet resultSet) {
        try {
            if (!resultSet.isClosed()) {
                resultSet.close();
            }
            return null;
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(resultSet.getClass().getName() + ".close(): " + e.getMessage());
            }
            return e;
        }
    }

    public static Integer getSize(ResultSet resultSet) throws SQLException {
        if (resultSet.getType() <= 1003) {
            return -1;
        }
        resultSet.last();
        int size = resultSet.getRow();
        resultSet.beforeFirst();
        return size;
    }

    private ResultSets() {
    }
}

