/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.libj.lang.Strings;

public final class SQLFormat {
    private static final String[] reserveds = new String[]{"ALL", "AND", "BY", "DISTINCT", "FROM", "GROUP", "HAVING", "JOIN", "LEFT", "ON", "OR", "ORDER", "OUTER", "SELECT", "WHERE"};

    public static String format(String sql) {
        String ws = " \t\n\r\f";
        String delims = " \t\n\r\f(),";
        StringTokenizer tokenizer = new StringTokenizer(sql, " \t\n\r\f(),", true);
        int depth = 0;
        StringBuilder out = new StringBuilder();
        boolean lastReserved = true;
        boolean lastDelimNonWS = false;
        while (tokenizer.hasMoreTokens()) {
            boolean reserved;
            boolean delim;
            String token = tokenizer.nextToken();
            boolean bl = delim = token.length() == 1 && " \t\n\r\f(),".contains(token);
            if (delim) {
                if (")".equals(token)) {
                    out.append('\n').append(Strings.pad((String)"", (Strings.Align)Strings.Align.RIGHT, (int)(depth * 2))).append(token);
                } else if (!lastDelimNonWS) {
                    out.append(token);
                }
                if (",".equals(token)) {
                    out.append('\n').append(Strings.pad((String)"", (Strings.Align)Strings.Align.RIGHT, (int)(depth * 2)));
                }
                if (" \t\n\r\f".contains(token)) continue;
                lastDelimNonWS = delim;
                continue;
            }
            lastDelimNonWS = false;
            boolean bl2 = reserved = Arrays.binarySearch(reserveds, token) >= 0;
            if (reserved) {
                if (!lastReserved) {
                    --depth;
                    out.append('\n');
                }
            } else if (lastReserved) {
                out.append('\n').append(Strings.pad((String)"", (Strings.Align)Strings.Align.RIGHT, (int)(++depth * 2)));
            }
            lastReserved = reserved;
            out.append(token);
        }
        return out.toString();
    }

    private SQLFormat() {
    }
}

