/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql.exception;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import org.libj.lang.Throwables;
import org.libj.sql.exception.SQLAmbiguousCursorNameException;
import org.libj.sql.exception.SQLCardinalityException;
import org.libj.sql.exception.SQLDependentPrivilegeDescriptorsException;
import org.libj.sql.exception.SQLDiskFullException;
import org.libj.sql.exception.SQLDynamicErrorException;
import org.libj.sql.exception.SQLInsufficientResourcesException;
import org.libj.sql.exception.SQLInternalErrorException;
import org.libj.sql.exception.SQLInvalidCatalogNameException;
import org.libj.sql.exception.SQLInvalidCharacterSetNameException;
import org.libj.sql.exception.SQLInvalidConditionNumberException;
import org.libj.sql.exception.SQLInvalidConnectionNameException;
import org.libj.sql.exception.SQLInvalidCursorNameException;
import org.libj.sql.exception.SQLInvalidCursorStateException;
import org.libj.sql.exception.SQLInvalidDescriptorNameException;
import org.libj.sql.exception.SQLInvalidSchemaNameException;
import org.libj.sql.exception.SQLInvalidStatementNameException;
import org.libj.sql.exception.SQLInvalidTransactionStateException;
import org.libj.sql.exception.SQLInvalidTransactionTerminationException;
import org.libj.sql.exception.SQLNoDataException;
import org.libj.sql.exception.SQLOperatorInterventionException;
import org.libj.sql.exception.SQLOutOfMemoryException;
import org.libj.sql.exception.SQLPrerequisiteStateException;
import org.libj.sql.exception.SQLTooManyConnectionsException;
import org.libj.sql.exception.SQLValueException;
import org.libj.sql.exception.UnsupportedSQLException;

public final class SQLExceptions {
    static String getSqlState(SQLException e) {
        Throwable cause;
        String sqlState = e.getSQLState();
        return sqlState != null && sqlState.length() >= 2 || (cause = e.getCause()) == e || !(cause instanceof SQLException) ? sqlState : SQLExceptions.getSqlState((SQLException)cause);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLException toStrongType(SQLException exception) {
        void var1_34;
        String sqlState = SQLExceptions.getSqlState(exception);
        if (sqlState == null || sqlState.length() < 2) {
            if (exception.getMessage() == null || !exception.getMessage().contains("A PRIMARY KEY constraint failed")) return exception;
            SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException = new SQLIntegrityConstraintViolationException(exception.getMessage(), sqlState, exception.getErrorCode());
            return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
        } else {
            String _class = sqlState.substring(0, 2);
            if ("02".equals(_class)) {
                if (exception instanceof SQLNoDataException) {
                    return exception;
                }
                SQLNoDataException sQLNoDataException = new SQLNoDataException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("07".equals(_class)) {
                if (exception instanceof SQLDynamicErrorException) {
                    return exception;
                }
                SQLDynamicErrorException sQLDynamicErrorException = new SQLDynamicErrorException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("08".equals(_class) || "XJ".equals(_class) || "8001".equals(sqlState)) {
                if (exception instanceof SQLNonTransientConnectionException) {
                    return exception;
                }
                SQLNonTransientConnectionException sQLNonTransientConnectionException = new SQLNonTransientConnectionException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("0A".equals(_class) || "X0X67".equals(sqlState)) {
                if (exception instanceof SQLFeatureNotSupportedException) {
                    return exception;
                }
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = new SQLFeatureNotSupportedException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("21".equals(_class)) {
                if (exception instanceof SQLCardinalityException) {
                    return exception;
                }
                SQLCardinalityException sQLCardinalityException = new SQLCardinalityException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("22".equals(_class)) {
                if (exception instanceof SQLDataException) {
                    return exception;
                }
                SQLDataException sQLDataException = new SQLDataException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("23".equals(_class)) {
                if (exception instanceof SQLIntegrityConstraintViolationException) {
                    return exception;
                }
                SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException = new SQLIntegrityConstraintViolationException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("24".equals(_class)) {
                if (exception instanceof SQLInvalidCursorStateException) {
                    return exception;
                }
                SQLInvalidCursorStateException sQLInvalidCursorStateException = new SQLInvalidCursorStateException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("25".equals(_class)) {
                if (exception instanceof SQLInvalidTransactionStateException) {
                    return exception;
                }
                SQLInvalidTransactionStateException sQLInvalidTransactionStateException = new SQLInvalidTransactionStateException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("26".equals(_class)) {
                if (exception instanceof SQLInvalidStatementNameException) {
                    return exception;
                }
                SQLInvalidStatementNameException sQLInvalidStatementNameException = new SQLInvalidStatementNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("28".equals(_class)) {
                if (exception instanceof SQLInvalidAuthorizationSpecException) {
                    return exception;
                }
                SQLInvalidAuthorizationSpecException sQLInvalidAuthorizationSpecException = new SQLInvalidAuthorizationSpecException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("2B".equals(_class)) {
                if (exception instanceof SQLDependentPrivilegeDescriptorsException) {
                    return exception;
                }
                SQLDependentPrivilegeDescriptorsException sQLDependentPrivilegeDescriptorsException = new SQLDependentPrivilegeDescriptorsException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("2C".equals(_class)) {
                if (exception instanceof SQLInvalidCharacterSetNameException) {
                    return exception;
                }
                SQLInvalidCharacterSetNameException sQLInvalidCharacterSetNameException = new SQLInvalidCharacterSetNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("2D".equals(_class)) {
                if (exception instanceof SQLInvalidTransactionTerminationException) {
                    return exception;
                }
                SQLInvalidTransactionTerminationException sQLInvalidTransactionTerminationException = new SQLInvalidTransactionTerminationException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("2E".equals(_class)) {
                if (exception instanceof SQLInvalidConnectionNameException) {
                    return exception;
                }
                SQLInvalidConnectionNameException sQLInvalidConnectionNameException = new SQLInvalidConnectionNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("33".equals(_class)) {
                if (exception instanceof SQLInvalidDescriptorNameException) {
                    return exception;
                }
                SQLInvalidDescriptorNameException sQLInvalidDescriptorNameException = new SQLInvalidDescriptorNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("34".equals(_class)) {
                if (exception instanceof SQLInvalidCursorNameException) {
                    return exception;
                }
                SQLInvalidCursorNameException sQLInvalidCursorNameException = new SQLInvalidCursorNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("35".equals(_class)) {
                if (exception instanceof SQLInvalidConditionNumberException) {
                    return exception;
                }
                SQLInvalidConditionNumberException sQLInvalidConditionNumberException = new SQLInvalidConditionNumberException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("3C".equals(_class)) {
                if (exception instanceof SQLAmbiguousCursorNameException) {
                    return exception;
                }
                SQLAmbiguousCursorNameException sQLAmbiguousCursorNameException = new SQLAmbiguousCursorNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("3D".equals(_class)) {
                if (exception instanceof SQLInvalidCatalogNameException) {
                    return exception;
                }
                SQLInvalidCatalogNameException sQLInvalidCatalogNameException = new SQLInvalidCatalogNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("3F".equals(_class)) {
                if (exception instanceof SQLInvalidSchemaNameException) {
                    return exception;
                }
                SQLInvalidSchemaNameException sQLInvalidSchemaNameException = new SQLInvalidSchemaNameException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("40".equals(_class)) {
                if (exception instanceof SQLTransactionRollbackException) {
                    return exception;
                }
                SQLTransactionRollbackException sQLTransactionRollbackException = new SQLTransactionRollbackException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("42".equals(_class)) {
                if (exception instanceof SQLSyntaxErrorException) {
                    return exception;
                }
                SQLSyntaxErrorException sQLSyntaxErrorException = new SQLSyntaxErrorException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("55".equals(_class)) {
                if (exception instanceof SQLPrerequisiteStateException) {
                    return exception;
                }
                SQLPrerequisiteStateException sQLPrerequisiteStateException = new SQLPrerequisiteStateException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("57".equals(_class)) {
                if (exception instanceof SQLOperatorInterventionException) {
                    return exception;
                }
                SQLOperatorInterventionException sQLOperatorInterventionException = new SQLOperatorInterventionException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("53".equals(_class)) {
                if ("53000".equals(sqlState)) {
                    if (exception instanceof SQLInsufficientResourcesException) {
                        return exception;
                    }
                    SQLInsufficientResourcesException sQLInsufficientResourcesException = new SQLInsufficientResourcesException(exception.getMessage(), sqlState, exception.getErrorCode());
                    return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
                } else if ("53100".equals(sqlState)) {
                    if (exception instanceof SQLDiskFullException) {
                        return exception;
                    }
                    SQLDiskFullException sQLDiskFullException = new SQLDiskFullException(exception.getMessage(), sqlState, exception.getErrorCode());
                    return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
                } else if ("53200".equals(sqlState)) {
                    if (exception instanceof SQLOutOfMemoryException) {
                        return exception;
                    }
                    SQLOutOfMemoryException sQLOutOfMemoryException = new SQLOutOfMemoryException(exception.getMessage(), sqlState, exception.getErrorCode());
                    return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
                } else {
                    if (!"53300".equals(sqlState)) return SQLExceptions.unsupported(exception);
                    if (exception instanceof SQLTooManyConnectionsException) {
                        return exception;
                    }
                    SQLTooManyConnectionsException sQLTooManyConnectionsException = new SQLTooManyConnectionsException(exception.getMessage(), sqlState, exception.getErrorCode());
                }
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else if ("65".equals(_class) || "99".equals(_class) || "S1".equals(_class) && "S1009".equals(sqlState)) {
                if (exception instanceof SQLValueException) {
                    return exception;
                }
                SQLValueException sQLValueException = new SQLValueException(exception.getMessage(), sqlState, exception.getErrorCode());
                return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
            } else {
                if (!"XX".equals(_class)) return SQLExceptions.unsupported(exception);
                if (exception instanceof SQLInternalErrorException) {
                    return exception;
                }
                SQLInternalErrorException sQLInternalErrorException = new SQLInternalErrorException(exception.getMessage(), sqlState, exception.getErrorCode());
            }
        }
        return (SQLException)Throwables.copy((Throwable)exception, (Throwable)var1_34);
    }

    private static SQLException unsupported(SQLException exception) {
        exception.addSuppressed(new UnsupportedSQLException(exception));
        return exception;
    }

    private SQLExceptions() {
    }
}

