/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.Map;
import org.liblouis.Louis;
import org.liblouis.Translator;
import org.liblouis.WideChar;
import org.liblouis.WideString;

public interface DisplayTable {
    public Charset asCharset();

    public IOMode getMode();

    public Character encode(Character var1);

    public Character decode(Character var1);

    public String encode(String var1);

    public String decode(String var1);

    public static DisplayTable fromTable(String table) {
        return new DisplayTableFromTable(table, Fallback.REPORT);
    }

    public static DisplayTable fromTable(String table, Fallback virtualDotsFallback) {
        return new DisplayTableFromTable(table, virtualDotsFallback);
    }

    public static class DisplayTableFromTable
    implements DisplayTable {
        private final String table;
        private final Fallback virtualDotsFallback;
        private Charset charset = null;

        private DisplayTableFromTable(String table, Fallback virtualDotsFallback) {
            this.table = table;
            this.virtualDotsFallback = virtualDotsFallback != null ? virtualDotsFallback : Fallback.REPORT;
        }

        @Override
        public Charset asCharset() {
            if (this.charset == null) {
                this.charset = new CharsetFromTable(WideChar.SIZE, this.virtualDotsFallback);
            }
            return this.charset;
        }

        @Override
        public IOMode getMode() {
            return IOMode.DOTS_IO;
        }

        @Override
        public Character encode(Character c) {
            return Character.valueOf(this.encode("" + c).charAt(0));
        }

        @Override
        public Character decode(Character c) {
            return Character.valueOf(this.decode("" + c).charAt(0));
        }

        @Override
        public String encode(String s) {
            WideString inbuf;
            int length = s.length();
            try {
                inbuf = Translator.getWideCharBuffer("text-in", length).write(s);
            }
            catch (IOException e) {
                throw new RuntimeException("should not happen", e);
            }
            WideString outbuf = Translator.getWideCharBuffer("text-out", length);
            int mode = 0;
            if (Louis.getLibrary().lou_dotsToChar(this.table, inbuf, outbuf, length, mode) == 0) {
                throw new RuntimeException("lou_dotsToChar failed");
            }
            try {
                return outbuf.read(length);
            }
            catch (IOException e) {
                throw new RuntimeException("should not happen", e);
            }
        }

        @Override
        public String decode(String s) {
            WideString inbuf;
            int length = s.length();
            try {
                inbuf = Translator.getWideCharBuffer("text-in", length).write(s);
            }
            catch (IOException e) {
                throw new RuntimeException("should not happen", e);
            }
            WideString outbuf = Translator.getWideCharBuffer("text-out", length);
            int ucBrl = 64;
            if (Louis.getLibrary().lou_charToDots(this.table, inbuf, outbuf, length, ucBrl) == 0) {
                throw new RuntimeException("lou_charToDots failed");
            }
            try {
                return outbuf.read(length);
            }
            catch (IOException e) {
                throw new RuntimeException("should not happen", e);
            }
        }

        private class CharsetFromTable
        extends Charset {
            private final int charsize;
            private final Fallback virtualDotsFallback;

            private CharsetFromTable(int charsize, Fallback virtualDotsFallback) {
                super("LOU-DOTSIO-ASCII-" + charsize * 8, null);
                this.charsize = charsize;
                this.virtualDotsFallback = virtualDotsFallback;
            }

            @Override
            public boolean contains(Charset cs) {
                return this.equals(cs);
            }

            @Override
            public CharsetDecoder newDecoder() {
                return new DotsIODecoder();
            }

            @Override
            public CharsetEncoder newEncoder() {
                return new DotsIOEncoder();
            }

            private class DotsIODecoder
            extends CharsetDecoder {
                private DotsIODecoder() {
                    super(CharsetFromTable.this, 1.0f / (float)CharsetFromTable.this.charsize, 1.0f);
                    this.replaceWith("\u2800");
                }

                @Override
                protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                    int k = 0;
                    while (in.remaining() >= CharsetFromTable.this.charsize) {
                        byte b1 = in.get(k * CharsetFromTable.this.charsize + 1);
                        if ((b1 & 0x80) == 0) {
                            return CoderResult.malformedForLength(CharsetFromTable.this.charsize);
                        }
                        byte b2 = in.get(k * CharsetFromTable.this.charsize);
                        Character c = Character.valueOf((char)(b2 & 0xFF | b1 << 8));
                        if ((c = DisplayTableFromTable.this.encode(c)).charValue() == ' ' && (b2 & 0xFF) != 0) {
                            switch (((CharsetFromTable)CharsetFromTable.this).virtualDotsFallback.method) {
                                case REPLACE: {
                                    c = ((CharsetFromTable)CharsetFromTable.this).virtualDotsFallback.replacement;
                                    break;
                                }
                                case MASK: {
                                    c = Character.valueOf((char)(b2 & 0xFF | 0x8000));
                                    c = DisplayTableFromTable.this.encode(c);
                                    if (c.charValue() != ' ') break;
                                    return CoderResult.unmappableForLength(CharsetFromTable.this.charsize);
                                }
                                default: {
                                    return CoderResult.unmappableForLength(CharsetFromTable.this.charsize);
                                }
                            }
                        }
                        if (!out.hasRemaining()) {
                            return CoderResult.OVERFLOW;
                        }
                        if (c != null) {
                            out.put(c.charValue());
                        }
                        for (int i = 0; i < CharsetFromTable.this.charsize; ++i) {
                            in.get();
                        }
                        ++k;
                    }
                    return CoderResult.UNDERFLOW;
                }
            }

            private class DotsIOEncoder
            extends CharsetEncoder {
                private DotsIOEncoder() {
                    byte[] byArray;
                    float f = CharsetFromTable.this.charsize;
                    float f2 = CharsetFromTable.this.charsize;
                    if (CharsetFromTable.this.charsize == 2) {
                        byte[] byArray2 = new byte[2];
                        byArray2[0] = 0;
                        byArray = byArray2;
                        byArray2[1] = -128;
                    } else {
                        byte[] byArray3 = new byte[4];
                        byArray3[0] = 0;
                        byArray3[1] = -128;
                        byArray3[2] = 0;
                        byArray = byArray3;
                        byArray3[3] = 0;
                    }
                    super(CharsetFromTable.this, f, f2, byArray);
                }

                @Override
                protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
                    int k = 0;
                    while (in.hasRemaining()) {
                        char c = in.get(k++);
                        if ((c = DisplayTableFromTable.this.decode(Character.valueOf(c)).charValue()) < '\u2800' || c > '\u28ff') {
                            return CoderResult.unmappableForLength(1);
                        }
                        if (out.remaining() < CharsetFromTable.this.charsize) {
                            return CoderResult.OVERFLOW;
                        }
                        for (int i = 2; i < CharsetFromTable.this.charsize; ++i) {
                            out.put((byte)0);
                        }
                        out.put((byte)(c & 0xFF));
                        out.put((byte)-128);
                        in.get();
                    }
                    return CoderResult.UNDERFLOW;
                }
            }
        }
    }

    public static class UnicodeBrailleDisplayTable
    implements DisplayTable {
        private final Charset charset;

        public UnicodeBrailleDisplayTable(Fallback virtualDotsFallback) {
            this(virtualDotsFallback, null);
        }

        private UnicodeBrailleDisplayTable(Fallback virtualDotsFallback, Fallback eightDotsFallback) {
            if (virtualDotsFallback == null) {
                virtualDotsFallback = Fallback.REPORT;
            }
            this.charset = new UnicodeBrailleCharset(WideChar.SIZE, virtualDotsFallback);
        }

        @Override
        public Charset asCharset() {
            return this.charset;
        }

        @Override
        public IOMode getMode() {
            return IOMode.DOTS_IO;
        }

        @Override
        public Character encode(Character c) {
            return c;
        }

        @Override
        public Character decode(Character c) {
            return c;
        }

        @Override
        public String encode(String s) {
            return s;
        }

        @Override
        public String decode(String s) {
            return s;
        }

        private static class UnicodeBrailleCharset
        extends Charset {
            private final int charsize;
            private final Fallback virtualDotsFallback;

            private UnicodeBrailleCharset(int charsize, Fallback virtualDotsFallback) {
                super("LOU-DOTSIO-UNICODE-" + charsize * 8, null);
                this.charsize = charsize;
                this.virtualDotsFallback = virtualDotsFallback;
            }

            @Override
            public boolean contains(Charset cs) {
                return this.equals(cs);
            }

            @Override
            public CharsetDecoder newDecoder() {
                return new DotsIODecoder();
            }

            @Override
            public CharsetEncoder newEncoder() {
                return new DotsIOEncoder();
            }

            private class DotsIODecoder
            extends CharsetDecoder {
                private DotsIODecoder() {
                    super(UnicodeBrailleCharset.this, 1.0f / (float)UnicodeBrailleCharset.this.charsize, 1.0f);
                    this.replaceWith("\u2800");
                }

                @Override
                protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                    int k = 0;
                    while (in.remaining() >= UnicodeBrailleCharset.this.charsize) {
                        byte b1 = in.get(k * UnicodeBrailleCharset.this.charsize + 1);
                        if ((b1 & 0x80) == 0) {
                            return CoderResult.malformedForLength(UnicodeBrailleCharset.this.charsize);
                        }
                        byte b2 = in.get(k * UnicodeBrailleCharset.this.charsize);
                        Character c = Character.valueOf((char)(b2 & 0xFF | 0x2800));
                        if ((b1 & 0xFF) != 128) {
                            switch (((UnicodeBrailleCharset)UnicodeBrailleCharset.this).virtualDotsFallback.method) {
                                case REPLACE: {
                                    c = ((UnicodeBrailleCharset)UnicodeBrailleCharset.this).virtualDotsFallback.replacement;
                                    break;
                                }
                                case MASK: {
                                    break;
                                }
                                default: {
                                    return CoderResult.unmappableForLength(UnicodeBrailleCharset.this.charsize);
                                }
                            }
                        }
                        if (!out.hasRemaining()) {
                            return CoderResult.OVERFLOW;
                        }
                        if (c != null) {
                            out.put(c.charValue());
                        }
                        for (int i = 0; i < UnicodeBrailleCharset.this.charsize; ++i) {
                            in.get();
                        }
                        ++k;
                    }
                    return CoderResult.UNDERFLOW;
                }
            }

            private class DotsIOEncoder
            extends CharsetEncoder {
                private DotsIOEncoder() {
                    byte[] byArray;
                    float f = UnicodeBrailleCharset.this.charsize;
                    float f2 = UnicodeBrailleCharset.this.charsize;
                    if (UnicodeBrailleCharset.this.charsize == 2) {
                        byte[] byArray2 = new byte[2];
                        byArray2[0] = 0;
                        byArray = byArray2;
                        byArray2[1] = -128;
                    } else {
                        byte[] byArray3 = new byte[4];
                        byArray3[0] = 0;
                        byArray3[1] = -128;
                        byArray3[2] = 0;
                        byArray = byArray3;
                        byArray3[3] = 0;
                    }
                    super(UnicodeBrailleCharset.this, f, f2, byArray);
                }

                @Override
                protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
                    int k = 0;
                    while (in.hasRemaining()) {
                        char c;
                        if ((c = in.get(k++)) < '\u2800' || c > '\u28ff') {
                            return CoderResult.unmappableForLength(1);
                        }
                        if (out.remaining() < UnicodeBrailleCharset.this.charsize) {
                            return CoderResult.OVERFLOW;
                        }
                        for (int i = 2; i < UnicodeBrailleCharset.this.charsize; ++i) {
                            out.put((byte)0);
                        }
                        out.put((byte)(c & 0xFF));
                        out.put((byte)-128);
                        in.get();
                    }
                    return CoderResult.UNDERFLOW;
                }
            }
        }
    }

    public static final class Fallback {
        final FallbackMethod method;
        final Character replacement;
        private static Map<Character, Fallback> replacements = new HashMap<Character, Fallback>();
        public static final Fallback REPORT = new Fallback(FallbackMethod.REPORT);
        public static final Fallback MASK = new Fallback(FallbackMethod.MASK);

        private Fallback(FallbackMethod method) {
            this.method = method;
            this.replacement = null;
        }

        private Fallback(Character replacement) {
            this.method = FallbackMethod.REPLACE;
            this.replacement = replacement;
        }

        public String toString() {
            return (Object)((Object)this.method) + (this.method == FallbackMethod.REPLACE ? "-" + this.replacement : "");
        }

        public static Fallback REPLACE(Character replacement) {
            if (replacement == null) {
                throw new NullPointerException();
            }
            Fallback f = replacements.get(replacement);
            if (f == null) {
                f = new Fallback(replacement);
                replacements.put(replacement, f);
            }
            return f;
        }

        static enum FallbackMethod {
            REPLACE,
            REPORT,
            MASK;

        }
    }

    public static final class StandardDisplayTables {
        public static final DisplayTable DEFAULT = new DisplayTable(){
            Charset charset;

            @Override
            public Charset asCharset() {
                if (this.charset == null) {
                    this.charset = WideChar.SIZE == 2 ? Charset.forName("UTF-16LE") : Charset.forName("UTF-32LE");
                }
                return this.charset;
            }

            @Override
            public IOMode getMode() {
                return IOMode.DEFAULT;
            }

            @Override
            public Character encode(Character c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Character decode(Character c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String encode(String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String decode(String s) {
                throw new UnsupportedOperationException();
            }
        };
        public static final DisplayTable UNICODE = new UnicodeBrailleDisplayTable(Fallback.REPORT);

        private StandardDisplayTables() {
        }
    }

    public static enum IOMode {
        DEFAULT(0),
        DOTS_IO(4);

        private final int value;

        private IOMode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

