/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import com.sun.jna.Callback;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.liblouis.EmbeddedTableResolver;
import org.liblouis.Logger;
import org.liblouis.Table;
import org.liblouis.TableResolver;
import org.liblouis.WideString;
import org.slf4j.LoggerFactory;

public class Louis {
    private static File libraryPath = null;
    private static Lou_TableResolver lou_tableResolver = null;
    private static TableResolver tableResolver = null;
    private static boolean tableResolverIsRegistered = false;
    private static boolean tablesAreIndexed = false;
    private static final Map<String, URL> generatedTableNames = new HashMap<String, URL>();
    private static final Map<URL, File> tablesStoredToFile = new HashMap<URL, File>();
    private static final Map<File, URL> tablesStoredToFileInv = new HashMap<File, URL>();
    private static Logger logCallback = null;
    private static Lou_LogCallback lou_logCallback = null;
    private static boolean loggerIsRegistered = false;
    private static LouisLibrary INSTANCE;
    private static boolean standalone;
    private static final org.slf4j.Logger logger;

    public static void setLibraryPath(File path) {
        libraryPath = path;
    }

    static synchronized String getTableNameForURL(URL table) {
        int i = 1;
        while (true) {
            String name;
            if (!generatedTableNames.containsKey(name = "" + i)) {
                generatedTableNames.put(name, table);
                return name;
            }
            ++i;
        }
    }

    public static synchronized void setTableResolver(final TableResolver tableResolver) {
        Louis.tableResolver = tableResolver;
        lou_tableResolver = new Lou_TableResolver(){

            @Override
            public File[] invoke(String table, File base) {
                File[] ret = this._invoke(table, base);
                if (ret == null) {
                    Louis.log(Logger.Level.ERROR, "Cannot resolve table '%s'", table);
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private File[] _invoke(String table, File base) {
                File tableFile;
                URL tableURL;
                URL baseURL;
                if (base == null) {
                    baseURL = null;
                } else {
                    try {
                        base = base.getCanonicalFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    baseURL = (URL)tablesStoredToFileInv.get(base);
                    if (baseURL == null) {
                        baseURL = Louis.asURL(base);
                    }
                }
                if (base == null && generatedTableNames.containsKey(table)) {
                    tableURL = (URL)generatedTableNames.get(table);
                } else {
                    tableURL = tableResolver.resolve(table, baseURL);
                    if (tableURL == null) {
                        return null;
                    }
                }
                if (tablesStoredToFile.containsKey(tableURL)) {
                    tableFile = (File)tablesStoredToFile.get(tableURL);
                } else if (tableURL.toString().startsWith("file:")) {
                    tableFile = Louis.asFile(tableURL);
                    if (!tableFile.exists()) {
                        return null;
                    }
                } else {
                    InputStream in = null;
                    try {
                        in = tableURL.openStream();
                        tableFile = File.createTempFile("liblouis-java-", ".tbl");
                        tableFile.delete();
                        logger.trace("Copying " + tableURL + " to " + tableFile);
                        Files.copy(in, tableFile.toPath(), new CopyOption[0]);
                        tableFile.deleteOnExit();
                    }
                    catch (IOException e) {
                        File[] fileArray = null;
                        return fileArray;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        tableFile = tableFile.getCanonicalFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    tablesStoredToFile.put(tableURL, tableFile);
                    tablesStoredToFileInv.put(tableFile, tableURL);
                }
                return new File[]{tableFile};
            }
        };
        tableResolverIsRegistered = false;
    }

    public static synchronized void setLogger(final Logger logger) {
        logCallback = logger;
        lou_logCallback = new Lou_LogCallback(){

            @Override
            public void invoke(int level, String message) {
                logger.log(Logger.Level.from(level), message);
            }
        };
        loggerIsRegistered = false;
    }

    public static void setLogLevel(Logger.Level level) {
        Louis.getLibrary().lou_setLogLevel(level.value());
    }

    static void log(Logger.Level level, String format, Object ... args) {
        Slf4jLogger.INSTANCE.log(level, format, args);
        LouisLibrary lib = Louis.getLibrary();
        if (logCallback != null && !(logCallback instanceof Slf4jLogger)) {
            if (args.length > 0) {
                String[] message = new String[1 + args.length];
                message[0] = format;
                for (int i = 0; i < args.length; ++i) {
                    message[1 + i] = args[i].toString();
                }
                lib._lou_logMessage(level.value(), message);
            } else {
                lib._lou_logMessage(level.value(), format);
            }
        }
    }

    public static String getVersion() {
        return Louis.getLibrary().lou_version();
    }

    public static synchronized Set<Table> listTables() {
        HashSet<Table> tables = new HashSet<Table>();
        LouisLibrary lib = Louis.getLibrary();
        Louis.lazyIndexTables(lib);
        for (String t : lib.lou_listTables()) {
            tables.add(new Table(t));
        }
        return Collections.unmodifiableSet(tables);
    }

    static synchronized String findTable(String query) {
        LouisLibrary lib = Louis.getLibrary();
        Louis.lazyIndexTables(lib);
        return lib.lou_findTable(query);
    }

    private static void lazyIndexTables(LouisLibrary lib) {
        if (!tablesAreIndexed && tableResolver != null) {
            Set<String> allFiles = tableResolver.list();
            logger.debug("Indexing tables");
            lib.lou_indexTables(allFiles.toArray(new String[allFiles.size()]));
            tablesAreIndexed = true;
        }
    }

    static synchronized LouisLibrary getLibrary() {
        if (INSTANCE == null) {
            if (libraryPath == null) {
                try {
                    libraryPath = Native.extractFromResourcePath((String)(Platform.isWindows() ? "liblouis" : "louis"), (ClassLoader)Louis.class.getClassLoader());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                String name = libraryPath != null ? libraryPath.getCanonicalPath() : "louis";
                LouisLibrary unsynced = (LouisLibrary)Native.loadLibrary((String)name, LouisLibrary.class);
                INSTANCE = (LouisLibrary)Native.synchronizedLibrary((Library)unsynced);
                logger.debug("Loaded " + name + ": Liblouis v" + INSTANCE.lou_version() + " (UCS" + INSTANCE.lou_charSize() + ")");
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load liblouis", e);
            }
            finally {
                if (libraryPath != null && libraryPath.getName().startsWith("jna") && !libraryPath.delete()) {
                    try {
                        new File(libraryPath.getParentFile(), libraryPath.getName() + ".x").createNewFile();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (tableResolver == null && standalone) {
            try {
                Louis.setTableResolver(new EmbeddedTableResolver(logger));
            }
            catch (Throwable e) {
                standalone = false;
            }
        }
        if (logCallback == null) {
            Louis.setLogger(Slf4jLogger.INSTANCE);
        }
        if (lou_tableResolver != null && !tableResolverIsRegistered) {
            INSTANCE.lou_registerTableResolver(lou_tableResolver);
            tableResolverIsRegistered = true;
            tablesAreIndexed = false;
        }
        if (!loggerIsRegistered && lou_logCallback != null) {
            INSTANCE.lou_registerLogCallback(lou_logCallback);
            loggerIsRegistered = true;
        }
        return INSTANCE;
    }

    static File asFile(URL url) throws IllegalArgumentException {
        try {
            if (!"file".equals(url.getProtocol())) {
                throw new RuntimeException("expected file URL");
            }
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static URL asURL(File file) {
        try {
            file = file.getCanonicalFile();
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        standalone = true;
        logger = LoggerFactory.getLogger(Louis.class);
    }

    private static class Slf4jLogger
    implements Logger {
        static Slf4jLogger INSTANCE = new Slf4jLogger();

        private Slf4jLogger() {
        }

        @Override
        public void log(Logger.Level level, String message) {
            switch (level) {
                case DEBUG: {
                    logger.debug(message);
                    break;
                }
                case INFO: {
                    logger.info(message);
                    break;
                }
                case WARN: {
                    logger.warn(message);
                    break;
                }
                case FATAL: {
                    message = "FATAL: " + message;
                }
                case ERROR: {
                    logger.error(message);
                }
            }
        }

        void log(Logger.Level level, String format, Object ... args) {
            this.log(level, String.format(format, args));
        }
    }

    static class FileTypeMapper
    extends DefaultTypeMapper {
        static final FileTypeMapper INSTANCE = new FileTypeMapper();

        private FileTypeMapper() {
            TypeConverter converter = new TypeConverter(){

                public Class<?> nativeType() {
                    return String.class;
                }

                public Object toNative(Object file, ToNativeContext context) {
                    if (file == null) {
                        return null;
                    }
                    if (file instanceof File[]) {
                        File[] files = (File[])file;
                        String[] paths = new String[files.length];
                        for (int i = 0; i < files.length; ++i) {
                            paths[i] = (String)this.toNative(files[i], context);
                        }
                        return new StringArray(paths);
                    }
                    try {
                        return ((File)file).getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                public Object fromNative(Object file, FromNativeContext context) {
                    if (file == null) {
                        return null;
                    }
                    return new File(((Pointer)file).getString(0L));
                }
            };
            this.addToNativeConverter(File.class, (ToNativeConverter)converter);
            this.addToNativeConverter(File[].class, (ToNativeConverter)converter);
            this.addFromNativeConverter(File.class, (FromNativeConverter)converter);
        }
    }

    static interface Lou_LogCallback
    extends Callback {
        public void invoke(int var1, String var2);
    }

    static interface Lou_TableResolver
    extends Callback {
        public static final TypeMapper TYPE_MAPPER = FileTypeMapper.INSTANCE;

        public File[] invoke(String var1, File var2);
    }

    static interface LouisLibrary
    extends Library {
        public int lou_translate(String var1, WideString var2, IntByReference var3, WideString var4, IntByReference var5, short[] var6, byte[] var7, int[] var8, int[] var9, IntByReference var10, int var11);

        public int lou_backTranslate(String var1, WideString var2, IntByReference var3, WideString var4, IntByReference var5, short[] var6, byte[] var7, int[] var8, int[] var9, IntByReference var10, int var11);

        public int lou_hyphenate(String var1, WideString var2, int var3, byte[] var4, int var5);

        public int lou_dotsToChar(String var1, WideString var2, WideString var3, int var4, int var5);

        public int lou_charToDots(String var1, WideString var2, WideString var3, int var4, int var5);

        public int lou_charSize();

        public String lou_version();

        public Pointer lou_getTable(String var1);

        public void lou_registerTableResolver(Lou_TableResolver var1);

        public void lou_registerLogCallback(Lou_LogCallback var1);

        public void lou_setLogLevel(int var1);

        public int lou_indexTables(String[] var1);

        public String lou_findTable(String var1);

        public String lou_getTableInfo(String var1, String var2);

        public String[] lou_listTables();

        public void _lou_logMessage(int var1, String ... var2);

        public String[] lou_getEmphClasses(String var1);
    }
}

