/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.liblouis.CompilationException;
import org.liblouis.Logger;
import org.liblouis.Louis;
import org.liblouis.TableInfo;
import org.liblouis.Translator;

public class Table {
    private final String table;
    private final TableInfo info;
    private Translator translator = null;
    private static final Pattern QUERY_SYNTAX = Pattern.compile("^[\\s\\t]*([a-zA-Z0-9-._]+(:[a-zA-Z0-9-._]+)?)([\\s\\t]+[a-zA-Z0-9-._]+(:[a-zA-Z0-9-._]+)?)*[\\s\\t]*");

    Table(String table) {
        this.table = table;
        this.info = new TableInfo(table);
    }

    public String getIdentifier() {
        return this.table;
    }

    public TableInfo getInfo() {
        return this.info;
    }

    public Translator getTranslator() throws CompilationException {
        if (this.translator == null) {
            this.translator = new Translator(this.table);
        }
        return this.translator;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public static Table find(String query) throws IllegalArgumentException, NoSuchElementException {
        if (!QUERY_SYNTAX.matcher(query).matches()) {
            throw new IllegalArgumentException("Query does not have the right syntax: " + query);
        }
        Louis.log(Logger.Level.DEBUG, "Finding table for query ", query);
        String table = Louis.findTable(query);
        if (table == null) {
            throw new NoSuchElementException("No match found for query '" + query + "'");
        }
        return new Table(table);
    }
}

