/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.liblouis.Louis;

public class TableInfo {
    private final String table;
    private final Map<String, String> cache;
    private final Set<String> missingFields;

    public TableInfo(String table) {
        this.table = table;
        this.cache = new HashMap<String, String>();
        this.missingFields = new HashSet<String>();
    }

    public String get(String key) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (this.missingFields.contains(key)) {
            return null;
        }
        String value = Louis.getLibrary().lou_getTableInfo(this.table, key);
        if (value != null) {
            this.cache.put(key, value);
        } else {
            this.missingFields.add(key);
        }
        return value;
    }
}

