/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.charset.UnmappableCharacterException;
import org.liblouis.DisplayException;
import org.liblouis.DisplayTable;
import org.liblouis.WideString;

public class TranslationResult {
    private String braille = null;
    private int[] characterAttributes = null;
    private int[] interCharacterAttributes = null;

    TranslationResult(WideString outbuf, IntByReference outlen, int[] inputPos, int[] characterAttributes, int[] interCharacterAttributes, DisplayTable displayTable) throws DisplayException {
        int len = outlen.getValue();
        try {
            this.braille = outbuf.read(len, displayTable);
        }
        catch (UnmappableCharacterException e) {
            throw new DisplayException("unmappable dot pattern present in output", e);
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
        if (characterAttributes != null) {
            this.characterAttributes = new int[len];
            for (int outpos = 0; outpos < len; ++outpos) {
                this.characterAttributes[outpos] = characterAttributes[inputPos[outpos]];
            }
        }
        if (interCharacterAttributes != null && len > 0) {
            this.interCharacterAttributes = new int[len - 1];
            int inpos = 0;
            for (int outpos = 1; outpos < len; ++outpos) {
                int new_inpos = inputPos[outpos];
                if (new_inpos < inpos) {
                    throw new RuntimeException();
                }
                this.interCharacterAttributes[outpos - 1] = new_inpos > inpos ? interCharacterAttributes[new_inpos - 1] : 0;
                inpos = new_inpos;
            }
        }
    }

    public String getBraille() {
        return this.braille;
    }

    public int[] getCharacterAttributes() {
        return this.characterAttributes;
    }

    public int[] getInterCharacterAttributes() {
        return this.interCharacterAttributes;
    }
}

