/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.navigation.api;

import androidx.lifecycle.ViewModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nypl.simplified.navigation.api.NavigationControllerDirectoryType;
import org.nypl.simplified.navigation.api.NavigationControllerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J'\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\tH\u0016\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\f*\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\tH\u0016J-\u0010\u0011\u001a\u00020\u0010\"\b\b\u0000\u0010\f*\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\t2\u0006\u0010\u0013\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/nypl/simplified/navigation/api/NavigationControllerViewModel;", "Landroidx/lifecycle/ViewModel;", "Lorg/nypl/simplified/navigation/api/NavigationControllerDirectoryType;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "navigationControllers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Lorg/nypl/simplified/navigation/api/NavigationControllerType;", "navigationControllerIfAvailable", "T", "navigationClass", "(Ljava/lang/Class;)Lorg/nypl/simplified/navigation/api/NavigationControllerType;", "removeNavigationController", "", "updateNavigationController", "navigationInterface", "navigationInstance", "(Ljava/lang/Class;Lorg/nypl/simplified/navigation/api/NavigationControllerType;)V", "simplified-ui-navigation-api_release"})
public final class NavigationControllerViewModel
extends ViewModel
implements NavigationControllerDirectoryType {
    private final Logger logger = LoggerFactory.getLogger(NavigationControllerViewModel.class);
    private final ConcurrentHashMap<Class<?>, NavigationControllerType> navigationControllers = new ConcurrentHashMap();

    @Override
    @Nullable
    public <T extends NavigationControllerType> T navigationControllerIfAvailable(@NotNull Class<T> navigationClass) {
        Intrinsics.checkNotNullParameter(navigationClass, (String)"navigationClass");
        return (T)this.navigationControllers.get(navigationClass);
    }

    @Override
    public <T extends NavigationControllerType> void removeNavigationController(@NotNull Class<T> navigationClass) {
        Intrinsics.checkNotNullParameter(navigationClass, (String)"navigationClass");
        this.logger.debug("removing navigation controller: {}", navigationClass);
        this.navigationControllers.remove(navigationClass);
    }

    @Override
    public <T extends NavigationControllerType> void updateNavigationController(@NotNull Class<T> navigationInterface, @NotNull T navigationInstance) {
        Intrinsics.checkNotNullParameter(navigationInterface, (String)"navigationInterface");
        Intrinsics.checkNotNullParameter(navigationInstance, (String)"navigationInstance");
        this.logger.debug("updating navigation controller: {} ({})", navigationInterface, navigationInstance);
        ((Map)this.navigationControllers).put(navigationInterface, navigationInstance);
    }

    @Override
    @NotNull
    public <T extends NavigationControllerType> T navigationController(@NotNull Class<T> navigationClass) {
        Intrinsics.checkNotNullParameter(navigationClass, (String)"navigationClass");
        return NavigationControllerDirectoryType.DefaultImpls.navigationController(this, navigationClass);
    }
}

