/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.lang.IllegalArgumentException;

final class ConnectionDescriptor {
    private String host = null;
    private int port = 6001;
    private int backlog = 50;
    private Boolean tcpNoDelay = null;

    public ConnectionDescriptor(String description) throws IllegalArgumentException {
        int i = description.indexOf(44);
        while (i >= 0) {
            int j = description.indexOf(44, i + 1);
            int k = j < 0 ? description.length() : j;
            int l = description.indexOf(61, i + 1);
            if (l < 0 || l >= k) {
                throw new IllegalArgumentException("parameter lacks '='");
            }
            String key = description.substring(i + 1, l);
            String value = description.substring(l + 1, k);
            if (key.equalsIgnoreCase("host")) {
                this.host = value;
            } else if (key.equalsIgnoreCase("port")) {
                try {
                    this.port = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e);
                }
                if (this.port < 0 || this.port > 65535) {
                    throw new IllegalArgumentException("port parameter must have value between 0 and 65535, inclusive");
                }
            } else if (key.equalsIgnoreCase("backlog")) {
                try {
                    this.backlog = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e);
                }
            } else if (key.equalsIgnoreCase("tcpnodelay")) {
                if (value.equals("0")) {
                    this.tcpNoDelay = Boolean.FALSE;
                } else if (value.equals("1")) {
                    this.tcpNoDelay = Boolean.TRUE;
                } else {
                    throw new IllegalArgumentException("tcpnodelay parameter must have 0/1 value");
                }
            }
            i = j;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }
}

