/*
 * Decompiled with CFR 0.152.
 */
package org.lighthousegames.logging;

import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lighthousegames.logging.FixedLogLevel;
import org.lighthousegames.logging.LogFactory;
import org.lighthousegames.logging.LogLevel;
import org.lighthousegames.logging.Logger;
import org.lighthousegames.logging.MutableLogLevelController;
import org.lighthousegames.logging.Platform;
import org.lighthousegames.logging.PlatformLogger;
import org.lighthousegames.logging.TagProvider;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u001e\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\"J\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"J\"\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"J\u0010\u0010+\u001a\u00020\u001d2\b\u0010,\u001a\u0004\u0018\u00010\u0017J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u001f\u0010.\u001a\u00020\u001d2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0/\"\u00020\u001a\u00a2\u0006\u0002\u00100J\u0006\u00101\u001a\u00020\u001dJ\u0016\u00102\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"J\"\u00103\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0005\"\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0005\"\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0005\"\u0004\b\u000f\u0010\u0007R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/lighthousegames/logging/KmLogging;", "", "()V", "isLoggingDebug", "", "()Z", "setLoggingDebug", "(Z)V", "isLoggingError", "setLoggingError", "isLoggingInfo", "setLoggingInfo", "isLoggingVerbose", "setLoggingVerbose", "isLoggingWarning", "setLoggingWarning", "logFactory", "Lorg/lighthousegames/logging/LogFactory;", "getLogFactory", "()Lorg/lighthousegames/logging/LogFactory;", "setLogFactory", "(Lorg/lighthousegames/logging/LogFactory;)V", "logLevel", "Lorg/lighthousegames/logging/LogLevel;", "loggers", "Ljava/util/ArrayList;", "Lorg/lighthousegames/logging/Logger;", "Lkotlin/collections/ArrayList;", "addLogger", "", "logger", "clear", "createTag", "Lkotlin/Pair;", "", "fromClass", "debug", "tag", "msg", "error", "t", "", "info", "setLogLevel", "level", "setLogLevelFor", "setLoggers", "", "([Lorg/lighthousegames/logging/Logger;)V", "setupLoggingFlags", "verbose", "warn", "logging"})
public final class KmLogging {
    private static final ArrayList<Logger> loggers;
    private static boolean isLoggingVerbose;
    private static boolean isLoggingDebug;
    private static boolean isLoggingInfo;
    private static boolean isLoggingWarning;
    private static boolean isLoggingError;
    private static LogLevel logLevel;
    @Nullable
    private static LogFactory logFactory;
    @NotNull
    public static final KmLogging INSTANCE;

    public final boolean isLoggingVerbose() {
        return isLoggingVerbose;
    }

    public final void setLoggingVerbose(boolean bl) {
        isLoggingVerbose = bl;
    }

    public final boolean isLoggingDebug() {
        return isLoggingDebug;
    }

    public final void setLoggingDebug(boolean bl) {
        isLoggingDebug = bl;
    }

    public final boolean isLoggingInfo() {
        return isLoggingInfo;
    }

    public final void setLoggingInfo(boolean bl) {
        isLoggingInfo = bl;
    }

    public final boolean isLoggingWarning() {
        return isLoggingWarning;
    }

    public final void setLoggingWarning(boolean bl) {
        isLoggingWarning = bl;
    }

    public final boolean isLoggingError() {
        return isLoggingError;
    }

    public final void setLoggingError(boolean bl) {
        isLoggingError = bl;
    }

    @Nullable
    public final LogFactory getLogFactory() {
        return logFactory;
    }

    public final void setLogFactory(@Nullable LogFactory logFactory) {
        KmLogging.logFactory = logFactory;
    }

    public final void setLoggers(Logger ... loggers) {
        Intrinsics.checkNotNullParameter((Object)loggers, (String)"loggers");
        KmLogging.loggers.clear();
        for (Logger logger : loggers) {
            KmLogging.loggers.add(logger);
            this.setLogLevelFor(logger);
        }
        this.setupLoggingFlags();
    }

    public final void clear() {
        loggers.clear();
    }

    public final void addLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        loggers.add(logger);
        this.setLogLevelFor(logger);
        this.setupLoggingFlags();
    }

    private final void setLogLevelFor(Logger logger) {
        LogLevel currentLevel = logLevel;
        if (currentLevel != null) {
            if (logger instanceof MutableLogLevelController) {
                ((MutableLogLevelController)((Object)logger)).setLogLevel(currentLevel);
            } else if (logger instanceof PlatformLogger && ((PlatformLogger)logger).getLogLevel() instanceof MutableLogLevelController) {
                ((MutableLogLevelController)((PlatformLogger)logger).getLogLevel()).setLogLevel(currentLevel);
            }
        }
    }

    public final void setLogLevel(@Nullable LogLevel level) {
        logLevel = level;
        if (level != null) {
            Iterator<Logger> iterator = loggers.iterator();
            while (iterator.hasNext()) {
                Logger logger;
                Logger logger2 = logger = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
                this.setLogLevelFor(logger2);
            }
            this.setupLoggingFlags();
        }
    }

    public final void setupLoggingFlags() {
        isLoggingVerbose = false;
        isLoggingDebug = false;
        isLoggingInfo = false;
        isLoggingWarning = false;
        isLoggingError = false;
        for (Logger logger : loggers) {
            if (logger.isLoggingVerbose()) {
                isLoggingVerbose = true;
            }
            if (logger.isLoggingDebug()) {
                isLoggingDebug = true;
            }
            if (logger.isLoggingInfo()) {
                isLoggingInfo = true;
            }
            if (logger.isLoggingWarning()) {
                isLoggingWarning = true;
            }
            if (!logger.isLoggingError()) continue;
            isLoggingError = true;
        }
    }

    public final void verbose(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        for (Logger logger : loggers) {
            if (!logger.isLoggingVerbose()) continue;
            logger.verbose(tag, msg);
        }
    }

    public final void debug(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        for (Logger logger : loggers) {
            if (!logger.isLoggingDebug()) continue;
            logger.debug(tag, msg);
        }
    }

    public final void info(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        for (Logger logger : loggers) {
            if (!logger.isLoggingInfo()) continue;
            logger.info(tag, msg);
        }
    }

    public final void warn(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        for (Logger logger : loggers) {
            if (!logger.isLoggingWarning()) continue;
            logger.warn(tag, msg, t);
        }
    }

    public static /* synthetic */ void warn$default(KmLogging kmLogging, String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        kmLogging.warn(string, string2, throwable);
    }

    public final void error(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        for (Logger logger : loggers) {
            if (!logger.isLoggingError()) continue;
            logger.error(tag, msg, t);
        }
    }

    public static /* synthetic */ void error$default(KmLogging kmLogging, String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        kmLogging.error(string, string2, throwable);
    }

    @NotNull
    public final Pair<String, String> createTag(@Nullable String fromClass) {
        for (Logger logger : loggers) {
            if (!(logger instanceof TagProvider)) continue;
            return ((TagProvider)((Object)logger)).createTag(fromClass);
        }
        return new Pair((Object)"", (Object)"");
    }

    public static /* synthetic */ Pair createTag$default(KmLogging kmLogging, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return kmLogging.createTag(string);
    }

    private KmLogging() {
    }

    static {
        KmLogging kmLogging;
        INSTANCE = kmLogging = new KmLogging();
        loggers = new ArrayList();
        isLoggingVerbose = true;
        isLoggingDebug = true;
        isLoggingInfo = true;
        isLoggingWarning = true;
        isLoggingError = true;
        loggers.add(new PlatformLogger(new FixedLogLevel((Function0<Boolean>)((Function0)new Function0<Boolean>(Platform.INSTANCE){

            public final boolean invoke() {
                return ((Platform)this.receiver).isDebug();
            }
        }))));
    }
}

