/*
 * Decompiled with CFR 0.152.
 */
package org.lighthousegames.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lighthousegames.logging.KmLogging;
import org.lighthousegames.logging.LogLevelController;
import org.lighthousegames.logging.Logger;
import org.lighthousegames.logging.Slf4jLogFactory;
import org.lighthousegames.logging.TagProvider;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J$\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u0016\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u0017\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u0019\u001a\u00020\u0015H\u0096\u0001J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J$\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/lighthousegames/logging/PlatformLogger;", "Lorg/lighthousegames/logging/Logger;", "Lorg/lighthousegames/logging/TagProvider;", "Lorg/lighthousegames/logging/LogLevelController;", "logLevel", "(Lorg/lighthousegames/logging/LogLevelController;)V", "getLogLevel", "()Lorg/lighthousegames/logging/LogLevelController;", "createTag", "Lkotlin/Pair;", "", "fromClass", "debug", "", "tag", "msg", "error", "t", "", "info", "isLoggingDebug", "", "isLoggingError", "isLoggingInfo", "isLoggingVerbose", "isLoggingWarning", "verbose", "warn", "Companion", "logging"})
public class PlatformLogger
implements Logger,
TagProvider,
LogLevelController {
    @NotNull
    private final LogLevelController logLevel;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void verbose(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    public void debug(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    public void info(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    public void warn(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    public void error(@NotNull String tag, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    @Override
    @NotNull
    public Pair<String, String> createTag(@Nullable String fromClass) {
        String clsName = Companion.findClassName(fromClass);
        return new Pair((Object)PlatformLogger.Companion.getTag(clsName), (Object)clsName);
    }

    @NotNull
    public final LogLevelController getLogLevel() {
        return this.logLevel;
    }

    public PlatformLogger(@NotNull LogLevelController logLevel) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        this.logLevel = logLevel;
        if (KmLogging.INSTANCE.getLogFactory() != null) {
            String string = "WARNING: existing logFactory is being overwritten by JVM PlatformLogger. Was " + KmLogging.INSTANCE.getLogFactory();
            boolean bl = false;
            System.out.println((Object)string);
        }
        KmLogging.INSTANCE.setLogFactory(new Slf4jLogFactory());
    }

    @Override
    public boolean isLoggingDebug() {
        return this.logLevel.isLoggingDebug();
    }

    @Override
    public boolean isLoggingError() {
        return this.logLevel.isLoggingError();
    }

    @Override
    public boolean isLoggingInfo() {
        return this.logLevel.isLoggingInfo();
    }

    @Override
    public boolean isLoggingVerbose() {
        return this.logLevel.isLoggingVerbose();
    }

    @Override
    public boolean isLoggingWarning() {
        return this.logLevel.isLoggingWarning();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lorg/lighthousegames/logging/PlatformLogger$Companion;", "", "()V", "findClassName", "", "fromClass", "getTag", "fullClassName", "logging"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String findClassName(@Nullable String fromClass) {
            void $this$mapTo$iv$iv;
            String clsName = "";
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"Thread.currentThread().stackTrace");
            StackTraceElement[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            StackTraceElement[] stackTraceElementArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var9_10 = $this$mapTo$iv$iv;
            int n = ((void)var9_10).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_17 = item$iv$iv = var9_10[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                String string = v2.getClassName();
                collection.add(string);
            }
            List stack = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = stack;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stackEntry;
                int n2 = index$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n2;
                boolean bl = false;
                void v3 = stackEntry;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"stackEntry");
                if (StringsKt.endsWith$default((String)v3, (String)"KmLogKt", (boolean)false, (int)2, null) && stack.size() > index) {
                    Object e = stack.get(index + 1);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"stack[index + 1]");
                    clsName = (String)e;
                }
                if (fromClass == null || !StringsKt.endsWith$default((String)stackEntry, (String)fromClass, (boolean)false, (int)2, null) || stack.size() <= index) continue;
                Object e = stack.get(index + 1);
                Intrinsics.checkNotNullExpressionValue(e, (String)"stack[index + 1]");
                clsName = (String)e;
            }
            return clsName;
        }

        private final String getTag(String fullClassName) {
            int pos = StringsKt.lastIndexOf$default((CharSequence)fullClassName, (char)'.', (int)0, (boolean)false, (int)6, null);
            pos = pos < 0 ? 0 : pos + 1;
            String string = fullClassName;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

