/*
 * Decompiled with CFR 0.152.
 */
package org.lighthousegames.logging;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lighthousegames.logging.KmLogging;
import org.lighthousegames.logging.Platform;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0012\u001a\u00020\fJ\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u001c\u0010\u0018\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0086\b\u00f8\u0001\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"Lorg/lighthousegames/logging/TimingLog;", "", "label", "", "tag", "(Ljava/lang/String;Ljava/lang/String;)V", "tagName", "timing", "Ljava/util/ArrayList;", "Lorg/lighthousegames/logging/TimingLog$Timing;", "Lkotlin/collections/ArrayList;", "add", "", "msg", "isVerbose", "", "debug", "Lkotlin/Function0;", "finish", "msDiff", "nano1", "", "nano2", "reset", "verbose", "Companion", "Timing", "logging"})
public final class TimingLog {
    private final String tagName;
    private final ArrayList<Timing> timing;
    private final String label;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void add(@NotNull String msg, boolean isVerbose) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.timing.add(new Timing(Platform.INSTANCE.getTimeNanos(), msg, isVerbose));
    }

    public final void verbose(@NotNull Function0<? extends Object> msg) {
        int $i$f$verbose = 0;
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (KmLogging.INSTANCE.isLoggingVerbose()) {
            this.add(String.valueOf(msg.invoke()), true);
        }
    }

    public final void debug(@NotNull Function0<? extends Object> msg) {
        int $i$f$debug = 0;
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (KmLogging.INSTANCE.isLoggingDebug()) {
            this.add(String.valueOf(msg.invoke()), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void finish() {
        if (KmLogging.INSTANCE.isLoggingDebug() || this.timing.size() > 1) {
            long first;
            KmLogging.INSTANCE.debug(this.tagName, this.label + ": begin TimingLog");
            long now = first = this.timing.get(0).getTime();
            long prevDebug = first;
            long prev = first;
            int n = 1;
            int n2 = this.timing.size();
            while (n < n2) {
                Timing t;
                void i;
                Intrinsics.checkNotNullExpressionValue((Object)this.timing.get((int)i), (String)"timing[i]");
                now = t.getTime();
                String msg = t.getMsg();
                String indent = t.isVerbose() ? "         " : "     ";
                String timeStr = t.isVerbose() ? this.msDiff(now, prev) : this.msDiff(now, prevDebug);
                KmLogging.INSTANCE.debug(this.tagName, this.label + ':' + indent + timeStr + ' ' + msg);
                prev = now;
                if (!t.isVerbose()) {
                    prevDebug = now;
                }
                ++i;
            }
            KmLogging.INSTANCE.debug(this.tagName, this.label + ": end " + this.msDiff(now, first));
        }
        this.reset();
    }

    private final void reset() {
        this.timing.clear();
        this.add("", false);
    }

    private final String msDiff(long nano1, long nano2) {
        float diff = (float)(nano1 - nano2) / 1000000.0f;
        return Companion.truncateDecimal(diff, 3) + " ms";
    }

    public TimingLog(@NotNull String label, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.label = label;
        String string = tag;
        if (string == null) {
            string = (String)KmLogging.INSTANCE.createTag("TimingLog").getFirst();
        }
        this.tagName = string;
        this.timing = new ArrayList();
        this.add("", false);
    }

    public /* synthetic */ TimingLog(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/lighthousegames/logging/TimingLog$Timing;", "", "time", "", "msg", "", "isVerbose", "", "(JLjava/lang/String;Z)V", "()Z", "getMsg", "()Ljava/lang/String;", "getTime", "()J", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "logging"})
    public static final class Timing {
        private final long time;
        @NotNull
        private final String msg;
        private final boolean isVerbose;

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final String getMsg() {
            return this.msg;
        }

        public final boolean isVerbose() {
            return this.isVerbose;
        }

        public Timing(long time, @NotNull String msg, boolean isVerbose) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.time = time;
            this.msg = msg;
            this.isVerbose = isVerbose;
        }

        public final long component1() {
            return this.time;
        }

        @NotNull
        public final String component2() {
            return this.msg;
        }

        public final boolean component3() {
            return this.isVerbose;
        }

        @NotNull
        public final Timing copy(long time, @NotNull String msg, boolean isVerbose) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            return new Timing(time, msg, isVerbose);
        }

        public static /* synthetic */ Timing copy$default(Timing timing, long l, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                l = timing.time;
            }
            if ((n & 2) != 0) {
                string = timing.msg;
            }
            if ((n & 4) != 0) {
                bl = timing.isVerbose;
            }
            return timing.copy(l, string, bl);
        }

        @NotNull
        public String toString() {
            return "Timing(time=" + this.time + ", msg=" + this.msg + ", isVerbose=" + this.isVerbose + ")";
        }

        public int hashCode() {
            String string = this.msg;
            int n = (Long.hashCode(this.time) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.isVerbose ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Timing)) break block3;
                    Timing timing = (Timing)object;
                    if (this.time != timing.time || !Intrinsics.areEqual((Object)this.msg, (Object)timing.msg) || this.isVerbose != timing.isVerbose) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/lighthousegames/logging/TimingLog$Companion;", "", "()V", "truncateDecimal", "", "num", "", "decPlaces", "", "logging"})
    public static final class Companion {
        @NotNull
        public final String truncateDecimal(float num, int decPlaces) {
            String string;
            String str = String.valueOf(num);
            int dotPos = StringsKt.indexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotPos >= 0 && dotPos < str.length() - decPlaces) {
                int n = 0;
                string = StringsKt.substring((String)str, (IntRange)new IntRange(n, dotPos + decPlaces));
            } else {
                string = str;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

